/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PSAppTuxQTest
extends GenericTest {
    int i_measureCnt = 2;
    private ArrayList al_fileData;
    private Double D_minusOne = new Double(-1.0);
    private static final long msPerSecond = 1000L;

    public PSAppTuxQTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.i_measureCnt);
        this.clearLocFile();
    }

    private void clearLocFile() {
        try {
            String string = this.getValueForParam("APPNAME");
            String string2 = EgConfigInfo.egAgentConfigDir + string + ".read.loc";
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = this.getValueForParam("APPNAME");
        this.al_fileData = new ArrayList();
        this.readFile(string);
        Properties properties = this.getMetrics();
        if (properties == null || properties.size() == 0) {
            this.logToErrorFile("Error", "PSAppTuxQTest", "Could not get service metrics for app - " + string);
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Properties properties2 = (Properties)properties.get(string2);
            if (properties2 == null || properties2.size() == 0) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(this.D_minusOne);
                arrayList.add(this.D_minusOne);
                this.addNewMeasure(string2, arrayList);
                continue;
            }
            double d = -1.0;
            double d2 = -1.0;
            try {
                d = Double.parseDouble(properties2.getProperty("NOOFSVRSONQ"));
                d2 = Double.parseDouble(properties2.getProperty("WKQUEUED"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            this.addNewMeasure(string2, arrayList);
        }
    }

    private long getDiffInSeconds(Date date, Date date2) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = -1L;
        l3 = l - l2 >= 0L ? (l - l2) / 1000L : (l2 - l) / 1000L;
        return l3;
    }

    private void readFile(String string) {
        String string2 = EgConfigInfo.egAgentConfigDir + string + ".write.loc";
        String string3 = EgConfigInfo.egAgentConfigDir + string + ".read.loc";
        String string4 = EgConfigInfo.egAgentConfigDir + string + ".pq";
        int n = 1000;
        try {
            File file = new File(string2);
            int n2 = 0;
            while (file.exists()) {
                try {
                    System.out.println("The program is writing the file that i am supposed to read. So waiting for it to finish....");
                    Thread.sleep(50L);
                    if ((n2 += 50) < n) continue;
                    this.logToErrorFile("ERROR", "PSAppTuxQTest", "Waited too long to read the file but it still locked. Giving up....");
                    return;
                }
                catch (Exception exception) {
                }
            }
            File file2 = new File(string3);
            while (!file2.createNewFile()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            File file3 = new File(string4);
            if (file3.exists()) {
                long l = file3.lastModified();
                long l2 = this.getDiffInSeconds(new Date(), new Date(l));
                if ((double)l2 > 2.0 * this.timeSinceLastTest) {
                    this.logToErrorFile("ERROR", "PSAppTuxQTest", "File to be read - " + string + ".pq - is not getting updated.");
                    if (file2.exists()) {
                        file2.delete();
                    }
                    return;
                }
            } else {
                this.logToErrorFile("ERROR", "PSAppTuxQTest", "File to be read - " + string + ".pq - does not exists.");
                if (file2.exists()) {
                    file2.delete();
                }
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string4)));
            String string5 = "";
            while ((string5 = bufferedReader.readLine()) != null) {
                System.out.println(string5);
                this.al_fileData.add(string5);
            }
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Properties getMetrics() {
        if (this.al_fileData == null || this.al_fileData.size() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < this.al_fileData.size(); ++i) {
            String string = (String)this.al_fileData.get(i);
            if (string.startsWith(">") || string.startsWith("-") || string.equals("")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            String string8 = stringTokenizer.nextToken();
            String string9 = string8 + "_" + string2 + "_" + string3;
            Properties properties2 = new Properties();
            properties2.setProperty("NOOFSVRSONQ", string4);
            properties2.setProperty("WKQUEUED", string6);
            properties.put(string9, properties2);
        }
        return properties;
    }
}

