/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTransTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private static String queryStmt2 = "SELECT NAME, VALUE FROM V$SYSSTAT WHERE  NAME IN ('user commits','user rollbacks')";
    private double currCommits = -1.0;
    private double currRollbacks = -1.0;
    private double prevRollbacks = -1.0;
    private double prevCommits = -1.0;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public static void main(String[] stringArray) {
        OraTransTest oraTransTest = new OraTransTest(stringArray);
        oraTransTest.computeMeasures(new Hashtable());
    }

    public OraTransTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        try {
            object = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (object == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTransTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                return;
            }
            object2 = statement.executeQuery(queryStmt2);
            while (object2.next()) {
                string = object2.getString(1);
                if (string.equalsIgnoreCase("user commits")) {
                    this.currCommits = object2.getDouble(2);
                    continue;
                }
                if (!string.equalsIgnoreCase("user rollbacks")) continue;
                this.currRollbacks = object2.getDouble(2);
            }
            object2.close();
            statement.close();
            object.close();
            double d = this.currCommits - this.prevCommits;
            if (this.prevCommits < 0.0) {
                d = -1.0;
            }
            double d2 = this.currRollbacks - this.prevRollbacks;
            if (this.prevRollbacks < 0.0) {
                d2 = -1.0;
            }
            d = d < 0.0 ? -5.0 : d;
            d2 = d2 < 0.0 ? -5.0 : d2;
            this.prevCommits = this.currCommits;
            this.prevRollbacks = this.currRollbacks;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            if (d < 0.0 || d2 < 0.0) {
                arrayList.add(new Double(-5.0));
            } else {
                double d3 = d + d2;
                if (d3 == 0.0) {
                    arrayList.add(new Double(0.0));
                } else {
                    double d4 = d2 * 100.0 / d3;
                    arrayList.add(new Double(d4));
                }
            }
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception8) {
                    // empty catch block
                }
            }
            this.prevCommits = -1.0;
            this.prevRollbacks = -1.0;
            this.errorMsg = new String("Exception while executing  OraTransTest for target: " + this.targetHost);
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

