/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraTranWorkloadTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private Connection conn = null;
    private double defValue = -1.0;
    private boolean isFirstTime = true;
    ArrayList prevList = new ArrayList();
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public OraTranWorkloadTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(12);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        String string2 = "";
        object = new ArrayList();
        string = "select value redo_size_bytes from v$sysstat where name='redo size'";
        String string3 = "select value logical_reads_count from v$sysstat where name='session logical reads'";
        String string4 = "select value block_changes_count from v$sysstat where name='db block changes'";
        String string5 = "select value physical_reads_count from v$sysstat where name='physical reads'";
        String string6 = "select value physical_writes_count from v$sysstat where name='physical writes'";
        String string7 = "select value user_calls_count from v$sysstat where name='user calls'";
        String string8 = "select value parse_count from v$sysstat where name='parse count (total)'";
        String string9 = "select value hard_parse_count from v$sysstat where name ='parse count (hard)'";
        String string10 = "select value/1024 WA_memory_MB from v$sysstat where name='workarea memory allocated'";
        String string11 = "select value as count_in_number from v$sysstat where lower(name) ='logons cumulative'";
        String string12 = "select value execute_count from v$sysstat where name='execute count'";
        String string13 = "select value transaction_rollbacks_count from v$sysstat where name='transaction rollbacks'";
        String string14 = "select sum(value) from v$sysstat where NAME in ('user commits','transaction rollbacks')";
        try {
            try {
                if (this.isMultitenantDb && !this.isCDB) {
                    System.out.println("OraTranWorkloadTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                    this.conn = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                } else {
                    System.out.println("OraTranWorkloadTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                    this.conn = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("[OraTranWorkloadTest] compute Measure()", "failed to connect database targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                this.closeStmt((Statement)object2);
                this.closeConn(this.conn);
                return;
            }
            if (this.conn == null) {
                System.out.println("OraTranWorkloadTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = this.conn.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTranWorkloadTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.closeConn(this.conn);
                this.closeStmt((Statement)object2);
                this.closeConn(this.conn);
                return;
            }
            double d = this.executeQry((Statement)object2, string);
            double d2 = this.executeQry((Statement)object2, string3);
            double d3 = this.executeQry((Statement)object2, string4);
            double d4 = this.executeQry((Statement)object2, string5);
            double d5 = this.executeQry((Statement)object2, string6);
            double d6 = this.executeQry((Statement)object2, string7);
            double d7 = this.executeQry((Statement)object2, string8);
            double d8 = this.executeQry((Statement)object2, string9);
            double d9 = this.executeQry((Statement)object2, string10);
            double d10 = this.executeQry((Statement)object2, string11);
            double d11 = this.executeQry((Statement)object2, string12);
            double d12 = this.executeQry((Statement)object2, string13);
            double d13 = this.executeQry((Statement)object2, string14);
            if (this.isFirstTime) {
                this.isFirstTime = false;
                object = new ArrayList<Double>();
                for (int i = 0; i < this.measureCount; ++i) {
                    ((ArrayList)object).add(new Double(-5.0));
                }
            } else if (this.prevList != null && this.prevList.size() > 0) {
                double d14 = (Double)this.prevList.get(0);
                double d15 = (Double)this.prevList.get(1);
                double d16 = (Double)this.prevList.get(2);
                double d17 = (Double)this.prevList.get(3);
                double d18 = (Double)this.prevList.get(4);
                double d19 = (Double)this.prevList.get(5);
                double d20 = (Double)this.prevList.get(6);
                double d21 = (Double)this.prevList.get(7);
                double d22 = (Double)this.prevList.get(8);
                double d23 = (Double)this.prevList.get(9);
                double d24 = (Double)this.prevList.get(10);
                double d25 = (Double)this.prevList.get(11);
                double d26 = (Double)this.prevList.get(12);
                double d27 = this.getDiff(d, d14);
                double d28 = this.getDiff(d2, d15);
                double d29 = this.getDiff(d3, d16);
                double d30 = this.getDiff(d4, d17);
                double d31 = this.getDiff(d5, d18);
                double d32 = this.getDiff(d6, d19);
                double d33 = this.getDiff(d7, d20);
                double d34 = this.getDiff(d8, d21);
                double d35 = this.getDiff(d9, d22);
                double d36 = this.getDiff(d10, d23);
                double d37 = this.getDiff(d11, d24);
                double d38 = this.getDiff(d12, d25);
                double d39 = this.getDiff(d13, d26);
                if (d27 > 0.0) {
                    d27 /= 1048576.0;
                }
                if (d39 > 0.0) {
                    d27 /= d39;
                    d28 /= d39;
                    d29 /= d39;
                    d30 /= d39;
                    d31 /= d39;
                    d32 /= d39;
                    d33 /= d39;
                    d34 /= d39;
                    d35 /= d39;
                    d36 /= d39;
                    d37 /= d39;
                    d38 /= d39;
                } else {
                    d27 = 0.0;
                    d28 = 0.0;
                    d29 = 0.0;
                    d30 = 0.0;
                    d31 = 0.0;
                    d32 = 0.0;
                    d33 = 0.0;
                    d34 = 0.0;
                    d35 = 0.0;
                    d36 = 0.0;
                    d37 = 0.0;
                    d38 = 0.0;
                }
                d27 = d27 < 0.0 ? -5.0 : d27;
                d28 = d28 < 0.0 ? -5.0 : d28;
                d29 = d29 < 0.0 ? -5.0 : d29;
                d30 = d30 < 0.0 ? -5.0 : d30;
                d31 = d31 < 0.0 ? -5.0 : d31;
                d32 = d32 < 0.0 ? -5.0 : d32;
                d33 = d33 < 0.0 ? -5.0 : d33;
                d34 = d34 < 0.0 ? -5.0 : d34;
                d35 = d35 < 0.0 ? -5.0 : d35;
                d36 = d36 < 0.0 ? -5.0 : d36;
                d37 = d37 < 0.0 ? -5.0 : d37;
                d38 = d38 < 0.0 ? -5.0 : d38;
                object = new ArrayList();
                ((ArrayList)object).add(new Double(d27));
                ((ArrayList)object).add(new Double(d28));
                ((ArrayList)object).add(new Double(d29));
                ((ArrayList)object).add(new Double(d30));
                ((ArrayList)object).add(new Double(d31));
                ((ArrayList)object).add(new Double(d32));
                ((ArrayList)object).add(new Double(d33));
                ((ArrayList)object).add(new Double(d34));
                ((ArrayList)object).add(new Double(d35));
                ((ArrayList)object).add(new Double(d36));
                ((ArrayList)object).add(new Double(d37));
                ((ArrayList)object).add(new Double(d38));
            } else {
                object = new ArrayList();
                for (int i = 0; i < this.measureCount; ++i) {
                    ((ArrayList)object).add(new Double(-5.0));
                }
            }
            this.addNewMeasure((ArrayList)object);
            this.prevList = new ArrayList();
            this.prevList.add(new Double(d));
            this.prevList.add(new Double(d2));
            this.prevList.add(new Double(d3));
            this.prevList.add(new Double(d4));
            this.prevList.add(new Double(d5));
            this.prevList.add(new Double(d6));
            this.prevList.add(new Double(d7));
            this.prevList.add(new Double(d8));
            this.prevList.add(new Double(d9));
            this.prevList.add(new Double(d10));
            this.prevList.add(new Double(d11));
            this.prevList.add(new Double(d12));
            this.prevList.add(new Double(d13));
            this.closeStmt((Statement)object2);
            this.closeConn(this.conn);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
        }
        finally {
            this.closeStmt((Statement)object2);
            this.closeConn(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double executeQry(Statement statement, String string) {
        double d;
        ResultSet resultSet;
        block10: {
            block9: {
                resultSet = null;
                d = -5.0;
                if (this.conn != null) break block9;
                System.out.println("OraTranWorkloadTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.logToErrorFile("Error  :", this.entity, " executeQry() Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                double d2 = d;
                this.closeRs(resultSet);
                return d2;
            }
            if (statement != null) break block10;
            try {
                statement = this.conn.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTranWorkloadTest executeQry() Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                double d3 = d;
                this.closeRs(resultSet);
                return d3;
            }
        }
        try {
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                d = resultSet.getDouble(1);
            }
            this.closeRs(resultSet);
            this.closeRs(resultSet);
        }
        catch (Exception exception) {
            try {
                this.logToErrorFile("Error  :", this.entity + " executeQry() targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                double d4 = d;
                this.closeRs(resultSet);
                return d4;
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                throw throwable;
            }
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d >= 0.0 && d2 >= 0.0) {
            d3 = d - d2;
        }
        return d3;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTranWorkloadTest oraTranWorkloadTest = new OraTranWorkloadTest(stringArray);
        oraTranWorkloadTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        oraTranWorkloadTest.computeMeasures(new Hashtable());
    }
}

