/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class OraSqlWaitEventTest
extends GenericTest {
    public String username = "";
    public String password = "";
    public String oraSid = "";
    public long duration = -1L;
    private long prev_time = -1L;
    public EgDateInfo dateInfo = new EgDateInfo();
    public Hashtable DDhash;
    private static final int i_measureCount = 2;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public void freeTest() {
        this.DDhash = new Hashtable();
    }

    public OraSqlWaitEventTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.isNewDynamicInfoTest = true;
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        if (this.prev_time <= 0L) {
            this.prev_time = this.dateInfo.egetUTCDate();
            return;
        }
        long l = this.dateInfo.egetUTCDate();
        if (l < 0L) {
            this.prev_time = -1L;
            return;
        }
        this.duration = (l - this.prev_time) / 60000L;
        this.prev_time = l;
        String string2 = "SELECT to_char(a.sample_time,'dd-mon-yyyy hh24:mi:ss') SAMPLE_TIME,SQL_TEXT,C.SQL_ID SQL_ID, B.NAME NAME, (SUM(TIME_WAITED)/(1000*1000)) TIME_WAITED_SECS FROM v$ACTIVE_SESSION_HISTORY A, v$EVENT_NAME B, v$SQLAREA C WHERE A.EVENT# = B.EVENT# AND A.SQL_ID = C.SQL_ID AND a.sample_time BETWEEN sysdate - " + this.duration + "/1440 AND sysdate and TIME_WAITED > 0 GROUP BY C.SQL_TEXT, B.NAME, C.SQL_ID, a.sample_time";
        try {
            double d;
            double d2;
            Object object3;
            Cloneable cloneable;
            Object object4;
            Object object5;
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraSqlWaitEventTest doesnot run for CDB : ", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object2 = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            } else {
                object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            }
            if (object2 == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraSqlWaitEventTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception3) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() in finally block :" + exception3.toString());
                }
                return;
            }
            object = statement.executeQuery(string2);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            double d3 = 0.0;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (object.next()) {
                arrayList = new ArrayList();
                string3 = object.getString("SAMPLE_TIME");
                string4 = object.getString("SQL_TEXT");
                string5 = object.getString("SQL_ID");
                string6 = object.getString("NAME");
                d3 = object.getDouble("TIME_WAITED_SECS");
                arrayList.add(string4);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(new Double(d3));
                arrayList.add(string3);
                if (!hashtable2.containsKey(string6)) {
                    object5 = new Hashtable();
                    ((Hashtable)object5).put(string5, arrayList);
                    hashtable2.put(string6, object5);
                    continue;
                }
                object5 = (Hashtable)hashtable2.get(string6);
                ((Hashtable)object5).put(string5, arrayList);
                hashtable2.put(string6, object5);
            }
            try {
                if (object != null) {
                    object.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (object2 != null) {
                    object2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.DDhash = new Hashtable();
            object5 = hashtable2.keys();
            Hashtable<Object, Object> hashtable3 = new Hashtable<Object, Object>();
            while (object5.hasMoreElements()) {
                Object object6;
                object4 = (String)object5.nextElement();
                cloneable = (Hashtable)hashtable2.get(object4);
                if (cloneable == null) {
                    object3 = new ArrayList();
                    ((ArrayList)object3).add(new Double(-5.0));
                    ((ArrayList)object3).add(new Double(-5.0));
                    this.addNewMeasure((String)object4, (ArrayList)object3);
                    continue;
                }
                double d4 = 0.0;
                d2 = 0.0;
                Enumeration enumeration = ((Hashtable)cloneable).keys();
                Hashtable hashtable4 = new Hashtable();
                while (enumeration.hasMoreElements()) {
                    object6 = (String)enumeration.nextElement();
                    ArrayList arrayList2 = (ArrayList)((Hashtable)cloneable).get(object6);
                    if (arrayList2 == null || arrayList2 == null) continue;
                    d = (Double)arrayList2.get(3);
                    if (d >= 0.0) {
                        d4 += d;
                    }
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    String string7 = (String)arrayList2.get(0);
                    String string8 = (String)arrayList2.get(1);
                    String string9 = (String)arrayList2.get(2);
                    String string10 = (String)arrayList2.get(4);
                    if (!(d > 0.0)) continue;
                    d2 += 1.0;
                    arrayList3.add(string7);
                    arrayList3.add(string8);
                    arrayList3.add(string9);
                    arrayList3.add(string10);
                    arrayList3.add(new Double(d));
                    hashtable4.put(object6, arrayList3);
                }
                if (hashtable4.size() > 0) {
                    this.DDhash.put(object4, hashtable4);
                }
                if (!(d4 >= 0.0)) continue;
                object6 = new ArrayList();
                ((ArrayList)object6).add(new Double(d4));
                ((ArrayList)object6).add(new Double(d2));
                hashtable3.put(object4, object6);
            }
            object4 = hashtable3.keys();
            while (object4.hasMoreElements()) {
                cloneable = new ArrayList();
                object3 = (String)object4.nextElement();
                ArrayList arrayList4 = (ArrayList)hashtable3.get(object3);
                d2 = (Double)arrayList4.get(0);
                double d5 = (Double)arrayList4.get(1);
                double d6 = -5.0;
                if (d5 > 0.0 && d2 > 0.0) {
                    d6 = d2 / d5;
                }
                d = -5.0;
                ((ArrayList)cloneable).add(new Double(d6));
                ((ArrayList)cloneable).add(new Double(d5));
                this.addNewMeasure((String)object3, (ArrayList)cloneable);
            }
            return;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            this.errorMsg = new String("Exception while executing  OraSqlWaitEventTest for target: " + this.targetHost);
            return;
        }
        finally {
            try {
                if (object != null) {
                    object.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (object2 != null) {
                    object2.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() in finally block :" + exception.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        OraSqlWaitEventTest oraSqlWaitEventTest = new OraSqlWaitEventTest(stringArray);
        oraSqlWaitEventTest.computeMeasures(new Hashtable());
    }
}

