/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class OraSessionTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    private String queryStmt;
    private String oracleVersion = "-";
    public double numActive;
    public double numInactive;
    public double numTotal;
    public double numKilled;
    public double numCached;
    public double numSniped;
    public double numBlocked;
    public double numBackground;
    public Hashtable dataForDDTable = null;
    public Hashtable blockerTable = null;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int versionNum = 11;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraSessionTest oraSessionTest = new OraSessionTest(stringArray);
        oraSessionTest.computeMeasures(new Hashtable());
    }

    public OraSessionTest(String[] stringArray) {
        super(stringArray);
        if (this.measureCount < 2) {
            this.setMeasureCount(2);
        }
        this.userName = this.getValueForParam("user");
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        this.queryStmt = this.numOutputFields > 2 ? "select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, sq.sql_fulltext from  v$session se,v$sql sq where  se.sql_address = sq.address and se.sql_id = sq.sql_id  and  se.sql_child_number = sq.child_number and  se.sql_hash_value = sq.hash_value union all select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, null sql_fulltext from  v$session se order  by 1,2" : "select distinct (status ||';;' || nvl(username,'-') || ';;' ||  nvl(osuser,'-') || ';;' || nvl(program,'-')) as data, count (*) from v$session where username is not null group by (status ||';;' || nvl(username,'-') || ';;' ||  nvl(osuser,'-') || ';;' || nvl(program,'-')) order by 2 desc";
        if (this.numOutputFields <= 2) {
            this.numOutputFields = 2;
        }
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        this.needAgentlessDD = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        block108: {
            this.dataForDDTable = new Hashtable<K, V>();
            this.blockerTable = new Hashtable<K, V>();
            if (this.isInitCheckNeeded) {
                this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraSessionTest.debug, this.reportingName);
                var2_2 = new ArrayList<E>();
                var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                if (var2_2 != null && var2_2.size() > 2) {
                    this.versionNum = (Integer)var2_2.get(0);
                    var3_3 = (String)var2_2.get(1);
                    if (var3_3.equalsIgnoreCase("true")) {
                        this.isCDB = true;
                    }
                    if (this.versionNum >= 12) {
                        this.isOracle12c = true;
                        var4_4 = (String)var2_2.get(2);
                        if (var4_4.equalsIgnoreCase("true")) {
                            this.isMultitenantDb = true;
                        }
                    }
                    this.isInitCheckNeeded = false;
                } else {
                    if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                }
            }
            if (this.isDataguardEnabled) {
                var2_2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraSessionTest.debug, this.reportingName);
                if (var2_2 == null) return;
                if (var2_2.size() == 0) {
                    return;
                }
                var3_3 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
                if (var3_3 == null) return;
                if (var3_3.size() <= 0) return;
                var4_4 = (String)var3_3.get(2);
                var5_5 = (String)var3_3.get(3);
                if (!var4_4.equalsIgnoreCase("PRIMARY") && var5_5.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            }
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            try {
                if (this.isMultitenantDb) {
                    if (this.isCDB) {
                        if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                            this.logToErrorFile("INFO", "OraSessionTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.msgLogCounter = 0;
                        }
                        ++this.msgLogCounter;
                        return;
                    }
                    this.queryStmt = "select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, sq.sql_fulltext from  v$session se,v$sql sq where  se.con_id > 0 and sq.con_id > 0 and se.sql_address = sq.address and se.sql_id = sq.sql_id  and  se.sql_child_number = sq.child_number and  se.sql_hash_value = sq.hash_value union all select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, null sql_fulltext from  v$session se order  by 1,2";
                    var2_2 = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraSessionTest.debug);
                } else {
                    var2_2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraSessionTest.debug);
                }
                if (var2_2 == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    return;
                }
                this.queryStmt = "select se.status, se.type, se.sid, se.serial#, se.username, se.osuser, se.machine, se.terminal, se.program, se.module, se.last_call_et, sq.sql_text from v$session se left outer join v$sql sq on decode(se.sql_address,'00',se.prev_sql_addr,se.sql_address)=sq.address and decode(se.sql_hash_value,0, se.prev_hash_value, se.sql_hash_value)=sq.hash_value order by se.status, se.sid";
                if (this.numOutputFields > 2 && this.versionNum >= 11) {
                    try {
                        var7_9 = "SELECT /*+ORDERED */lock2.sid, lock1.sid AS blockers FROM v$lock lock1 INNER JOIN v$lock lock2 ON lock1.id1 = lock2.id1  AND\tlock1.id2 = lock2.id2  WHERE lock1.block = 1 and lock2.request > 0";
                        try {
                            var3_3 = var2_2.createStatement();
                        }
                        catch (Exception var8_17) {
                            this.logToErrorFile("Error :", "OraSessionTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var8_17.toString());
                            var8_17.printStackTrace();
                            try {
                                if (var2_2 != null) {
                                    var2_2.close();
                                }
                            }
                            catch (Exception var9_22) {
                                // empty catch block
                            }
                            try {
                                if (var5_5 != null) {
                                    var5_5.close();
                                }
                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                            }
                            catch (Exception var9_23) {
                                // empty catch block
                            }
                            try {
                                if (var5_5 != null) {
                                    var5_5.close();
                                }
                                if (var6_6 != null) {
                                    var6_6.close();
                                }
                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                                if (var4_4 != null) {
                                    var4_4.close();
                                }
                                if (var2_2 == null) return;
                                var2_2.close();
                                return;
                            }
                            catch (Exception var9_24) {
                                // empty catch block
                            }
                            return;
                        }
                        var5_5 = var3_3.executeQuery((String)var7_9);
                        while (var5_5.next()) {
                            var8_18 = var5_5.getString(1);
                            var9_25 = var5_5.getString(2);
                            this.blockerTable.put(var8_18, var9_25);
                        }
                    }
                    catch (Exception var7_11) {
                        System.out.println("Exception while getting blocked / blocking session");
                    }
                    finally {
                        try {
                            if (var5_5 != null) {
                                var5_5.close();
                            }
                            if (var3_3 != null) {
                                var3_3.close();
                            }
                        }
                        catch (Exception var7_12) {}
                    }
                }
                try {
                    var3_3 = var2_2.createStatement();
                }
                catch (Exception var7_13) {
                    this.logToErrorFile("Error :", "OraSessionTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var7_13.toString());
                    var7_13.printStackTrace();
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                    }
                    catch (Exception var8_19) {
                        // empty catch block
                    }
                    try {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
                        if (var6_6 != null) {
                            var6_6.close();
                        }
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                        if (var4_4 != null) {
                            var4_4.close();
                        }
                        if (var2_2 == null) return;
                        var2_2.close();
                        return;
                    }
                    catch (Exception var8_20) {
                        // empty catch block
                    }
                    return;
                }
                var5_5 = var3_3.executeQuery(this.queryStmt);
                var7_9 = var5_5.getMetaData();
                var8_21 = var7_9.getColumnCount();
                var9_25 = new ArrayList<E>();
                var10_27 = new ArrayList<String>();
                var11_29 = new ArrayList<String>();
                var12_30 = new ArrayList<String>();
                var13_31 = new ArrayList<String>();
                var14_32 = new ArrayList<String>();
                var15_33 = new ArrayList<String>();
                var16_34 = new ArrayList<String>();
                var17_35 = new TreeSet<String>();
                this.numActive = 0.0;
                this.numInactive = 0.0;
                this.numKilled = 0.0;
                this.numCached = 0.0;
                this.numSniped = 0.0;
                this.numTotal = 0.0;
                this.numBlocked = 0.0;
                this.numBackground = 0.0;
                if (this.numOutputFields > 2) break block108;
                while (var5_5.next()) {
                    var18_37 = new StringBuffer();
                    var19_39 = var5_5.getString(1);
                    var20_41 = new StringTokenizer(var19_39, ";;");
                    var21_43 = new StringBuffer();
                    var22_45 = var20_41.countTokens();
                    if (var22_45 != 4) continue;
                    var23_50 = var20_41.nextToken();
                    var24_52 = var20_41.nextToken();
                    var25_53 = var20_41.nextToken();
                    var26_54 = var20_41.nextToken();
                    var27_55 = var5_5.getString(2);
                    var28_56 = Double.parseDouble(var27_55);
                    var18_37.append(var24_52 + ";;" + var25_53 + ";;" + var26_54 + ";;" + var27_55);
                    var21_43.append(var24_52 + ";;" + var25_53 + ";;" + var23_50 + ";;" + var26_54 + ";;" + var27_55);
                    var30_57 = var18_37.toString();
                    this.numTotal += var28_56;
                    var14_32.add(var21_43.toString());
                    if (!var23_50.equalsIgnoreCase("ACTIVE")) continue;
                    this.numActive += var28_56;
                    var9_25.add(var30_57);
                }
lbl189:
                // 2 sources

                while (true) {
                    this.dataForDDTable.put("ACTIVE", var9_25);
                    this.dataForDDTable.put("INACTIVE", var10_27);
                    this.dataForDDTable.put("KILLED", var11_29);
                    this.dataForDDTable.put("CACHED", var12_30);
                    this.dataForDDTable.put("SNIPED", var13_31);
                    this.dataForDDTable.put("TOTAL", var14_32);
                    this.dataForDDTable.put("BLOCKED", var15_33);
                    this.dataForDDTable.put("BACKGROUND", var16_34);
                    break;
                }
            }
            catch (Exception var7_15) {
                this.numActive = this.defValue;
                this.numInactive = this.defValue;
                this.numKilled = this.defValue;
                this.numCached = this.defValue;
                this.numSniped = this.defValue;
                this.numTotal = this.defValue;
                this.numBlocked = this.defValue;
                this.numBackground = this.defValue;
                System.out.println("Exception Occured in computeMeasure of OraSessionTest");
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var7_15.toString());
                var7_15.printStackTrace();
            }
            finally {
                try {
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (Exception var7_16) {}
            }
            var7_9 = new ArrayList<Double>();
            var7_9.add(new Double(this.numTotal));
            var7_9.add(new Double(this.numActive));
            if (this.numOutputFields > 2) {
                var7_9.add(new Double(this.numBackground));
                var7_9.add(new Double(this.numInactive));
                var7_9.add(new Double(this.numKilled));
                var7_9.add(new Double(this.numCached));
                var7_9.add(new Double(this.numSniped));
                var7_9.add(new Double(this.numBlocked));
            }
            this.addNewMeasure(var7_9);
            return;
        }
        while (true) {
            block113: {
                block114: {
                    block112: {
                        block110: {
                            block111: {
                                if (!var5_5.next()) break block110;
                                var18_36 = new StringBuffer();
                                var19_38 = false;
                                var20_40 = var5_5.getString(1);
                                var21_42 = var5_5.getString(2);
                                var22_44 = var5_5.getString(3);
                                if (var17_35.contains(var22_44)) continue;
                                var17_35.add(var22_44);
                                var18_36.append(var22_44 + "~");
                                if (var8_21 != 13) break block111;
                                break block112;
                            }
                            if (var8_21 != 12) break block113;
                            break block114;
                        }
                        this.numActive = var9_25.size();
                        this.numInactive = var10_27.size();
                        this.numKilled = var11_29.size();
                        this.numCached = var12_30.size();
                        this.numSniped = var13_31.size();
                        this.numBlocked = var15_33.size();
                        this.numBackground = var16_34.size();
                        this.numTotal = this.numActive + this.numInactive + this.numKilled + this.numCached + this.numSniped + this.numBackground;
                        ** continue;
                    }
                    for (var23_47 = 4; var23_47 <= var8_21; ++var23_47) {
                        var24_51 = var5_5.getString(var23_47);
                        if (var24_51 == null) {
                            var24_51 = "-";
                        } else if (var24_51.trim().length() == 0 || var24_51.equalsIgnoreCase("null") || var24_51.equalsIgnoreCase("unknown")) {
                            var24_51 = "-";
                        }
                        if (var23_47 == var8_21 - 1 && !var24_51.equals("-")) {
                            this.blockerTable.put(var22_44, var24_51);
                            var19_38 = true;
                        }
                        var18_36.append(var24_51);
                        if (var23_47 == var8_21) continue;
                        var18_36.append("~");
                    }
                    break block113;
                }
                for (var23_48 = 4; var23_48 <= var8_21 - 1; ++var23_48) {
                    var24_51 = var5_5.getString(var23_48);
                    if (var24_51 == null) {
                        var24_51 = "-";
                    } else if (var24_51.trim().length() == 0 || var24_51.equalsIgnoreCase("null") || var24_51.equalsIgnoreCase("unknown")) {
                        var24_51 = "-";
                    }
                    var18_36.append(var24_51);
                    var18_36.append("~");
                }
                var23_49 = "-";
                if (this.blockerTable.containsKey(var22_44)) {
                    var23_49 = (String)this.blockerTable.get(var22_44);
                    var19_38 = true;
                }
                var18_36.append(var23_49);
                var18_36.append("~");
                var24_51 = var5_5.getString(var8_21);
                if (var24_51 == null) {
                    var24_51 = "-";
                }
                var18_36.append(var24_51);
            }
            var23_46 = var18_36.toString();
            if (var21_42.equalsIgnoreCase("BACKGROUND")) {
                var16_34.add(var23_46);
            } else if (var20_40.equalsIgnoreCase("ACTIVE")) {
                var9_25.add(var23_46);
            } else if (var20_40.equalsIgnoreCase("INACTIVE")) {
                var10_27.add(var23_46);
            } else if (var20_40.equalsIgnoreCase("KILLED")) {
                var11_29.add(var23_46);
            } else if (var20_40.equalsIgnoreCase("CACHED")) {
                var12_30.add(var23_46);
            } else if (var20_40.equalsIgnoreCase("SNIPED")) {
                var13_31.add(var23_46);
            }
            if (!var19_38) continue;
            var15_33.add(var23_46);
        }
    }

    public void freeTest() {
        this.dataForDDTable = new Hashtable();
        this.blockerTable = new Hashtable();
    }
}

