/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraServiceTest_cf
extends GenericTest {
    private String strDriver;
    private String strDbHost;
    private String strDbPort;
    private String strOraSid;
    private String strUserName;
    private String strPassword;
    private String strUrl;
    private String strQuery;
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isMessageLogged = false;
    private boolean isMultitenantDb = false;
    private int msgLogCounter = 0;
    public boolean isOracleOnCloud = false;

    public OraServiceTest_cf(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(5);
        this.strDbHost = this.targetHost;
        this.strDbPort = this.portNo;
        this.strOraSid = this.getValueForParam("info");
        this.strUserName = this.getValueForParam("user");
        this.strPassword = this.getValueForParam("password");
        this.strDriver = "oracle.jdbc.driver.OracleDriver";
        this.strUrl = "jdbc:oracle:thin:@" + this.strDbHost + ":" + this.strDbPort + ":" + this.strOraSid;
        this.strQuery = "select name service_name,network_name,creation_date service_creation_date,blocked is_service_blocked,con_name container_name from v$active_services where network_name is not null";
        this.setConfigInfoTestFlag(true);
        if (this.strOraSid == null) {
            this.strOraSid = this.getValueForParam("oracle_sid");
        }
        if (this.strOraSid == null || this.strOraSid.equalsIgnoreCase("NULL") || this.strOraSid.equalsIgnoreCase("none")) {
            this.strOraSid = "";
        }
        if ((string = this.getValueForParam("cloud_hosted")) != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.strOraSid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList arrayList = new ArrayList();
        if (this.checkOracleVersion) {
            arrayList = ConnectionManager.checkOracleVersion(this.entity, this.strDbHost, this.strDbPort, this.strOraSid, this.strUserName, this.strPassword, debug);
            this.checkOracleVersion = false;
            if (arrayList != null && arrayList.size() > 2) {
                int n = (Integer)arrayList.get(0);
                string2 = (String)arrayList.get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)arrayList.get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
            }
        }
        if (!this.isOracle12c) {
            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                this.logToErrorFile("INFO :", " OraServiceTest_cf support from Oracle12C onwards ", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.strOraSid);
                this.msgLogCounter = 0;
            }
            ++this.msgLogCounter;
            try {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (this.isMultitenantDb && this.isCDB) {
            if (this.isMessageLogged) return;
            this.logToErrorFile("INFO", "OraServiceTest_cf doesnot run for CDB : ", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.strOraSid);
            this.isMessageLogged = true;
            return;
        }
        connection = ConnectionManager.getOraServiceConn(this.entity, this.strDbHost, this.strDbPort, this.strOraSid, this.strUserName, this.strPassword, debug);
        if (connection == null) {
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.strOraSid);
            try {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraServiceTest_cf Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.strOraSid, exception.toString());
            exception.printStackTrace();
            this.closeConn(connection);
            try {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            return;
        }
        resultSet = statement.executeQuery(this.strQuery);
        while (resultSet.next()) {
            String string3;
            String string4;
            String string5;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            string2 = resultSet.getString(1);
            if (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase("none")) {
                string2 = "-";
            }
            if ((string = resultSet.getString(2)) == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
                string = "-";
            }
            if ((string5 = resultSet.getString(3)) == null || string5.length() == 0 || string5.equalsIgnoreCase("none")) {
                string5 = "-";
            }
            if ((string4 = resultSet.getString(4)) == null || string4.length() == 0 || string4.equalsIgnoreCase("none")) {
                string4 = "-";
            }
            if ((string3 = resultSet.getString(5)) == null || string3.length() == 0 || string3.equalsIgnoreCase("none")) {
                string3 = "-";
            }
            arrayList2.add(string2);
            arrayList2.add(string);
            arrayList2.add(string5);
            arrayList2.add(string4);
            arrayList2.add(string3);
            this.addNewMeasure(arrayList2);
        }
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
        return;
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraServiceTest_cf oraServiceTest_cf = new OraServiceTest_cf(stringArray);
        oraServiceTest_cf.computeMeasures(new Hashtable());
    }
}

