/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraResourceUseTest
extends GenericTest {
    public String oraSid = "";
    public String username = "";
    public String password = "";
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private static final int i_measureCount = 5;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public OraResourceUseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                object2 = (String)((ArrayList)object3).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)object3).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object3 == null || ((Hashtable)object3).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object3 = "select resource_name,initial_allocation,current_utilization,max_utilization,limit_value from v$resource_limit where resource_name in ('sessions','processes') ";
        Connection connection = null;
        object2 = null;
        object = null;
        try {
            if (this.isMultitenantDb && !this.isCDB) {
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                object3 = "select resource_name,initial_allocation,current_utilization,max_utilization,limit_value from v$resource_limit where resource_name in ('sessions') ";
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraResourceUseTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                    if (object2 != null) {
                        object2.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception3.toString());
                }
                return;
            }
            object = object2.executeQuery((String)object3);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string = "";
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            while (object.next()) {
                arrayList = new ArrayList();
                string = object.getString(1);
                d = Double.parseDouble(object.getString(2));
                d2 = Double.parseDouble(object.getString(3));
                d3 = Double.parseDouble(object.getString(4));
                d4 = Double.parseDouble(object.getString(5));
                d5 = d2 / d4 * 100.0;
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                this.addNewMeasure(string, arrayList);
            }
            if (arrayList == null || arrayList.size() == 0) {
                this.addDefaultMeasure();
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures():" + exception.toString());
            exception.printStackTrace();
            if (this.isPassive) {
                this.addDefaultMeasure();
            }
        }
        finally {
            try {
                if (object != null) {
                    object.close();
                }
                if (object2 != null) {
                    object2.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception.toString());
            }
        }
    }

    public void addDefaultMeasure() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string = "sessions";
        String string2 = "processes";
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        this.addNewMeasure(string, arrayList);
        this.addNewMeasure(string2, arrayList);
    }

    public static void main(String[] stringArray) {
        OraResourceUseTest oraResourceUseTest = new OraResourceUseTest(stringArray);
        oraResourceUseTest.computeMeasures(new Hashtable());
    }
}

