/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

class OraRacPgaTest
extends GenericTest {
    private String oraSid = "";
    private String user = "";
    private String passwd = "";
    private int oraVersion = 8;
    private boolean isFirstTime = true;
    private boolean errorOccured = false;
    private String serviceName = "";
    private boolean service = true;
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private ArrayList prevInfoList = new ArrayList();

    public OraRacPgaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("username");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none")) {
            this.passwd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        this.isDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        double d;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block32: {
            connection = null;
            statement = null;
            resultSet = null;
            d = -5.0;
            string3 = "select 'DBO'||a.inst_id,round(a.value/1024/1024,2) initial_pga_allocated_mb, round(b.value/1024/1024,2) current_pga_size_mb, c.value pga_hit_pct, case when a.value >0 then round((b.value/a.value)*100,2) else -5 end  as pga_usage_pct from gv$pgastat a,gv$pgastat b, gv$pgastat c where a.name='aggregate PGA target parameter' and b.name='total PGA inuse' and c.name='cache hit percentage'";
            try {
                connection = ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("[OraRacPgaTest] compute Measure()", "failed to connect database", exception.toString());
                return;
            }
            if (connection == null) {
                System.out.println("OraRacPgaTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                this.logToErrorFile("[OraRacPgaTest] compute Measure()", "database conn is null ", "TargetHost" + this.targetHost);
                for (int i = 0; i < this.prevInfoList.size(); ++i) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string4 = (String)this.prevInfoList.get(i);
                    for (int j = 0; j < this.measureCount; ++j) {
                        arrayList.add(new Double(-1.0));
                    }
                    System.out.println("Adding MeasureList :" + arrayList);
                    this.addNewMeasure(string4, arrayList);
                }
                return;
            }
            this.prevInfoList = new ArrayList();
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.closeConn(connection);
                return;
            }
            if (this.isFirstTime) {
                string2 = "select version from v$instance";
                string = "";
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    if ((string = string.substring(0, string.indexOf("."))) != null) {
                        try {
                            this.oraVersion = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.oraVersion = 8;
                        }
                        continue;
                    }
                    this.errorOccured = true;
                    this.logToErrorFile("OraRacPgaTest:", "Query  select version from v$instance returning null ", "Hence assuming that this oracle server " + this.reportingName + " is 8 or below 8 ");
                }
                this.closeRs(resultSet);
                resultSet = null;
                this.isFirstTime = false;
            }
            if (this.oraVersion > 8) break block32;
            if (!this.errorOccured) {
                this.logToErrorFile("OraRacPgaTest:", "Support from oracle version 9 and above", "the oracle server " + this.reportingName + " is " + this.oraVersion + " ");
            }
            this.closeStmt(statement);
            this.closeConn(connection);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        try {
            Object object;
            string2 = "";
            string = "";
            double d2 = 0.0;
            Hashtable<Object, ArrayList> hashtable2 = new Hashtable<Object, ArrayList>();
            if (this.oraVersion >= 11) {
                ArrayList arrayList;
                double d3;
                string2 = "select 'DBO'||inst_id,round(VALUE/1024/1024,2) memory_target_SIZE_MB from gv$parameter where name='memory_target'";
                string = "select 'DBO'||inst_id,round(VALUE/1024/1024,2) SGA_target_SIZE_MB from gv$parameter where name='sga_target'";
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    object = "";
                    d3 = 0.0;
                    arrayList = new ArrayList();
                    object = resultSet.getString(1);
                    d3 = resultSet.getDouble(2);
                    arrayList.add(new Double(d3));
                    hashtable2.put(object, arrayList);
                }
                this.closeRs(resultSet);
                resultSet = null;
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    object = "";
                    d3 = 0.0;
                    object = resultSet.getString(1);
                    d3 = resultSet.getDouble(2);
                    if (hashtable2 == null || hashtable2.size() <= 0 || (arrayList = (ArrayList)hashtable2.get(object)) == null || arrayList.size() <= 0) continue;
                    arrayList.add(new Double(d3));
                    hashtable2.put(object, arrayList);
                }
                this.closeRs(resultSet);
                resultSet = null;
            }
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                object = new ArrayList();
                String string5 = resultSet.getString(1);
                d2 = resultSet.getDouble(2);
                double d4 = resultSet.getDouble(3);
                double d5 = resultSet.getDouble(4);
                if (this.oraVersion >= 11) {
                    ArrayList arrayList = (ArrayList)hashtable2.get(string5);
                    if (arrayList != null && arrayList.size() > 0) {
                        double d6 = (Double)arrayList.get(0) - (Double)arrayList.get(1);
                        d = d6 > 0.0 ? d4 / d6 * 100.0 : resultSet.getDouble(5);
                    }
                } else {
                    d = resultSet.getDouble(5);
                }
                double d7 = -5.0;
                if (d > 100.0) {
                    d = 100.0;
                    d7 = d4 - d2;
                } else if (d < 100.0) {
                    d7 = 0.0;
                }
                ((ArrayList)object).add(new Double(d4));
                ((ArrayList)object).add(new Double(d5));
                ((ArrayList)object).add(new Double(d));
                if (this.measureCount > 3) {
                    if (d7 < 0.0) {
                        d7 = -5.0;
                    }
                    ((ArrayList)object).add(new Double(d7));
                }
                System.out.println(this.entity + " measureList :" + object);
                this.addNewMeasure(string5, (ArrayList)object);
                this.prevInfoList.add(string5);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                this.logToErrorFile("[OraRacPgaTest]", "Exception Occured in OraRacPgaTest.computeMeasures():e", exception.toString());
                System.out.println("Exception Occured in OraRacPgaTest.computeMeasures():" + exception.toString());
                for (int i = 0; i < this.prevInfoList.size(); ++i) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string6 = (String)this.prevInfoList.get(i);
                    for (int j = 0; j < this.measureCount; ++j) {
                        arrayList.add(new Double(-1.0));
                    }
                    System.out.println("Adding MeasureList :" + arrayList);
                    this.addNewMeasure(string6, arrayList);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    public double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraRacPgaTest oraRacPgaTest = new OraRacPgaTest(stringArray);
        oraRacPgaTest.computeMeasures(new Hashtable());
    }
}

