/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraIoLatencyTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    public Hashtable ddHash = new Hashtable();
    private boolean isDataguardEnabled = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraIoLatencyTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block35: {
            Object object;
            double d;
            double d2;
            ArrayList arrayList;
            double d3;
            double d4;
            double d5;
            String string;
            String string2;
            String string3;
            String string4;
            Hashtable hashtable2;
            ResultSet resultSet;
            Object object2;
            Object object3;
            Object object4;
            block34: {
                if (this.isDataguardEnabled) {
                    object4 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
                    if (object4 == null || ((Hashtable)object4).size() == 0) {
                        return;
                    }
                    object3 = (ArrayList)((Hashtable)object4).get(this.reportingName);
                    if (object3 != null && ((ArrayList)object3).size() > 0) {
                        object2 = (String)((ArrayList)object3).get(2);
                        if (!((String)object2).equalsIgnoreCase("PRIMARY")) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                object4 = "select function_name,io_size io_size_bytes,wait_event,file_name,io_latency io_latency_millisec,round((io_latency/io_size),2) io_latency_per_byte,decode(disk1_name,null,'NON_ASM') disk1_name,disk1_latency disk1_latency_millisec,decode(disk2_name,null,'NON_ASM') disk2_name,disk2_latency disk2_latency_millisec,decode(disk3_name,null,'NON_ASM') disk3_name,disk3_latency disk3_latency_millisec from V$IO_OUTLIER where io_size>0 order by function_name, io_latency_per_byte desc";
                object3 = null;
                object2 = null;
                resultSet = null;
                hashtable2 = new Hashtable();
                string4 = "";
                string3 = "";
                string2 = "";
                string = "";
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                if (!this.isOracle12c) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("Info :", " OraIoLatencyTest support from Oracle12C onwards ", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object3 = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                if (object3 != null) break block34;
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                try {
                    this.closeRs(resultSet);
                    this.closeStmt((Statement)object2);
                    this.closeConn((Connection)object3);
                }
                catch (Exception exception) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception.toString());
                }
                return;
            }
            try {
                object2 = object3.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraIoLatencyTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.closeConn((Connection)object3);
                try {
                    this.closeRs(resultSet);
                    this.closeStmt((Statement)object2);
                    this.closeConn((Connection)object3);
                }
                catch (Exception exception2) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception2.toString());
                }
                return;
            }
            resultSet = object2.executeQuery((String)object4);
            while (resultSet.next()) {
                string3 = resultSet.getString(1);
                d5 = resultSet.getDouble(2);
                string2 = resultSet.getString(3);
                string = resultSet.getString(4);
                d4 = resultSet.getDouble(5);
                d3 = resultSet.getDouble(6);
                if (string2 == null || string2.equalsIgnoreCase("null") || string2.trim().length() == 0) {
                    string2 = "-";
                }
                string4 = string2 + fieldSep + string + fieldSep + d5 + fieldSep + d4 + fieldSep + d3;
                arrayList = (ArrayList)hashtable2.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d3));
                } else {
                    double d6 = (Double)arrayList.get(0);
                    d2 = (Double)arrayList.get(1);
                    d = (Double)arrayList.get(2);
                    d6 += d5;
                    d2 += d4;
                    if (d < d3) {
                        d = d3;
                    }
                    arrayList.set(0, new Double(d6));
                    arrayList.set(1, new Double(d2));
                    arrayList.set(2, new Double(d));
                }
                hashtable2.put(string3, arrayList);
                object = (ArrayList)this.ddHash.get(string3);
                if (object == null) {
                    object = new ArrayList<String>();
                    ((ArrayList)object).add(string4);
                } else {
                    int n = ((ArrayList)object).size();
                    if (n < 5) {
                        ((ArrayList)object).add(string4);
                    }
                }
                this.ddHash.put(string3, object);
            }
            this.closeRs(resultSet);
            this.closeStmt((Statement)object2);
            this.closeConn((Connection)object3);
            arrayList = hashtable2.keys();
            while (arrayList.hasMoreElements()) {
                object = (String)arrayList.nextElement();
                ArrayList arrayList2 = (ArrayList)hashtable2.get(object);
                if (arrayList2 == null || arrayList2.size() <= 0) continue;
                d2 = (Double)arrayList2.get(0);
                d = (Double)arrayList2.get(1);
                double d7 = (Double)arrayList2.get(2);
                double d8 = d / d2;
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(d));
                arrayList3.add(new Double(d8));
                arrayList3.add(new Double(d7));
                this.addNewMeasure((String)object, arrayList3);
            }
            try {
                this.closeRs(resultSet);
                this.closeStmt((Statement)object2);
                this.closeConn((Connection)object3);
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception.toString());
            }
            break block35;
            catch (Exception exception) {
                try {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures():" + exception.toString());
                    exception.printStackTrace();
                    this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                }
                catch (Throwable throwable) {
                    try {
                        this.closeRs(resultSet);
                        this.closeStmt((Statement)object2);
                        this.closeConn((Connection)object3);
                    }
                    catch (Exception exception3) {
                        System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception3.toString());
                    }
                    throw throwable;
                }
                try {
                    this.closeRs(resultSet);
                    this.closeStmt((Statement)object2);
                    this.closeConn((Connection)object3);
                }
                catch (Exception exception4) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception4.toString());
                }
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void freeTest() {
        this.ddHash = new Hashtable();
    }

    private void init() {
        this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
        ArrayList arrayList = new ArrayList();
        arrayList = ConnectionManager.getOracleVersionDetail(this.reportingName);
        if (arrayList != null && arrayList.size() > 2) {
            int n = (Integer)arrayList.get(0);
            String string = (String)arrayList.get(1);
            if (string.equalsIgnoreCase("true")) {
                this.isCDB = true;
            }
            if (n >= 12) {
                this.isOracle12c = true;
                String string2 = (String)arrayList.get(2);
                if (string2.equalsIgnoreCase("true")) {
                    this.isMultitenantDb = true;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        OraIoLatencyTest oraIoLatencyTest = new OraIoLatencyTest(stringArray);
        oraIoLatencyTest.computeMeasures(new Hashtable());
    }
}

