/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraIdleSessionTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String inactive_period;
    public int period;
    private static final int i_measureCount = 1;
    public Hashtable idleSessionDetailsDD;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public void freeTest() {
        this.idleSessionDetailsDD = new Hashtable();
    }

    public OraIdleSessionTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        this.inactive_period = this.getValueForParam("inactive_period");
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none")) {
            this.passwd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.period = this.inactive_period == null || this.inactive_period.equalsIgnoreCase("NULL") || this.inactive_period.equalsIgnoreCase("none") ? 10 : new Integer(this.inactive_period);
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                object2 = (String)((ArrayList)cloneable).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)cloneable).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        this.idleSessionDetailsDD = new Hashtable();
        cloneable = new ArrayList();
        Connection connection = null;
        object2 = null;
        object = null;
        int n = 0;
        String string = "SELECT  SID, USERNAME,(LAST_CALL_ET/60) idle_time FROM  v$session WHERE  username IS NOT NULL AND (LAST_CALL_ET / 60) > " + this.period + " AND  STATUS = 'INACTIVE' order by idle_time";
        try {
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraIdleSessionTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                string = "SELECT  SID, USERNAME,(LAST_CALL_ET/60) idle_time,con_id FROM  v$session WHERE con_id > 0 and username IS NOT NULL AND (LAST_CALL_ET / 60) > 50 AND  STATUS = 'INACTIVE' order by idle_time";
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug);
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug);
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraIdleSessionTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {
                    System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + exception3.toString());
                }
                return;
            }
            object = object2.executeQuery(string);
            if (object != null) {
                while (object.next()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    String string2 = object.getString("SID");
                    arrayList.add(string2);
                    arrayList.add(object.getString("USERNAME"));
                    double d = object.getDouble("idle_time");
                    BigDecimal bigDecimal = new BigDecimal(d).setScale(2, 6);
                    arrayList.add(new Double(bigDecimal.doubleValue()));
                    this.idleSessionDetailsDD.put(string2, arrayList);
                    ++n;
                }
            }
            object.close();
            object2.close();
            ((ArrayList)cloneable).add(new Double(n));
            this.addNewMeasure((ArrayList)cloneable);
        }
        catch (Exception exception) {
            try {
                if (object != null) {
                    object.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                if (object2 != null) {
                    object2.close();
                }
            }
            catch (Exception exception5) {
                // empty catch block
            }
            this.logToErrorFile("Error :", "OraIdleSessionTest.computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures():" + exception.toString());
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in OraIdleSessionTest.computeMeasures().finally block:" + exception.toString());
            }
        }
    }
}

