/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgTesterInfo;
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class OraExaValidator
extends EgServerValidator {
    EgUtilities egutil;
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final Double DEFAULT_MINUS_FIVE = new Double(-5.0);
    protected static final double MINUS_FIVE = -5.0;
    protected static final int ZERO = 0;
    protected static final String DELIMITER = ":";
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    protected static final String CELLCLI = "cellcli -e list ";
    protected static final String STORAGE_CELL_DETAILS_COMMAND = "cellcli -e list cell detail";
    protected final String cmdToExecute = "cellcli -e list cell detail";
    protected String validationComment;
    protected String reportingName;
    protected String entity;
    protected String strSSHPort;
    protected String strTimeout;
    protected String targetHost;
    protected String userName;
    protected String password;
    String typ;
    int sshPortNo;
    int cmd_time_out;
    private boolean isFromManager;
    public ArrayList validationMsgs;
    String logMessage;
    String strLogSizeLimitInMB;
    protected static final String TEST_NAME = "OraExaValidator";
    protected static final String LOG_FILE_NAME = "OraExaValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "OraExaValidatorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "OraExaValidatorLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double MB_TO_TB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB;
    String className;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraExaValidator(String[] stringArray, Boolean bl) {
        block21: {
            super(stringArray);
            this.egutil = EgUtilities.createInstance();
            this.cmdToExecute = STORAGE_CELL_DETAILS_COMMAND;
            this.validationComment = null;
            this.reportingName = null;
            this.entity = null;
            this.strSSHPort = "22";
            this.strTimeout = null;
            this.targetHost = null;
            this.userName = null;
            this.password = null;
            this.typ = "ssh";
            this.sshPortNo = 22;
            this.cmd_time_out = 60;
            this.isFromManager = false;
            this.validationMsgs = null;
            this.logMessage = "";
            this.strLogSizeLimitInMB = null;
            this.debugLogSizeLimitInMB = 1048576.0;
            this.className = this.getClass().getName();
            String string = "Constructor";
            string = this.methodNameTemplate(string);
            this.entity = this.className;
            try {
                Object object;
                String string2;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray[i];
                    object = string2.substring(0, string2.indexOf(DELIMITER));
                    String string3 = string2.substring(string2.indexOf(DELIMITER) + 1);
                    if ((object = ((String)object).trim()) != null && ((String)object).equalsIgnoreCase("-host")) {
                        this.targetHost = string3.trim();
                        continue;
                    }
                    if (object != null && ((String)object).equalsIgnoreCase("-username")) {
                        this.userName = string3.trim();
                        continue;
                    }
                    if (object != null && ((String)object).equalsIgnoreCase("-password")) {
                        if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                            string3 = string3.substring(0, string3.indexOf("~EG~"));
                        }
                        this.password = string3.trim();
                        continue;
                    }
                    if (object != null && ((String)object).equalsIgnoreCase("-ssh_port")) {
                        this.strSSHPort = string3.trim();
                        this.logMessage = string + "Oracle Exadata Storage SSH Port   :" + this.strSSHPort;
                        this.printOut(this.logMessage);
                        this.logMessage = "";
                        try {
                            this.sshPortNo = Integer.parseInt(this.strSSHPort);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.sshPortNo = 22;
                        }
                        this.logMessage = string + "Oracle Exadata Storage SSH Port (After parse)  :" + this.strSSHPort;
                        this.printOut(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    if (object != null && ((String)object).equalsIgnoreCase("-rptName")) {
                        this.reportingName = string3.trim();
                        continue;
                    }
                    if (object == null || !((String)object).equalsIgnoreCase("-timeout")) continue;
                    this.logMessage = string + "Timeout string value in constructor : " + this.strTimeout;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    try {
                        this.cmd_time_out = Integer.parseInt(this.strTimeout);
                        this.printOut(string + "Timeout value in constructor(After parse) : " + this.strTimeout);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.cmd_time_out = 60;
                        this.logMessage = string + "Timeout value parsing error ,so assigning default value : " + this.cmd_time_out;
                        this.printOut(this.logMessage);
                        this.logMessage = "";
                    }
                }
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
                if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
                    this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                        this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                    }
                    catch (Exception exception) {
                        this.printOut(string + "Conversion error for strLogSizeLimitInMB value to bytes : " + this.strLogSizeLimitInMB + " ,exception :" + exception.toString());
                        this.debugLogSizeLimitInMB = 1048576.0;
                    }
                } else {
                    this.debugLogSizeLimitInMB = 1048576.0;
                }
                if (fieldSep.length() != 0) break block21;
                string2 = sync0;
                synchronized (string2) {
                    if (fieldSep.length() == 0) {
                        object = new EgTesterInfo("agent");
                        fieldSep = ((EgTesterInfo)object).getDDSeparator1();
                    }
                }
            }
            catch (Exception exception) {
                this.printOutStackTrace(string, exception);
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "Host Name          :" + this.targetHost);
        this.printOut(string + "User name          :" + this.userName);
        this.printOut(string + "Password           :******* ");
        this.printOut(string + "SSH PortNo         :" + this.sshPortNo);
        this.printOut(string + "Timeout            :" + this.cmd_time_out);
        this.printOut(string + "Reporting name     :" + this.reportingName);
        this.printOut(string + "command to execute :" + STORAGE_CELL_DETAILS_COMMAND);
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.strSSHPort)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$OK");
            if (this.isStringNull(this.userName) || this.isStringNull(this.password)) {
                this.validationComment = "Please provide valid username/password ";
                this.validationMsgs.add(2, "User/Password$#$" + this.validationComment);
            } else {
                this.getValidatorMessage();
            }
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    protected void getValidatorMessage() {
        String string = "getValidatorMessage";
        string = this.methodNameTemplate(string);
        long l = System.currentTimeMillis();
        ArrayList arrayList = null;
        try {
            arrayList = this.cmdExecToOraExa(this.typ, this.targetHost, this.sshPortNo, this.userName, this.password, STORAGE_CELL_DETAILS_COMMAND);
            this.printOut(string + "Command output for the command \"" + STORAGE_CELL_DETAILS_COMMAND + "\"   : " + arrayList);
            if (this.isArrayListNull(arrayList)) {
                this.logMessage = string + "Output is null or empty ,so test returning ";
                this.printOut(this.logMessage);
                this.logMessage = "";
                this.validationComment = "Please verify the username/password or network ";
                this.validationMsgs.add(2, "User/Password$#$" + this.validationComment);
                return;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                this.printOut(string + "String line  :" + string2);
            }
            this.validationMsgs.add(2, "User/Password$#$OK");
            this.logMessage = string + "Total time to took to complete the process to collect the command output  " + STORAGE_CELL_DETAILS_COMMAND + " : " + (System.currentTimeMillis() - l) + " ms";
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        catch (Exception exception) {
            this.logMessage = string + "Error occured ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            this.validationComment = "Please verify the username/password or network ";
            this.validationMsgs.add(2, "User/Password$#$" + this.validationComment);
        }
    }

    private ArrayList cmdExecToOraExa(String string, String string2, int n, String string3, String string4, String string5) {
        long l = System.currentTimeMillis();
        String string6 = "cmdExecToOraExa";
        string6 = this.methodNameTemplate(string6);
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution starts for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                this.cmd_time_out = 0;
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    System.out.println("[ValidationProcess] cmdExecToOraExa EgJavaSSH block calling");
                    this.printOut(string6 + "Timeout cmd :" + this.cmd_time_out);
                    this.cmd_time_out = 0;
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, (long)this.cmd_time_out);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    ArrayList arrayList3 = new ArrayList();
                    if (arrayList2 != null) {
                        arrayList = (ArrayList)arrayList2.get(0);
                        arrayList3 = (ArrayList)arrayList2.get(1);
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            this.logMessage = string6 + "errorArrayList value greator than zero, so printing Error Message :" + arrayList3 + ",And All output :" + arrayList;
                            this.putErrorMessageToLogfile(this.logMessage);
                            this.logMessage = "";
                        }
                    }
                } else {
                    this.printOut(string6 + "EgSSHUtil condition ,Timeout for cmd :" + this.cmd_time_out);
                    arrayList = EgSSHUtil.getExecResults(string2, n, string3, string4, string5);
                    this.printOut(string6 + "cmd OutputArrayList :" + arrayList);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults(string2, n, string3, string4, string5);
            }
            if (arrayList == null) {
                this.logMessage = string6 + "Could not execute the command, Please verify the username/password or network ";
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
            if (arrayList.size() == 0) {
                this.logMessage = string6 + " ArrayList size is  less than zero   " + string5 + " for " + this.targetHost;
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
        }
        catch (Exception exception) {
            this.logMessage = string6 + "Problem while executing the command " + string5 + " for " + this.targetHost;
            this.logMessage = "";
            this.printOutStackTrace(this.logMessage, exception);
            arrayList = null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution ends for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        this.logMessage = string6 + " Total time(millis) took to execute " + l3 + "  for the command  " + string5;
        this.printOut(this.logMessage);
        this.logMessage = "";
        return arrayList;
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    protected boolean ifStringIsNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase(NULL);
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            OraExaValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        OraExaValidator oraExaValidator = new OraExaValidator(stringArray, new Boolean(false));
        oraExaValidator.getValidationMsgs();
    }
}

