/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraDbGrowthTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String viewName;
    private static final int i_measureCount = 5;
    private static double gbConvertor = 1.073741824E9;
    private boolean useMaxSize = true;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public OraDbGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        String string = this.getValueForParam("use_max_size");
        this.isNewDynamicInfoTest = true;
        this.viewName = this.getValueForParam("alternate_view");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string2 = this.getValueForParam("cloud_hosted");
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none")) {
            this.passwd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.useMaxSize = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                object2 = (String)((ArrayList)cloneable).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)cloneable).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        cloneable = new ArrayList();
        Connection connection = null;
        object2 = null;
        object = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string = "";
        double d6 = 0.0;
        try {
            string = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from DBA_FREE_SPACE group by file_id) b on a.file_id = b.file_id" : "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from " + this.viewName + " group by file_id) b on a.file_id = b.file_id";
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraDbGrowthTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug);
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug);
            }
            if (connection == null) {
                System.out.println(this.entity + " connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraDbGrowthTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        try {
                            object2.close();
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception5) {
                    System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + exception5.toString());
                }
                return;
            }
            object = object2.executeQuery(string);
            while (object.next()) {
                double d7 = object.getDouble(1);
                double d8 = object.getDouble(2);
                double d9 = object.getDouble(3);
                double d10 = object.getDouble(4);
                if (d8 == 0.0 || d8 < d9) {
                    d8 = d9;
                }
                if (this.useMaxSize) {
                    d3 += d8;
                    d6 = d8 - d9 + d10;
                    d += d6;
                    continue;
                }
                d3 += d9;
                d6 = d10;
                d += d6;
            }
            d4 = d3 / gbConvertor;
            d4 = d3 / gbConvertor;
            d2 = d / gbConvertor;
            ((ArrayList)cloneable).add(new Double(d4));
            ((ArrayList)cloneable).add(new Double(d4 - d2));
            ((ArrayList)cloneable).add(new Double(d2));
            BigDecimal bigDecimal = new BigDecimal((d4 - d2) / d4 * 100.0);
            bigDecimal = bigDecimal.setScale(2, 6);
            ((ArrayList)cloneable).add(new Double(bigDecimal.doubleValue()));
            BigDecimal bigDecimal2 = new BigDecimal(d2 / d4 * 100.0);
            bigDecimal2 = bigDecimal2.setScale(2, 6);
            ((ArrayList)cloneable).add(new Double(bigDecimal2.doubleValue()));
            System.out.println(this.entity + ":" + this.reportingName + " Oracle RAC DB Growth test measure ArrayList :" + cloneable);
            this.addNewMeasure((ArrayList)cloneable);
            object.close();
            object2.close();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraDbGrowthTest Failed to computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures():" + exception.toString());
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception) {}
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + exception.toString());
            }
        }
    }
}

