/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraDataFile_cf
extends OraServerBase {
    String strDriver;
    String strDbHost;
    String strDbPort;
    String strOraSid;
    String strUserName;
    String strPassword;
    String strUrl;
    String strQuery;
    private int measureCount = 4;

    public OraDataFile_cf(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(this.measureCount);
        this.strDbHost = this.targetHost;
        this.strDbPort = this.portNo;
        this.strOraSid = this.getValueForParam("info");
        this.strUserName = this.getValueForParam("user");
        this.strPassword = this.getValueForParam("password");
        this.strDriver = "oracle.jdbc.driver.OracleDriver";
        this.strUrl = "jdbc:oracle:thin:@" + this.strDbHost + ":" + this.strDbPort + ":" + this.strOraSid;
        this.strQuery = "SELECT FILE_NAME,TABLESPACE_NAME,BYTES/1024,MAXBYTES/1024 FROM DBA_DATA_FILES";
        this.setConfigInfoTestFlag(true);
        if (this.strOraSid == null) {
            this.strOraSid = this.getValueForParam("oracle_sid");
        }
        if (this.strOraSid == null || this.strOraSid.equalsIgnoreCase("NULL") || this.strOraSid.equalsIgnoreCase("none")) {
            this.strOraSid = "";
        }
        if ((string = this.getValueForParam("cloud_hosted")) != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.strOraSid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        try {
            connection = ConnectionManager.getConnection(this.entity, this.strDbHost, this.strDbPort, this.strOraSid, this.strUserName, this.strPassword, debug);
            if (connection == null) {
                return;
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.strQuery);
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ArrayList<String> arrayList = null;
            while (resultSet.next()) {
                arrayList = new ArrayList<String>();
                String string = resultSet.getString("FILE_NAME");
                String string2 = resultSet.getString("TABLESPACE_NAME");
                string2 = this.checkNull(string2, null);
                arrayList.add(string2);
                arrayList.add("-");
                string2 = resultSet.getString("MAXBYTES/1024");
                string2 = this.checkNull(string2, null);
                arrayList.add(string2);
                this.addNewMeasure(string, arrayList);
            }
        }
        catch (Exception exception) {
            this.configError = true;
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        OraDataFile_cf oraDataFile_cf = new OraDataFile_cf(stringArray);
        oraDataFile_cf.computeMeasures(new Hashtable());
    }
}

