/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class OraDataFileTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private String includePath = "no";
    private String queryStmt = null;
    private double defValue = -5.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private Hashtable prevHash = new Hashtable();
    private double sum_prevTotalIo;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraDataFileTest oraDataFileTest = new OraDataFileTest(stringArray);
        oraDataFileTest.computeMeasures(new Hashtable());
    }

    public OraDataFileTest(String[] stringArray) {
        super(stringArray);
        EgThresholdInfo egThresholdInfo;
        String[] stringArray2;
        this.numOutputFields = 2;
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.includePath = this.getValueForParam("includepath");
        String string = this.getValueForParam("cloud_hosted");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        if ((stringArray2 = (egThresholdInfo = new EgThresholdInfo("agent")).getMeasurementsForTest("OraDataFileTest")) != null) {
            this.numOutputFields = stringArray2.length;
        }
        egThresholdInfo = null;
        this.measureCount = this.numOutputFields;
        this.setMeasureCount(this.measureCount);
        this.queryStmt = "SELECT /*+ rule */ df.file#,df.name,fs.phyrds,fs.phywrts,fs.phyblkrd,fs.phyblkwrt,fs.phyblkrd+fs.phyblkwrt as Total_ios FROM v$filestat fs,v$dbfile df WHERE fs.file#=df.file# ORDER BY fs.phyblkrd+fs.phyblkwrt desc";
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                string2 = (String)((ArrayList)cloneable).get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)cloneable).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (cloneable == null) return;
            if (((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList == null) return;
            if (arrayList.size() <= 0) return;
            string2 = (String)arrayList.get(2);
            string = (String)arrayList.get(3);
            if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        double d = 0.0;
        Connection connection = null;
        Object var11_11 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraDataFileTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraDataFileTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                return;
            }
            resultSet = statement.executeQuery(this.queryStmt);
            double d2 = 0.0;
            Hashtable hashtable2 = new Hashtable();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Hashtable<String, ArrayList<Double>> hashtable3 = new Hashtable<String, ArrayList<Double>>();
            while (resultSet.next()) {
                arrayList = new ArrayList();
                String string3 = resultSet.getString("NAME");
                if (this.includePath.equalsIgnoreCase("no") || this.includePath.equalsIgnoreCase("false")) {
                    int n = string3.lastIndexOf("/");
                    if (n >= 0) {
                        string3 = new String(string3.substring(n + 1));
                    } else {
                        n = string3.lastIndexOf("\\");
                        string3 = new String(string3.substring(n + 1));
                    }
                }
                double d3 = resultSet.getDouble(5);
                double d4 = resultSet.getDouble(6);
                double d5 = resultSet.getDouble(7);
                d += d5;
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                hashtable3.put(string3, arrayList);
            }
            resultSet.close();
            statement.close();
            connection.close();
            if (hashtable3 == null) return;
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (this.prevHash != null && this.prevHash.size() > 0) {
                    ArrayList arrayList2 = (ArrayList)this.prevHash.get(string4);
                    ArrayList arrayList3 = (ArrayList)hashtable3.get(string4);
                    if (arrayList2 == null || arrayList3 == null) continue;
                    double d6 = (Double)arrayList3.get(0);
                    double d7 = (Double)arrayList3.get(1);
                    double d8 = (Double)arrayList3.get(2);
                    double d9 = (Double)arrayList2.get(0);
                    double d10 = (Double)arrayList2.get(1);
                    double d11 = (Double)arrayList2.get(2);
                    double d12 = d6 - d9;
                    double d13 = d7 - d10;
                    double d14 = d8 - d11;
                    double d15 = d - this.sum_prevTotalIo;
                    if (this.timeSinceLastTest > 0.0) {
                        if (d12 > 0.0) {
                            d12 /= this.timeSinceLastTest;
                        }
                        if (d13 > 0.0) {
                            d13 /= this.timeSinceLastTest;
                        }
                    }
                    double d16 = 0.0;
                    if (d15 > 0.0) {
                        d16 = d14 / d15 * 100.0;
                    }
                    arrayList = new ArrayList();
                    d12 = d12 < 0.0 ? -5.0 : d12;
                    d13 = d13 < 0.0 ? -5.0 : d13;
                    d16 = d16 < 0.0 ? -5.0 : d16;
                    arrayList.add(new Double(d12));
                    arrayList.add(new Double(d13));
                    if (this.measureCount > 2) {
                        arrayList.add(new Double(d16));
                    }
                } else {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    if (this.measureCount > 2) {
                        arrayList.add(new Double(-5.0));
                    }
                }
                this.addNewMeasure(string4, arrayList);
            }
            this.sum_prevTotalIo = d;
            this.prevHash = (Hashtable)hashtable3.clone();
            return;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception while executing OraDataFileTest for target: " + this.targetHost);
            exception.printStackTrace();
            this.logToErrorFile("Error", "OraDataFileTest error occured in computeMeasures : targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            try {
                connection.close();
                return;
            }
            catch (Exception exception8) {
                // empty catch block
                return;
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

