/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraDBFileGrowthTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String viewName;
    private static final int i_measureCount = 5;
    private static double gbConvertor = 1048576.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private int msgLogCounter = 0;

    public OraDBFileGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.viewName = this.getValueForParam("alternate_view");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        this.isNewDynamicInfoTest = true;
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none")) {
            this.passwd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                object2 = (String)((ArrayList)cloneable).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)cloneable).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug, this.reportingName);
            if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        cloneable = new ArrayList();
        Connection connection = null;
        object2 = null;
        object = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        try {
            string = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "SELECT FILE_NAME,NVL(FILE_SIZE_MB,0) \"FILE_SIZE(MB)\",NVL(USED_SIZE_MB,0) AS \"USED_SIZE(MB)\", NVL(FREE_SIZE_MB,0) AS \"FREE_SIZE(MB)\" FROM (SELECT FILE_NAME FILE_NAME,FILE_SIZE FILE_SIZE_MB,USED_SIZE USED_SIZE_MB,(FILE_SIZE - USED_SIZE) FREE_SIZE_MB FROM (SELECT FILE_ID,FILE_NAME,SUM(MAXBYTES) FILE_SIZE,sum(bytes) used_size FROM DBA_DATA_FILES GROUP BY FILE_ID,FILE_NAME) B )order by \"USED_SIZE(MB)\" desc" : "SELECT FILE_NAME,NVL(FILE_SIZE_MB,0) \"FILE_SIZE(MB)\",NVL(USED_SIZE_MB,0) AS \"USED_SIZE(MB)\", NVL(FREE_SIZE_MB,0) AS \"FREE_SIZE(MB)\" FROM (SELECT FILE_NAME FILE_NAME,FILE_SIZE FILE_SIZE_MB,USED_SIZE USED_SIZE_MB,(FILE_SIZE - USED_SIZE) FREE_SIZE_MB FROM (SELECT FILE_ID,FILE_NAME,SUM(MAXBYTES) FILE_SIZE,sum(bytes) used_size FROM DBA_DATA_FILES GROUP BY FILE_ID,FILE_NAME) B )order by \"USED_SIZE(MB)\" desc";
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, debug);
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraDBFileGrowthTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        try {
                            object2.close();
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception5) {
                    System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + exception5.toString());
                }
                return;
            }
            object = object2.executeQuery(string);
            System.out.println("[OraDBFileGrowthTest]query--------->" + string);
            while (object.next()) {
                BigDecimal bigDecimal;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                String string2 = object.getString("FILE_NAME");
                d = object.getDouble("FILE_SIZE(MB)") / gbConvertor;
                arrayList.add(new Double(d));
                d2 = object.getDouble("USED_SIZE(MB)") / gbConvertor;
                arrayList.add(new Double(d2));
                d3 = object.getDouble("FREE_SIZE(MB)") / gbConvertor;
                arrayList.add(new Double(d3));
                if (d != 0.0) {
                    bigDecimal = new BigDecimal(d2 / d * 100.0).setScale(2, 6);
                    arrayList.add(new Double(bigDecimal.doubleValue()));
                } else {
                    arrayList.add(new Double(-5.0));
                }
                if (d != 0.0) {
                    bigDecimal = new BigDecimal(d3 / d * 100.0).setScale(2, 6);
                    arrayList.add(new Double(bigDecimal.doubleValue()));
                } else {
                    arrayList.add(new Double(-5.0));
                }
                this.addNewMeasure(string2, arrayList);
            }
            object.close();
            object2.close();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraDBFileGrowthTest computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures():" + exception.toString());
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception) {}
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + exception.toString());
            }
        }
    }
}

