/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class OraCRReqTest
extends GenericTest {
    public String username = "";
    public String password = "";
    public String oraSid = "";
    private boolean service = true;
    private String serviceName = "";
    private Hashtable prevBlkRcvdTime_ht = new Hashtable();
    private Hashtable prevBlksRcvdCnt_ht = new Hashtable();
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private ArrayList prevInfoList = new ArrayList();

    public OraCRReqTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.isDynamicInfoTest = true;
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none") || this.username.length() == 0) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") || this.password.length() == 0) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none") || this.oraSid.length() == 0) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if ((string = this.getValueForParam("debug")) == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block33: {
            connection = null;
            statement = null;
            resultSet = null;
            String string = "select 'DB0'||inst_id as Instance, name, value from gv$sysstat where LOWER(name) in('gc cr block receive time','gc cr blocks received') order by 1";
            if (debug) {
                System.out.println("OraCRReqTest===>         queryStmt    \t" + string);
            }
            System.out.println("OraCRReqTest before getting connection:" + new Date());
            connection = ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.username, this.password, debug);
            if (connection == null) {
                this.logToErrorFile("Error :", this.entity, " Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + " serviceName:" + this.serviceName);
                break block33;
            }
            this.prevInfoList = new ArrayList();
            System.out.println("OraCRReqTest connection established:" + new Date());
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + " serviceName:" + this.serviceName, exception.toString());
                this.closeConn(connection);
                try {
                    this.closeRset(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            System.out.println("OraCRReqTest statement is created:" + new Date());
            resultSet = statement.executeQuery(string);
            Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
            Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            double d = 0.0;
            while (resultSet.next()) {
                string2 = resultSet.getString("Instance");
                string3 = resultSet.getString("NAME");
                string4 = resultSet.getString("VALUE");
                if (string4 != null && string4.length() != 0) {
                    d = Double.parseDouble(string4);
                }
                if ("gc cr blocks received".equals(string3)) {
                    hashtable2.put(string2, new Double(d));
                    continue;
                }
                if (!"gc cr block receive time".equals(string3)) continue;
                hashtable3.put(string2, new Double(d));
            }
            if (debug) {
                System.out.println("OraCRReqTest===>         blksRcvdCnt_ht    \t" + hashtable2);
                System.out.println("OraCRReqTest===>         blkRcvdTime_ht    \t" + hashtable3);
            }
            this.closeRset(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            if (hashtable2 != null && hashtable2.size() > 0 && hashtable3 != null && hashtable3.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    double d2 = 0.0;
                    double d3 = 0.0;
                    if (this.prevBlkRcvdTime_ht == null || this.prevBlkRcvdTime_ht.size() <= 0 || this.prevBlksRcvdCnt_ht == null || this.prevBlksRcvdCnt_ht.size() <= 0 || string5 == null) continue;
                    double d4 = this.getDoubleValue((Double)this.prevBlkRcvdTime_ht.get(string5));
                    double d5 = this.getDoubleValue((Double)this.prevBlksRcvdCnt_ht.get(string5));
                    double d6 = this.getDoubleValue((Double)hashtable3.get(string5));
                    double d7 = this.getDoubleValue((Double)hashtable2.get(string5));
                    d2 = this.getDiff(d6, d4);
                    d3 = this.getDiff(d7, d5);
                    double d8 = 0.0;
                    if (d3 > 0.0) {
                        d8 = d2 / d3;
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d8));
                    if (debug) {
                        System.out.println("OraCRReqTest===>   measureList    \t" + arrayList);
                    }
                    System.out.println("OraCRReqTest===>   measureList    \t" + arrayList + " CurrentTime:" + new Date());
                    this.addNewMeasure(string5, arrayList);
                    this.prevInfoList.add(string5);
                }
            }
            this.prevBlkRcvdTime_ht = hashtable3;
            this.prevBlksRcvdCnt_ht = hashtable2;
            this.closeRset(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            catch (Exception exception) {
                this.logToErrorFile("[OraCRReqTest] compute Measure()", "Exception while uploading ", exception.toString());
                exception.printStackTrace();
                int n = 0;
                while (n < this.prevInfoList.size()) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string6 = (String)this.prevInfoList.get(n);
                    for (int i = 0; i < this.measureCount; ++i) {
                        arrayList.add(new Double(-1.0));
                    }
                    System.out.println("Adding MeasureList :" + arrayList);
                    this.addNewMeasure(string6, arrayList);
                    ++n;
                }
                return;
            }
            finally {
                try {
                    this.closeRset(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        for (int i = 0; i < this.prevInfoList.size(); ++i) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string = (String)this.prevInfoList.get(i);
            for (int j = 0; j < this.measureCount; ++j) {
                arrayList.add(new Double(-1.0));
            }
            System.out.println("Adding MeasureList :" + arrayList);
            this.addNewMeasure(string, arrayList);
        }
        try {
            this.closeRset(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private double getDoubleValue(Double d) {
        double d2 = 0.0;
        if (d != null) {
            d2 = d;
        }
        return d2;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (!(d >= 0.0) || !(d2 >= 0.0) || !(d >= d2) || (d3 = d - d2) > 0.0) {
            // empty if block
        }
        return d3;
    }

    void closeRset(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public static void main(String[] stringArray) {
        OraCRReqTest oraCRReqTest = new OraCRReqTest(stringArray);
        while (true) {
            int n = 0;
            ++n;
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            oraCRReqTest.computeMeasures(new Hashtable());
        }
    }
}

