/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.NodeDataRepository;
import com.eg.org.slf4j.Logger;
import java.util.HashMap;
import java.util.Set;

public abstract class NodeBase
extends APMBase {
    public NodeInfo NodeInfoObj = null;
    private static final int Node_DEFAULT_PORT = 3000;
    private static final String Node_DEFAULT_IP = "127.0.0.1";
    protected static final Logger logger = AgentLogger.testLogger;
    protected String logPrefix = null;
    protected String NodeID = null;
    private boolean isFirstTime = true;
    private HashMap props = new HashMap();
    protected NodeDataRepository nodeRepository = null;

    public NodeBase(String[] args) {
        super(args);
        this.NodeID = "[" + this.reportingName + ":" + this.portNo + "]";
        this.logPrefix = "[" + this.entity + "] - " + this.NodeID;
        this.nodeRepository = NodeDataRepository.getRepository();
        this.getJvmGuid();
        try {
            logger.info("{} Initializing NodeBase ...", (Object)this.logPrefix);
            this.NodeInfoObj = new NodeInfo(this.reportingName);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info("{} Node IPAddress is null or empty or none : {}", (Object)this.logPrefix, (Object)this.targetHost);
                logger.info("{} Using Default Node IPAddress : {}", (Object)this.logPrefix, (Object)Node_DEFAULT_IP);
                this.NodeInfoObj.setNodeIp(Node_DEFAULT_IP);
            } else {
                logger.info("{} Using Node IPAddress : {}", (Object)this.logPrefix, (Object)this.targetHost);
                this.NodeInfoObj.setNodeIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info("{} Node Port is null or empty or none : {}", (Object)this.logPrefix, (Object)this.portNo);
                logger.info("{} Using Default Node port : {}", (Object)this.logPrefix, (Object)3000);
                this.NodeInfoObj.setNodePort(3000);
            } else {
                try {
                    int NodePort = Integer.parseInt(this.portNo);
                    logger.info("{} Using Node Port : {}", (Object)this.logPrefix, (Object)NodePort);
                    this.NodeInfoObj.setNodePort(NodePort);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info("{} Invalid Node port number : {}", (Object)this.logPrefix, (Object)this.portNo);
                    logger.info("{} Using Default Node port : {}", (Object)this.logPrefix, (Object)3000);
                    this.NodeInfoObj.setNodePort(3000);
                }
            }
            logger.info("{} NodeBase initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.error("{} Exception while initializing NodeBase {}", (Object)this.logPrefix, (Object)e);
        }
    }

    void checkForPropsChanges(String[] propsOrder) {
        try {
            HashMap currentPropsTable = null;
            HashMap modifiedPropsTable = null;
            HashMap previousPropsTable = new HashMap();
            if (this.isFirstTime) {
                modifiedPropsTable = this.getProps(propsOrder);
                this.isFirstTime = false;
            } else {
                previousPropsTable = this.props;
                currentPropsTable = this.getProps(propsOrder);
                modifiedPropsTable = this.getModifiedProps(currentPropsTable, previousPropsTable);
                logger.debug("{} currentPropsTable: {}", (Object)this.logPrefix, (Object)currentPropsTable);
                logger.debug("{} previousPropsTable: {}", (Object)this.logPrefix, (Object)previousPropsTable);
                logger.debug("{} modifiedPropsTable: {}", (Object)this.logPrefix, (Object)modifiedPropsTable);
            }
            if (modifiedPropsTable != null && modifiedPropsTable.size() > 0) {
                APMComponent apmComponent = APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
                if (apmComponent != null) {
                    apmComponent.setPropsDetails(String.valueOf(this.apmComponentGUID) + "-" + this.entity, modifiedPropsTable);
                }
            } else {
                logger.debug("{}  No difference in props table:", (Object)this.logPrefix);
            }
            this.props = currentPropsTable;
        }
        catch (Exception e) {
            logger.error("{} Exception while checking props change from NodeBase {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private HashMap getProps(String[] propsOrder) {
        HashMap<String, String> propsdata = new HashMap<String, String>();
        int i = 0;
        while (i < propsOrder.length) {
            String testConfValue = this.getValueForParam(propsOrder[i]);
            if (testConfValue != null) {
                propsdata.put(propsOrder[i], testConfValue);
            } else {
                propsdata.put(propsOrder[i], "-");
            }
            ++i;
        }
        return propsdata;
    }

    protected HashMap getModifiedProps(HashMap currentPropsTable, HashMap previousPropsTable) {
        HashMap<String, String> resultTable = new HashMap<String, String>();
        logger.debug("{} - getModifiedProps : currentTable: {}  \t  previousTable : {}", new Object[]{this.logPrefix, currentPropsTable, previousPropsTable});
        if (currentPropsTable != null && currentPropsTable.size() > 0) {
            Set currentKeySet = currentPropsTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentPropsTable.get(currentKey);
                if (previousPropsTable != null && previousPropsTable.containsKey(currentKey)) {
                    String previousValue = (String)previousPropsTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }
}

