/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class NimbleIOPerfTest
extends EgSnmpGenericTest {
    private double prev_RandomIORead = -5.0;
    private double prev_RandomIOWrite = -5.0;
    private double prev_SeqIOReads = -5.0;
    private double prev_SeqIOWrites = -5.0;
    private double prev_ioReads = -5.0;
    private double prev_ioWrites = -5.0;
    private double prev_ioReadTime = -5.0;
    private double prev_ioWriteTime = -5.0;
    private double randomIOReadOper = -5.0;
    private double randomIOWriteOper = -5.0;

    public NimbleIOPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.37447.1.3.2");
            double d2 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.4");
            double d3 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.3");
            double d4 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.5");
            double d5 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.6");
            double d6 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.7");
            if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0 || d5 < 0.0 || d6 < 0.0) {
                this.prev_RandomIORead = -5.0;
                this.prev_RandomIOWrite = -5.0;
                this.prev_SeqIOReads = -5.0;
                this.prev_SeqIOWrites = -5.0;
                this.prev_ioReads = -5.0;
                this.prev_ioWrites = -5.0;
                this.prev_ioReadTime = -5.0;
                this.prev_ioWriteTime = -5.0;
                return;
            }
            this.randomIOReadOper = d >= 0.0 && d3 >= 0.0 ? d - d3 : -5.0;
            this.randomIOWriteOper = d2 >= 0.0 && d4 >= 0.0 ? d2 - d4 : -5.0;
            double d7 = this.getDiff(this.randomIOReadOper, this.prev_RandomIORead, true);
            double d8 = this.getDiff(this.randomIOWriteOper, this.prev_RandomIOWrite, true);
            double d9 = this.getDiff(d3, this.prev_SeqIOReads, true);
            double d10 = this.getDiff(d4, this.prev_SeqIOWrites, true);
            double d11 = this.getDiff(d, this.prev_ioReads, true);
            double d12 = this.getDiff(d2, this.prev_ioWrites, true);
            double d13 = this.getDiff(d5, this.prev_ioReadTime, true);
            double d14 = this.getDiff(d6, this.prev_ioWriteTime, true);
            double d15 = -5.0;
            double d16 = -5.0;
            if (d13 > 0.0) {
                if (d11 > 0.0) {
                    d13 /= d11;
                    d13 /= 1000.0;
                } else {
                    d13 = 0.0;
                }
            } else {
                d13 = 0.0;
            }
            if (d14 > 0.0) {
                if (d12 > 0.0) {
                    d14 /= d12;
                    d14 /= 1000.0;
                } else {
                    d14 = 0.0;
                }
            } else {
                d14 = 0.0;
            }
            d16 = d13 >= 0.0 && d14 >= 0.0 ? (d13 + d14) / 2.0 : -5.0;
            d15 = d11 >= 0.0 && d12 >= 0.0 ? d11 + d12 : -5.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d9));
            arrayList.add(new Double(d10));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d11));
            arrayList.add(new Double(d12));
            arrayList.add(new Double(d13));
            arrayList.add(new Double(d14));
            arrayList.add(new Double(d16));
            arrayList.add(new Double(d15));
            System.out.println("[NimbleIOPerfTest]  measureList===>" + arrayList);
            this.addNewMeasure(arrayList);
            this.prev_RandomIORead = this.randomIOReadOper;
            this.prev_RandomIOWrite = this.randomIOWriteOper;
            this.prev_SeqIOReads = d3;
            this.prev_SeqIOWrites = d4;
            this.prev_ioReads = d;
            this.prev_ioWrites = d2;
            this.prev_ioReadTime = d5;
            this.prev_ioWriteTime = d6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }

    private double getDiff(double d, double d2, boolean bl) {
        double d3 = -5.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d - d2;
            if (this.timeSinceLastTest > 0.0 && d3 >= 0.0 && bl) {
                d3 /= this.timeSinceLastTest;
            }
            if (d3 < 0.0) {
                d3 = -5.0;
            }
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.170", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        NimbleIOPerfTest nimbleIOPerfTest = new NimbleIOPerfTest(stringArray2);
        try {
            while (true) {
                nimbleIOPerfTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

