/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluVserPeerTest
extends NAUSDCluBase {
    private boolean isFirstTime = true;

    public NetCluVserPeerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluVserPeerTest ", "Connection is null");
                this.printOut("Error", "NetCluVserPeerTest Connection is null ");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluVserPeerTest error occured while connecting ", exception.toString());
            this.printOut("Error", "NetCluVserPeerTest error occured while connecting :" + exception.toString());
            exception.printStackTrace();
        }
        try {
            NaElement naElement = new NaElement("vserver-peer-get-iter");
            Iterator iterator = null;
            String string = "";
            while (string != null) {
                int n;
                naElement = new NaElement("vserver-peer-get-iter");
                naElement.addNewChild("max-records", "10");
                if (!string.equals("")) {
                    naElement.addNewChild("tag", string);
                }
                Object object = this.execONTAPIlog(naServer, naElement);
                NaAPIFailedException naAPIFailedException = null;
                if (object instanceof Exception) {
                    string = null;
                    if (object instanceof NaAPIFailedException) {
                        naAPIFailedException = (NaAPIFailedException)object;
                        n = naAPIFailedException.getErrno();
                        if (13005 == n) {
                            if (!this.isFirstTime) continue;
                            this.logToErrorFile("INFO", "NetCluVserPeerTest", "netapp.manage.NaAPIFailedException: Unable to find API: vserver-peer-get-iter ");
                            this.isFirstTime = false;
                            continue;
                        }
                        this.logToErrorFile("INFO", "NetCluVserPeerTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                        continue;
                    }
                    this.logToErrorFile("INFO", "NetCluVserPeerTest", "Exception" + object.toString());
                    continue;
                }
                NaElement naElement2 = (NaElement)object;
                if (naElement2 == null) {
                    this.closeConnection(naServer);
                    this.printOut("DEBUG", "NetCluVserPeerTest output is null ");
                    return;
                }
                n = naElement2.getChildIntValue("num-records", 0);
                string = naElement2.getChildContent("next-tag");
                if (n <= 0) {
                    this.printOut("DEBUG", "NetCluVserPeerTest noOfRecords is zero ");
                    break;
                }
                List list = naElement2.getChildByName("attributes-list").getChildren();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    NaElement naElement3 = (NaElement)iterator.next();
                    String string2 = naElement3.getChildContent("peer-vserver");
                    String string3 = naElement3.getChildContent("peer-state");
                    System.out.println("peerVserver:" + string2 + " state:" + string3);
                    if (string2 == null || string3 == null) continue;
                    arrayList = new ArrayList();
                    if (string3.equals("peered")) {
                        arrayList.add(new Double(1.0));
                    } else if (string3.equals("pending")) {
                        arrayList.add(new Double(2.0));
                    } else if (string3.equals("initializing")) {
                        arrayList.add(new Double(3.0));
                    } else if (string3.equals("initiated")) {
                        arrayList.add(new Double(4.0));
                    } else if (string3.equals("deleted")) {
                        arrayList.add(new Double(5.0));
                    } else if (string3.equals("suspended")) {
                        arrayList.add(new Double(6.0));
                    } else if (string3.equals("rejected")) {
                        arrayList.add(new Double(7.0));
                    }
                    this.addNewMeasure(string2, arrayList);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluVserPeerTest error occured while connecting ", exception.toString());
            this.printOut("Error", "NetCluVserPeerTest error occured while connecting :" + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    public static void main(String[] stringArray) {
        NetCluVserPeerTest netCluVserPeerTest = new NetCluVserPeerTest(stringArray);
        netCluVserPeerTest.computeMeasures(new Hashtable());
    }
}

