/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class NAUSDSnapshotsTest
extends NAUSDBase {
    long lastMillis = 0L;
    ArrayList volsList;
    ArrayList aggrsList;
    ArrayList includeVolsList;
    ArrayList includeAggrsList;
    ArrayList excludeVolsList;
    ArrayList excludeAggrsList;

    public NAUSDSnapshotsTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.includeVolsList = this.getPatternsList(this.getValueForParam("Include_volumes"));
        this.excludeVolsList = this.getPatternsList(this.getValueForParam("Exclude_volumes"));
        this.includeAggrsList = this.getPatternsList(this.getValueForParam("Include_aggregates"));
        this.excludeAggrsList = this.getPatternsList(this.getValueForParam("Exclude_aggregates"));
        this.printOut("INFO", "Vol filter params : include = " + this.includeVolsList.toString() + ", exclude = " + this.excludeVolsList.toString());
        this.printOut("INFO", "Aggr filter params : include = " + this.includeAggrsList.toString() + ", exclude = " + this.excludeAggrsList.toString());
        this.setMeasureCount(6);
    }

    ArrayList getPatternsList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        if ((string = string.trim()).equalsIgnoreCase("none")) {
            return arrayList;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string2 = this.replaceAll(string2, "*", "");
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        NaServer naServer = null;
        naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        this.populateInstances(naServer);
        this.addSnapsForInstances(naServer, this.volsList, "volume", bl);
        this.addSnapsForInstances(naServer, this.aggrsList, "aggregate", bl);
        this.closeConnection(naServer);
    }

    void addSnapsForInstances(NaServer naServer, ArrayList arrayList, String string, boolean bl) {
        NaElement naElement = null;
        NaElement naElement2 = null;
        NaElement naElement3 = null;
        List list = null;
        Iterator iterator = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            naElement = new NaElement("snapshot-list-info");
            naElement.addNewChild("lun-clone-snapshot", "true");
            naElement.addNewChild("target-name", string2);
            naElement.addNewChild("target-type", string);
            naElement.addNewChild("terse", "true");
            naElement2 = this.execONTAPI(naServer, naElement);
            if (naElement2 == null) continue;
            naElement3 = naElement2.getChildByName("snapshots");
            list = naElement3.getChildren();
            iterator = list.iterator();
            String string3 = null;
            Double d = null;
            Double d2 = null;
            Double d3 = null;
            Double d4 = null;
            long l = 0L;
            Double d5 = NADbl;
            Double d6 = FalseDbl;
            Double d7 = FalseDbl;
            ArrayList<Double> arrayList2 = null;
            while (iterator.hasNext()) {
                naElement3 = (NaElement)iterator.next();
                d6 = this.getChildBooleanMeas(naElement3, "busy");
                if (d6.doubleValue() != TrueDbl.doubleValue()) continue;
                arrayList2 = new ArrayList<Double>();
                string3 = string2 + "/" + naElement3.getChildContent("name");
                d = this.getChildDbl(naElement3, "percentage-of-total-blocks");
                d2 = this.getChildDbl(naElement3, "percentage-of-used-blocks");
                d3 = this.getChildDbl(naElement3, "cumulative-percentage-of-total-blocks");
                d4 = this.getChildDbl(naElement3, "cumulative-percentage-of-used-blocks");
                l = naElement3.getChildIntValue("access-time", -5);
                if (l == -5L) {
                    d5 = NADbl;
                } else {
                    l *= 1000L;
                    l = System.currentTimeMillis() - l;
                    d5 = new Double((double)l / 8.64E7);
                }
                d7 = this.getChildBooleanMeas(naElement3, "contains-lun-clones");
                arrayList2.add(d);
                arrayList2.add(d2);
                arrayList2.add(d3);
                arrayList2.add(d4);
                arrayList2.add(d5);
                arrayList2.add(d7);
                this.printOut("DEBUG", "Adding measure for snapshot " + string3 + " : " + arrayList2.toString());
                if (bl) continue;
                this.addNewMeasure(string3, arrayList2);
            }
        }
    }

    void populateInstances(NaServer naServer) {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastMillis;
        String string = null;
        if (l2 > 5L * this.measurePeriod) {
            int n;
            ArrayList arrayList = null;
            ArrayList arrayList2 = null;
            this.volsList = new ArrayList();
            this.printOut("DEBUG", "populating volumes");
            arrayList = this.getInstances(naServer, "volume");
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.includeVolsList.isEmpty() && this.excludeVolsList.isEmpty()) {
                    this.volsList.add(string);
                    continue;
                }
                if (!this.includeVolsList.isEmpty() && this.isInList(this.includeVolsList, string)) {
                    this.volsList.add(string);
                    continue;
                }
                if (!this.excludeVolsList.isEmpty() && !this.isInList(this.excludeVolsList, string)) {
                    this.volsList.add(string);
                    continue;
                }
                if (!this.isInList(this.includeVolsList, string) || this.isInList(this.excludeVolsList, string)) continue;
                this.volsList.add(string);
            }
            this.printOut("DEBUG", "populating aggregates");
            this.aggrsList = new ArrayList();
            arrayList2 = this.getInstances(naServer, "aggregate");
            for (n = 0; n < arrayList2.size(); ++n) {
                string = (String)arrayList2.get(n);
                if (this.includeAggrsList.isEmpty() && this.excludeAggrsList.isEmpty()) {
                    this.aggrsList.add(string);
                    continue;
                }
                if (!this.includeAggrsList.isEmpty() && this.isInList(this.includeAggrsList, string)) {
                    this.aggrsList.add(string);
                    continue;
                }
                if (!this.excludeAggrsList.isEmpty() && !this.isInList(this.excludeAggrsList, string)) {
                    this.aggrsList.add(string);
                    continue;
                }
                if (!this.isInList(this.includeAggrsList, string) || this.isInList(this.excludeAggrsList, string)) continue;
                this.aggrsList.add(string);
            }
            this.printOut("INFO", "Selected volumes : " + this.volsList.toString() + " and selected aggregates : " + this.aggrsList.toString());
            this.lastMillis = l;
        }
    }

    boolean isInList(ArrayList arrayList, String string) {
        String string2 = null;
        if (arrayList.size() == 0) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            if (string.indexOf(string2) <= -1) continue;
            return true;
        }
        return false;
    }

    ArrayList getInstances(NaServer naServer, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NaElement naElement = new NaElement("perf-object-instance-list-info");
        naElement.addNewChild("objectname", string);
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return arrayList;
        }
        NaElement naElement3 = naElement2.getChildByName("instances");
        List list = naElement3.getChildren();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        NaElement naElement4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            naElement4 = (NaElement)iterator.next();
            String string2 = naElement4.getChildContent("name");
            stringBuffer.append(string2).append(",");
            arrayList.add(string2);
        }
        this.printOut("DEBUG", "Instances for object " + string + " : " + stringBuffer.toString());
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NAUSDSnapshotsTest nAUSDSnapshotsTest = new NAUSDSnapshotsTest(stringArray);
        nAUSDSnapshotsTest.debugComputeMeasures(new Hashtable(), true);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nAUSDSnapshotsTest.printOut("DEBUG", "----- AGAIN ------");
        nAUSDSnapshotsTest.debugComputeMeasures(new Hashtable(), true);
    }
}

