/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class NAUSDNFSIOStatsTest
extends NAUSDBase {
    private static String[] nfsv3counters = new String[]{"nfsv3_ops", "nfsv3_read_ops", "nfsv3_read_latency", "nfsv3_write_ops", "nfsv3_write_latency", "nfsv3_avg_op_latency", "nfsv3_avg_read_latency_base", "nfsv3_avg_write_latency_base", "nfsv3_avg_op_latency_base"};
    private static String[] nfsv4counters = new String[]{"nfsv4_ops", "nfsv4_read_ops", "nfsv4_read_latency", "nfsv4_write_ops", "nfsv4_write_latency", "nfsv4_avg_op_latency", "nfsv4_avg_read_latency_base", "nfsv4_avg_write_latency_base", "nfsv4_avg_op_latency_base"};
    private boolean nfs = true;
    private static final int measureCount = 8;
    private ArrayList prevlist = new ArrayList();
    public Hashtable prevPerf = new Hashtable();

    public NAUSDNFSIOStatsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = this.getPerfInstance(naServer, nfsv3counters, "nfsv3", null);
        Hashtable hashtable4 = this.getPerfInstance(naServer, nfsv4counters, "nfsv4", null);
        ArrayList arrayList = this.getStatus(naServer);
        this.closeConnection(naServer);
        if (hashtable3 != null && hashtable3.size() > 0 && hashtable4 != null && hashtable4.size() > 0) {
            hashtable2.putAll(hashtable3);
            hashtable2.putAll(hashtable4);
        }
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                ArrayList arrayList2;
                String string = (String)enumeration.nextElement();
                String string2 = (String)arrayList.get(0);
                String string3 = (String)arrayList.get(1);
                if (this.prevPerf != null && this.prevPerf.size() > 0) {
                    arrayList2 = (ArrayList)hashtable2.get(string);
                    ArrayList arrayList3 = (ArrayList)this.prevPerf.get(string);
                    if (arrayList3 == null || arrayList2 == null) continue;
                    ArrayList arrayList4 = this.getDiffList(arrayList2, arrayList3);
                    ArrayList<Double> arrayList5 = new ArrayList<Double>();
                    Double d = this.divide(arrayList4.get(1), arrayList4.get(0));
                    Double d2 = this.divide(arrayList4.get(2), arrayList4.get(0));
                    Double d3 = this.divide(arrayList4.get(3), arrayList4.get(7));
                    Double d4 = this.divide(arrayList4.get(4), arrayList4.get(0));
                    Double d5 = this.divide(arrayList4.get(5), arrayList4.get(8));
                    Double d6 = this.divide(arrayList4.get(6), arrayList4.get(9));
                    d6 = this.divide(d6, new Double(1000.0));
                    arrayList5.add(new Double(string2));
                    arrayList5.add(new Double(string3));
                    arrayList5.add(d);
                    arrayList5.add(d2);
                    arrayList5.add(d3);
                    arrayList5.add(d4);
                    arrayList5.add(d5);
                    arrayList5.add(d6);
                    if (string.equalsIgnoreCase("nfs")) {
                        string = string + "v3";
                    }
                    System.out.println("From 2nd measure=======>" + string + "   measure=======>" + arrayList5);
                    this.addNewMeasure(string, arrayList5);
                    continue;
                }
                arrayList2 = new ArrayList();
                arrayList2.add(new Double(string2));
                arrayList2.add(new Double(string3));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                if (string.equalsIgnoreCase("nfs")) {
                    string = string + "v3";
                }
                System.out.println("From 1st measure=======>" + string + "   measure=======>" + arrayList2);
                this.addNewMeasure(string, arrayList2);
            }
            this.prevPerf = (Hashtable)hashtable2.clone();
        }
    }

    private ArrayList getStatus(NaServer naServer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NaElement naElement = new NaElement("nfs-status");
        Object object = this.execONTAPIlog(naServer, naElement);
        NaAPIFailedException naAPIFailedException = null;
        NaElement naElement2 = null;
        if (object instanceof Exception) {
            arrayList.add("-5");
            arrayList.add("-5");
            if (object instanceof NaAPIFailedException) {
                naAPIFailedException = (NaAPIFailedException)object;
                int n = naAPIFailedException.getErrno();
                if (13008 == n) {
                    if (this.nfs) {
                        this.logToErrorFile("INFO", "NAUSDNFSIoStatsTest", "NaAPIFailedException[nfs-status] This test cannot be monitored without FCP License");
                        this.nfs = false;
                    }
                } else {
                    this.logToErrorFile("INFO", "NAUSDNFSIoStatsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                }
            } else {
                this.logToErrorFile("INFO", "NAUSDNFSIoStatsTest", "Exception" + object.toString());
            }
        } else {
            naElement2 = (NaElement)object;
            String string = naElement2.getChildContent("is-drained");
            String string2 = naElement2.getChildContent("is-enabled");
            string = "true".equals(string) ? "1" : "0";
            string2 = "true".equals(string2) ? "1" : "0";
            arrayList.add(string2);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NAUSDNFSIOStatsTest nAUSDNFSIOStatsTest = new NAUSDNFSIOStatsTest(stringArray);
        while (true) {
            try {
                while (true) {
                    nAUSDNFSIOStatsTest.computeMeasures(new Hashtable());
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

