/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class MongoTicket
extends MongoDbBaseTest {
    private ArrayList prevTicketList = new ArrayList();
    private boolean isFirstTime = true;
    private String engineType = "";
    private double versionNumber = 1.0;

    public MongoTicket(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Object object;
            this.collectMetrics();
            Hashtable hashtable2 = this.getData();
            System.out.println(this.entity + " ticketHash:" + hashtable2);
            if (hashtable2 == null || hashtable2.size() == 0) {
                return;
            }
            if (this.isFirstTime) {
                if (hashtable2.containsKey("version") && hashtable2.containsKey("storageEngine")) {
                    object = "";
                    object = (String)hashtable2.get("version");
                    this.engineType = (String)hashtable2.get("storageEngine");
                    System.out.println(this.entity + " version:" + (String)object);
                    System.out.println(this.entity + " engineType:" + this.engineType);
                    if (object != null && ((String)object).length() > 0) {
                        object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                        try {
                            this.versionNumber = Double.parseDouble((String)object);
                        }
                        catch (Exception exception) {
                            this.isFirstTime = true;
                            return;
                        }
                    }
                } else {
                    this.isFirstTime = true;
                    return;
                }
                this.isFirstTime = false;
            }
            if (this.versionNumber < 3.2) {
                this.logToErrorFile("INFO :", this.entity + " support from Mongo Database version 3.2 onwards ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName);
                return;
            }
            if (!this.engineType.equalsIgnoreCase("wiredTiger")) {
                this.logToErrorFile("INFO :", this.entity + " support wiredTiger storage engine type Mongo Database version 3.2 onwards ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName);
            }
            if ((object = (ArrayList)hashtable2.get("concurrentTransactions")) != null && ((ArrayList)object).size() == 6) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                d5 = this.getDoubleValue((String)((ArrayList)object).get(0));
                d6 = this.getDoubleValue((String)((ArrayList)object).get(1));
                d4 = this.getDoubleValue((String)((ArrayList)object).get(2));
                d2 = this.getDoubleValue((String)((ArrayList)object).get(3));
                d3 = this.getDoubleValue((String)((ArrayList)object).get(4));
                d = this.getDoubleValue((String)((ArrayList)object).get(5));
                if (d > 0.0) {
                    d7 = d2 / d * 100.0;
                }
                if (d4 > 0.0) {
                    d8 = d5 / d4 * 100.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d8));
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d2 >= 0.0 && d >= d2 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        MongoTicket mongoTicket = new MongoTicket(stringArray);
        mongoTicket.computeMeasures(new Hashtable());
    }
}

