/*
 * Decompiled with CFR 0.152.
 */
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class MongoNetTest
extends GenericTest {
    DB db = null;
    String CollectionName = null;
    String dbName = "admin";
    int portNumber = 27017;
    String userName = "";
    String passWord = "";
    String authMechanism = "";
    public ArrayList mongoNetDDList = new ArrayList();
    String caFile = "";
    String certKeyFile = "";
    String ssl = "";
    boolean isMongoSSLEnabled = false;

    public MongoNetTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.CollectionName = this.getValueForParam("Collection_name");
        this.dbName = this.getValueForParam("Database_name");
        this.userName = this.getValueForParam("username");
        this.passWord = this.getValueForParam("password");
        if (this.dbName == null || this.dbName.trim().length() == 0) {
            this.dbName = "admin";
        }
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.passWord == null || this.passWord.equalsIgnoreCase("NULL") || this.passWord.equalsIgnoreCase("none")) {
            this.passWord = "";
        }
        if (this.CollectionName == null || this.CollectionName.equalsIgnoreCase("NULL") || this.CollectionName.equalsIgnoreCase("none")) {
            this.CollectionName = "none";
        }
        try {
            this.portNumber = Integer.parseInt(this.portNo);
        }
        catch (Exception exception) {
            this.logToErrorFile("WARN : ", "MongoNetTest ", " Port Number is null or empty. So assiging 27017 (default port) for targetHost : " + this.targetHost);
        }
        this.authMechanism = this.getValueForParam("Authentication_mechanism");
        if (this.authMechanism == null || this.authMechanism.equalsIgnoreCase("NULL") || this.authMechanism.equalsIgnoreCase("none")) {
            this.authMechanism = "NONE";
        }
        this.ssl = this.getValueForParam("ssl");
        if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
            this.isMongoSSLEnabled = true;
            this.caFile = this.getValueForParam("ca_file");
            this.certKeyFile = this.getValueForParam("certificate_key_file");
            if (this.caFile == null || this.caFile.trim().length() == 0 || this.caFile.equalsIgnoreCase("NULL") || this.caFile.equalsIgnoreCase("none")) {
                this.caFile = "";
                this.logToErrorFile("WARN : ", this.entity, " CA file is null or empty.  for targetHost : " + this.targetHost);
            }
            if (this.certKeyFile == null || this.certKeyFile.trim().length() == 0 || this.certKeyFile.equalsIgnoreCase("NULL") || this.certKeyFile.equalsIgnoreCase("none")) {
                this.logToErrorFile("WARN : ", this.entity, " Certificate key file  is null or empty.  for targetHost : " + this.targetHost);
                this.certKeyFile = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        double d = 0.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        MongoClient mongoClient = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            long l;
            long l2;
            block42: {
                Object object;
                block41: {
                    l2 = System.currentTimeMillis();
                    l = 0L;
                    try {
                        MongoClientOptions mongoClientOptions;
                        MongoCredential mongoCredential;
                        System.out.println(this.entity + " authMechanism::" + this.authMechanism);
                        if (this.authMechanism.equalsIgnoreCase("NONE")) {
                            mongoCredential = MongoCredential.createCredential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                            if (this.isMongoSSLEnabled) {
                                object = this.createSSLContext(this.caFile, this.certKeyFile);
                                mongoClientOptions = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)((SSLContext)object).getSocketFactory()).build();
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                }, mongoClientOptions);
                            } else {
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                });
                            }
                        } else if (this.authMechanism.equalsIgnoreCase("SCRAM-SHA-1")) {
                            mongoCredential = MongoCredential.createScramSha1Credential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                            if (this.isMongoSSLEnabled) {
                                object = this.createSSLContext(this.caFile, this.certKeyFile);
                                mongoClientOptions = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)((SSLContext)object).getSocketFactory()).build();
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                }, mongoClientOptions);
                            } else {
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                });
                            }
                        } else if (this.authMechanism.equalsIgnoreCase("PLAIN")) {
                            this.dbName = "$external";
                            mongoCredential = MongoCredential.createPlainCredential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                            if (this.isMongoSSLEnabled) {
                                object = this.createSSLContext(this.caFile, this.certKeyFile);
                                mongoClientOptions = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)((SSLContext)object).getSocketFactory()).build();
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                }, mongoClientOptions);
                            } else {
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                });
                            }
                            this.dbName = "admin";
                        } else if (this.authMechanism.equalsIgnoreCase("GSSAPI")) {
                            mongoCredential = MongoCredential.createGSSAPICredential((String)this.userName);
                            if (this.isMongoSSLEnabled) {
                                object = this.createSSLContext(this.caFile, this.certKeyFile);
                                mongoClientOptions = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)((SSLContext)object).getSocketFactory()).build();
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                }, mongoClientOptions);
                            } else {
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                });
                            }
                        } else if (this.authMechanism.equalsIgnoreCase("MONGODB-X509")) {
                            mongoCredential = MongoCredential.createMongoX509Credential((String)this.userName);
                            if (this.isMongoSSLEnabled) {
                                object = this.createSSLContext(this.caFile, this.certKeyFile);
                                mongoClientOptions = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)((SSLContext)object).getSocketFactory()).build();
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                }, mongoClientOptions);
                            } else {
                                mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>(){
                                    {
                                        this.add(mongoCredential);
                                    }
                                });
                            }
                        }
                        this.db = mongoClient.getDB(this.dbName);
                        this.db.command("ping");
                        d3 = 100.0;
                    }
                    catch (Exception exception) {
                        d3 = 0.0;
                        d4 = -5.0;
                        object = EgInstallInfo.getStackTraceAsString(exception).toString();
                        this.mongoNetDDList.add(object);
                        exception.printStackTrace();
                        if (this.db != null) {
                            this.db = null;
                        }
                        if (mongoClient == null) break block41;
                        mongoClient.close();
                    }
                }
                try {
                    long l3 = System.currentTimeMillis();
                    if (d3 == 100.0) {
                        d = 100.0;
                        d4 = (double)(l3 - l2) / 1000.0;
                    } else {
                        d = 0.0;
                    }
                    long l4 = System.currentTimeMillis();
                    if (d3 != 100.0 || this.CollectionName.equalsIgnoreCase("none")) break block42;
                    DBCollection dBCollection = this.db.getCollectionFromString(this.CollectionName);
                    DBCursor dBCursor = dBCollection.find();
                    System.out.println("cursor::" + dBCursor);
                    try {
                        if (dBCursor != null) {
                            d5 = 100.0;
                            d7 = 0.0;
                            d7 = dBCursor.count();
                            while (dBCursor.hasNext()) {
                                dBCursor.next();
                            }
                            System.out.println(this.entity + "noOfRecord::" + d7);
                            l = System.currentTimeMillis();
                            if (d5 == 100.0) {
                                d6 = (double)(l - l4) / 1000.0;
                            }
                            System.out.println(this.entity + "docExecTime::" + d6);
                        }
                    }
                    catch (Exception exception) {
                        d5 = 0.0;
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    object = EgInstallInfo.getStackTraceAsString(exception).toString();
                    this.mongoNetDDList.add(object);
                    this.logToErrorFile("INFO :", this.entity, "Exception occured in  targetHost " + this.targetHost + " Error::" + (String)object + " reportingName :" + this.reportingName);
                }
            }
            if (d == 100.0) {
                l = System.currentTimeMillis();
                d2 = (double)(l - l2) / 1000.0;
            }
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d7));
            System.out.println("MongoNetTest reportingName::" + this.reportingName + "  measureList::" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            if (this.db != null) {
                this.db = null;
            }
            if (mongoClient != null) {
                mongoClient.close();
            }
            exception.printStackTrace();
        }
        finally {
            if (this.db != null) {
                this.db = null;
            }
            if (mongoClient != null) {
                mongoClient.close();
            }
        }
    }

    private SSLContext createSSLContext(String string, String string2) {
        KeyStore keyStore;
        Object object;
        Object object2;
        Object object3;
        TrustManagerFactory trustManagerFactory = null;
        try {
            object3 = new FileInputStream(string);
            object2 = CertificateFactory.getInstance("X.509");
            object = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object3);
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry("caCert", (Certificate)object);
            trustManagerFactory.init(keyStore);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = null;
        try {
            object2 = new FileReader(string2);
            object = KeyStore.getInstance(KeyStore.getDefaultType());
            ((KeyStore)object).load(null);
            keyStore = new PEMParser((Reader)object2);
            PEMKeyPair pEMKeyPair = (PEMKeyPair)keyStore.readObject();
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pEMKeyPair);
            JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)keyStore.readObject();
            X509Certificate x509Certificate = jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
            ((KeyStore)object).setKeyEntry("alias", keyPair.getPrivate(), "".toCharArray(), new Certificate[]{x509Certificate});
            object3 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object3).init((KeyStore)object, "".toCharArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = null;
        try {
            object2 = SSLContext.getInstance("TLSv1.2");
            ((SSLContext)object2).init(((KeyManagerFactory)object3).getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        try {
            MongoNetTest mongoNetTest = new MongoNetTest(stringArray);
            mongoNetTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void freeTest() {
        this.mongoNetDDList = new ArrayList();
    }
}

