/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MongoLockTest
extends MongoDbBaseTest {
    private Hashtable prevLockHash = new Hashtable();
    private boolean isFirstTime = true;
    private double versionNumber = 1.0;
    private String engineType = "";
    private boolean isMMAPEngineType = true;

    public MongoLockTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        try {
            Object object;
            this.collectMetrics();
            Hashtable hashtable3 = this.getData();
            if (hashtable3 == null || hashtable3.size() == 0) {
                return;
            }
            if (this.isFirstTime) {
                if (hashtable3.containsKey("version")) {
                    object = "";
                    object = (String)hashtable3.get("version");
                    this.engineType = (String)hashtable3.get("storageEngine");
                    if (object != null && ((String)object).length() > 0) {
                        object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                        try {
                            this.versionNumber = Double.parseDouble((String)object);
                        }
                        catch (Exception exception) {
                            this.isFirstTime = true;
                            return;
                        }
                    }
                } else {
                    this.isFirstTime = true;
                    return;
                }
                this.isFirstTime = false;
            }
            if (this.versionNumber >= 3.2 && !this.engineType.equalsIgnoreCase("MMAPv1")) {
                this.isMMAPEngineType = false;
            }
            if ((object = (Hashtable)hashtable3.get("locks")) != null && ((Hashtable)object).size() > 0) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                hashtable2 = this.getInfoList();
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    object5 = (String)enumeration.nextElement();
                    object4 = new StringTokenizer((String)object5, ":");
                    while (((StringTokenizer)object4).hasMoreTokens()) {
                        object3 = ((StringTokenizer)object4).nextToken();
                        object2 = ((StringTokenizer)object4).nextToken();
                        String string = ((StringTokenizer)object4).nextToken();
                        if ((object2 = this.getMode((String)object2)) == null || ((String)object2).length() == 0) continue;
                        String string2 = (String)object2 + ":" + string;
                        String string3 = (String)((Hashtable)object).get(object5);
                        double d = -5.0;
                        try {
                            d = Double.parseDouble(string3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (hashtable2 == null || hashtable2.size() <= 0 || !hashtable2.containsKey(string2)) continue;
                        ArrayList arrayList = (ArrayList)hashtable2.get(string2);
                        if (((String)object3).equalsIgnoreCase("acquireCount")) {
                            arrayList.set(0, new Double(d));
                        } else if (((String)object3).equalsIgnoreCase("acquireWaitCount")) {
                            arrayList.set(1, new Double(d));
                        } else if (((String)object3).equalsIgnoreCase("timeAcquiringMicros")) {
                            if (d > 0.0) {
                                d /= 1000000.0;
                            }
                            arrayList.set(2, new Double(d));
                        }
                        hashtable2.put(string2, arrayList);
                    }
                }
                if (hashtable2 != null && hashtable2.size() > 0) {
                    object5 = hashtable2.keys();
                    if (this.prevLockHash != null && this.prevLockHash.size() > 0) {
                        while (object5.hasMoreElements()) {
                            object4 = (String)object5.nextElement();
                            object3 = (ArrayList)hashtable2.get(object4);
                            object2 = (ArrayList)this.prevLockHash.get(object4);
                            if (object2 == null || ((ArrayList)object2).size() == 0) continue;
                            double d = (Double)((ArrayList)object3).get(0);
                            double d2 = (Double)((ArrayList)object3).get(1);
                            double d3 = (Double)((ArrayList)object3).get(2);
                            double d4 = (Double)((ArrayList)object2).get(0);
                            double d5 = (Double)((ArrayList)object2).get(1);
                            double d6 = (Double)((ArrayList)object2).get(2);
                            double d7 = 0.0;
                            double d8 = 0.0;
                            double d9 = 0.0;
                            double d10 = 0.0;
                            d7 = this.getDiff(d, d4);
                            d8 = this.getDiff(d2, d5);
                            d9 = this.getDiff(d3, d6);
                            if (d9 > 0.0) {
                                d10 = d9 / d8;
                            }
                            ArrayList<Double> arrayList = new ArrayList<Double>();
                            arrayList.add(new Double(d7));
                            arrayList.add(new Double(d8));
                            arrayList.add(new Double(d9));
                            arrayList.add(new Double(d10));
                            this.addNewMeasure((String)object4, arrayList);
                        }
                    } else {
                        object4 = new ArrayList();
                        ((ArrayList)object4).add(new Double(-5.0));
                        ((ArrayList)object4).add(new Double(-5.0));
                        ((ArrayList)object4).add(new Double(-5.0));
                        ((ArrayList)object4).add(new Double(-5.0));
                        this.addNewMeasure((ArrayList)object4);
                    }
                }
            }
            this.prevLockHash = (Hashtable)hashtable2.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getMode(String string) {
        String string2 = "";
        if (string.equals("R")) {
            string2 = "SHARED LOCK";
        } else if (string.equals("W")) {
            string2 = "EXCLUSIVE LOCK";
        } else if (string.equals("r")) {
            string2 = "INTENT SHARED LOCK";
        } else if (string.equals("w")) {
            string2 = "INTENT EXCLUSIVE LOCK";
        }
        return string2;
    }

    private Hashtable getInfoList() {
        Hashtable hashtable = new Hashtable();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add("SHARED LOCK");
        arrayList.add("EXCLUSIVE LOCK");
        arrayList.add("INTENT SHARED LOCK");
        arrayList.add("INTENT EXCLUSIVE LOCK");
        arrayList2.add("Global");
        arrayList2.add("Database");
        arrayList2.add("Collection");
        arrayList2.add("Metadata");
        arrayList2.add("oplog");
        if (this.isMMAPEngineType) {
            arrayList2.add("MMAPV1Journal");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                String string2 = (String)arrayList2.get(j);
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                arrayList3.add(new Double(0.0));
                arrayList3.add(new Double(0.0));
                arrayList3.add(new Double(0.0));
                String string3 = string + ":" + string2;
                hashtable.put(string3, arrayList3);
            }
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d2 >= 0.0 && d >= d2) {
            d3 = d - d2;
            if (this.timeSinceLastTest > 0.0) {
                d3 /= this.timeSinceLastTest;
            }
            if (d3 < 0.0) {
                d3 = -5.0;
            }
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        MongoLockTest mongoLockTest = new MongoLockTest(stringArray);
        mongoLockTest.computeMeasures(new Hashtable());
    }
}

