/*
 * Decompiled with CFR 0.152.
 */
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class MongoDbBaseTest
extends GenericTest {
    public static Hashtable metricHash = new Hashtable();
    private static Hashtable lastTimeHash = new Hashtable();
    private ArrayList measureList = new ArrayList();
    private Hashtable serverHash = new Hashtable();
    private Hashtable topMongoOperationHash = new Hashtable();
    private long lastTime = 0L;
    private static final Object sync = new Object();
    private Hashtable mongoLockHash = new Hashtable();
    private static HashMap syncHash = new HashMap();
    String dbName = this.getValueForParam("Database_name");
    int portNumber = 27017;
    String userName = this.getValueForParam("username");
    String passWord = this.getValueForParam("password");
    String authMechanism = "";
    String caFile = "";
    String certKeyFile = "";
    String ssl = "";
    boolean isMongoSSLEnabled = false;

    public MongoDbBaseTest(String[] stringArray) {
        super(stringArray);
        if (this.dbName == null || this.dbName.trim().length() == 0 || this.dbName.equalsIgnoreCase("NULL") || this.dbName.equalsIgnoreCase("none")) {
            this.dbName = "admin";
        }
        if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.passWord == null || this.passWord.trim().length() == 0 || this.passWord.equalsIgnoreCase("NULL") || this.passWord.equalsIgnoreCase("none")) {
            this.passWord = "";
        }
        try {
            this.portNumber = Integer.parseInt(this.portNo);
        }
        catch (Exception exception) {
            this.logToErrorFile("WARN : ", "MongoDbBaseTest ", " Port Number is null or empty. So assiging 27017 (default port) for targetHost : " + this.targetHost);
        }
        this.authMechanism = this.getValueForParam("Authentication_mechanism");
        if (this.authMechanism == null || this.authMechanism.trim().length() == 0 || this.authMechanism.equalsIgnoreCase("NULL") || this.authMechanism.equalsIgnoreCase("none")) {
            this.authMechanism = "NONE";
        }
        this.ssl = this.getValueForParam("ssl");
        if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
            this.isMongoSSLEnabled = true;
            this.caFile = this.getValueForParam("ca_file");
            this.certKeyFile = this.getValueForParam("certificate_key_file");
            if (this.caFile == null || this.caFile.trim().length() == 0 || this.caFile.equalsIgnoreCase("NULL") || this.caFile.equalsIgnoreCase("none")) {
                this.caFile = "";
                this.logToErrorFile("WARN : ", "MongoDbBaseTest ", " CA file is null or empty.  for targetHost : " + this.targetHost);
            }
            if (this.certKeyFile == null || this.certKeyFile.trim().length() == 0 || this.certKeyFile.equalsIgnoreCase("NULL") || this.certKeyFile.equalsIgnoreCase("none")) {
                this.logToErrorFile("WARN : ", "MongoDbBaseTest ", " Certificate key file  is null or empty.  for targetHost : " + this.targetHost);
                this.certKeyFile = "";
            }
        }
        this.setLastExectionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectMetrics() {
        Object object;
        String string = "";
        String string2 = this.reportingName + ":" + this.targetHost + ":" + this.portNo;
        string = (String)syncHash.get(string2);
        if (string == null || string.trim().length() == 0) {
            object = sync;
            synchronized (object) {
                string = (String)syncHash.get(string2);
                if (string == null || string.trim().length() == 0) {
                    string = new String(string2);
                    syncHash.put(string2, string2);
                }
            }
        }
        object = string;
        synchronized (object) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            long l3 = (long)(0.9 * (double)this.measurePeriod);
            boolean bl = false;
            if (l2 >= l3) {
                bl = true;
                this.lastTime = l;
                this.setLastExectionTime();
            } else {
                bl = false;
            }
            if (bl) {
                this.clearObjects();
                this.execute();
                this.lastTime = System.currentTimeMillis();
                this.setLastExectionTime();
            }
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName + ":" + this.targetHost + ":" + this.portNo, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
        this.lastTime = l;
    }

    private void clearObjects() {
        if (this.serverHash != null) {
            this.serverHash.clear();
        }
        if (this.topMongoOperationHash != null) {
            this.topMongoOperationHash.clear();
        }
        if (!this.serverHash.isEmpty()) {
            this.serverHash = new Hashtable();
        }
        if (!this.topMongoOperationHash.isEmpty()) {
            this.topMongoOperationHash = new Hashtable();
        }
        if (this.mongoLockHash != null) {
            this.mongoLockHash.clear();
        }
        if (!this.mongoLockHash.isEmpty()) {
            this.mongoLockHash = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Hashtable<Object, ArrayList> hashtable = new Hashtable<Object, ArrayList>();
        Hashtable<Object, ArrayList> hashtable2 = new Hashtable<Object, ArrayList>();
        MongoClient mongoClient = null;
        DB dB = null;
        try {
            block50: {
                Object object;
                Object object2;
                try {
                    SSLContext sSLContext;
                    System.out.println(this.entity + " authMechanism::" + this.authMechanism);
                    if (this.authMechanism.equalsIgnoreCase("NONE")) {
                        object2 = MongoCredential.createCredential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                        if (this.isMongoSSLEnabled) {
                            sSLContext = this.createSSLContext(this.caFile, this.certKeyFile);
                            object = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)sSLContext.getSocketFactory()).build();
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            }, (MongoClientOptions)object);
                        } else {
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            });
                        }
                    } else if (this.authMechanism.equalsIgnoreCase("SCRAM-SHA-1")) {
                        object2 = MongoCredential.createScramSha1Credential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                        if (this.isMongoSSLEnabled) {
                            sSLContext = this.createSSLContext(this.caFile, this.certKeyFile);
                            object = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)sSLContext.getSocketFactory()).build();
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            }, (MongoClientOptions)object);
                        } else {
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            });
                        }
                    } else if (this.authMechanism.equalsIgnoreCase("PLAIN")) {
                        this.dbName = "$external";
                        object2 = MongoCredential.createPlainCredential((String)this.userName, (String)this.dbName, (char[])this.passWord.toCharArray());
                        if (this.isMongoSSLEnabled) {
                            sSLContext = this.createSSLContext(this.caFile, this.certKeyFile);
                            object = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)sSLContext.getSocketFactory()).build();
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            }, (MongoClientOptions)object);
                        } else {
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            });
                        }
                        this.dbName = "admin";
                    } else if (this.authMechanism.equalsIgnoreCase("GSSAPI")) {
                        object2 = MongoCredential.createGSSAPICredential((String)this.userName);
                        if (this.isMongoSSLEnabled) {
                            sSLContext = this.createSSLContext(this.caFile, this.certKeyFile);
                            object = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)sSLContext.getSocketFactory()).build();
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            }, (MongoClientOptions)object);
                        } else {
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            });
                        }
                    } else if (this.authMechanism.equalsIgnoreCase("MONGODB-X509")) {
                        object2 = MongoCredential.createMongoX509Credential((String)this.userName);
                        if (this.isMongoSSLEnabled) {
                            sSLContext = this.createSSLContext(this.caFile, this.certKeyFile);
                            object = MongoClientOptions.builder().sslEnabled(true).sslInvalidHostNameAllowed(true).socketFactory((SocketFactory)sSLContext.getSocketFactory()).build();
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            }, (MongoClientOptions)object);
                        } else {
                            mongoClient = new MongoClient(new ServerAddress(this.targetHost, this.portNumber), (List)new ArrayList<MongoCredential>((MongoCredential)object2){
                                final /* synthetic */ MongoCredential val$credential;
                                {
                                    this.val$credential = mongoCredential;
                                    this.add(this.val$credential);
                                }
                            });
                        }
                    }
                    dB = mongoClient.getDB(this.dbName);
                }
                catch (Exception exception) {
                    metricHash.put(this.reportingName + ":" + this.targetHost + ":" + this.portNo, new Hashtable());
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Could not connect to the database server for targetHost=" + this.targetHost + "  Exception is :", exception.toString());
                    exception.printStackTrace();
                    if (dB != null) {
                        dB = null;
                    }
                    if (mongoClient != null) {
                        mongoClient.close();
                    }
                    if (mongoClient != null) {
                        mongoClient.close();
                    }
                    return;
                }
                try {
                    this.getServerStats(dB);
                }
                catch (Throwable throwable) {
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting server statistics for targetHost :" + this.targetHost + " Exception is : ", throwable.toString());
                    System.out.println("ERROR : MongoDbBaseTest Exception while getting server statistics for targetHost :" + this.targetHost + " Exception is :" + throwable.toString());
                    throwable.printStackTrace();
                }
                try {
                    this.getHostInfo(dB);
                }
                catch (Throwable throwable) {
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting HOSTINFO for targetHost :" + this.targetHost + " Exception is : ", throwable.toString());
                    System.out.println("ERROR : MongoDbBaseTest Exception while getting HOSTINFO for targetHost :" + this.targetHost + " Exception is :" + throwable.toString());
                    throwable.printStackTrace();
                }
                try {
                    this.getLogInfo(dB);
                }
                catch (Throwable throwable) {
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting LOGINFO for targetHost :" + this.targetHost + " Exception is : ", throwable.toString());
                    System.out.println("ERROR : MongoDbBaseTest Exception while getting LOGINFO for targetHost :" + this.targetHost + " Exception is :" + throwable.toString());
                    throwable.printStackTrace();
                }
                try {
                    this.topMongoOperations(dB);
                }
                catch (Throwable throwable) {
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting top mongo operations for targetHost :" + this.targetHost + " Exception is : ", throwable.toString());
                    System.out.println("ERROR : MongoDbBaseTest Exception while getting top mongo operations for targetHost :" + this.targetHost + " Exception is :" + throwable.toString());
                    throwable.printStackTrace();
                }
                try {
                    object2 = mongoClient.getDatabaseNames();
                    if (object2 == null || object2.size() <= 0) break block50;
                    for (int i = 0; i < object2.size(); ++i) {
                        ArrayList arrayList;
                        object = (String)object2.get(i);
                        if (object == null || ((String)object).length() == 0) continue;
                        dB = mongoClient.getDB((String)object);
                        try {
                            arrayList = this.getDbSpaceDetails(dB);
                            hashtable.put(object, arrayList);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile("ERROR :", "MongoDbBaseTest Exception while getting DB space details for the Database :" + (String)object + " at targetHost :" + this.targetHost + " Exception is :", exception.toString());
                            System.out.println("ERROR : MongoDbBaseTest Exception while getting DB space details for the Database :" + (String)object + " at targetHost :" + this.targetHost + " Exception is :" + exception.toString());
                            exception.printStackTrace();
                        }
                        try {
                            arrayList = this.getDbCollectionStats(dB);
                            if (arrayList == null || arrayList.size() <= 0) continue;
                            hashtable2.put(object, arrayList);
                            continue;
                        }
                        catch (Exception exception) {
                            this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting collection statistics for the Database :" + (String)object + " at targetHost :" + this.targetHost + " Exception is : ", exception.toString());
                            System.out.println("ERROR : MongoDbBaseTest Exception while getting collection statistics for the Database :" + (String)object + " at targetHost :" + this.targetHost + " Exception is : " + exception.toString());
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            if (dB != null) {
                                dB = null;
                            }
                        }
                    }
                    this.serverHash.put("DbSpace", hashtable);
                    this.serverHash.put("Collections", hashtable2);
                }
                catch (Exception exception) {
                    this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting and iterating database :" + this.dbName + " at targetHost :" + this.targetHost + " Exception is : ", exception.toString());
                    System.out.println("ERROR : MongoDbBaseTest Exception while getting and iterating database :" + this.dbName + " at targetHost :" + this.targetHost + " Exception is : " + exception.toString());
                    exception.printStackTrace();
                }
            }
            System.out.println(" OUTPUT : MongoDbBaseTest reportingName::" + this.reportingName + "  serverHash::" + this.serverHash);
            System.out.println(" OUTPUT : MongoDbBaseTest reportingName::" + this.reportingName + "  metricHash::" + metricHash);
            metricHash.put(this.reportingName + ":" + this.targetHost + ":" + this.portNo, this.serverHash);
            System.out.println(" OUTPUT : MongoDbBaseTest reportingName::" + this.reportingName + "  metricHash::" + metricHash);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (mongoClient != null) {
                mongoClient.close();
            }
        }
    }

    private void topMongoOperations(DB dB) {
        try {
            CommandResult commandResult = dB.command("top");
            Set set = commandResult.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                if (string != null && string.equalsIgnoreCase("serverUsed") || string.equalsIgnoreCase("ok")) continue;
                Object v = entry.getValue();
                if (string == null || v == null) continue;
                this.getMongoTopOperation(string, v);
            }
            commandResult.clear();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting top mongo operations for targetHost :" + this.targetHost + " Exception is : ", exception.toString());
            System.out.println("ERROR : MongoDbBaseTest Exception while getting top mongo operations for targetHost :" + this.targetHost + " Exception is :" + exception.toString());
            exception.printStackTrace();
        }
    }

    public void getMongoTopOperation(String string, Object object) {
        try {
            Object v;
            String string2;
            boolean bl = true;
            String string3 = "";
            Hashtable hashtable = new Hashtable();
            BasicDBObject basicDBObject = (BasicDBObject)object;
            Set set = basicDBObject.entrySet();
            for (Object object2 : set) {
                string2 = (String)object2.getKey();
                v = object2.getValue();
                if (string2 != null && string2.equalsIgnoreCase("note")) continue;
                if (bl) {
                    string3 = string2;
                }
                bl = false;
                if (string2 != null && string2.indexOf(string3) >= 0) {
                    hashtable.put(string2, v);
                    continue;
                }
                hashtable.put(string2, v);
                string3 = string2;
            }
            if (hashtable != null && hashtable.size() > 0) {
                Object object2;
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    v = hashtable.get(string2);
                    this.parseEntrySetValue(string2, v);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList getDbCollectionStats(DB dB) {
        ArrayList arrayList;
        block6: {
            arrayList = new ArrayList();
            try {
                Set set = dB.getCollectionNames();
                System.out.println("collectionNames" + set + " ::" + this.reportingName);
                if (set == null || set.size() <= 0) break block6;
                for (String string : set) {
                    if (string.equalsIgnoreCase("me")) continue;
                    DBCollection dBCollection = dB.getCollection(string);
                    CommandResult commandResult = dBCollection.getStats();
                    this.measureList = new ArrayList();
                    Set set2 = commandResult.entrySet();
                    for (Map.Entry entry : set2) {
                        String string2 = (String)entry.getKey();
                        String string3 = "-5";
                        try {
                            string3 = entry.getValue().toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string2 != null && string2.equalsIgnoreCase("count") && string3.equalsIgnoreCase("0")) break;
                        if (!(string2 != null && string2.equalsIgnoreCase("ns") || string2 != null && string2.equalsIgnoreCase("size") || string2.equalsIgnoreCase("count") || string2.equalsIgnoreCase("storageSize") || string2.equalsIgnoreCase("totalIndexSize") || string2.equalsIgnoreCase("nindexes") || string2.equalsIgnoreCase("lastExtentSize")) && !string2.equalsIgnoreCase("avgObjSize")) continue;
                        this.measureList.add(new String(string3));
                    }
                    if (this.measureList == null || this.measureList.size() != 8 && this.measureList.size() != 7) continue;
                    arrayList.add(new ArrayList(this.measureList));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    private ArrayList getDbSpaceDetails(DB dB) {
        try {
            this.measureList = new ArrayList();
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            this.measureList.add(new Double(-5.0));
            CommandResult commandResult = dB.command("dbStats");
            Set set = commandResult.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                String string2 = entry.getValue().toString();
                double d = -5.0;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null) continue;
                if (string.equalsIgnoreCase("avgObjSize")) {
                    this.measureList.set(0, d);
                    continue;
                }
                if (string.equalsIgnoreCase("dataSize")) {
                    this.measureList.set(1, d);
                    continue;
                }
                if (string.equalsIgnoreCase("storageSize")) {
                    this.measureList.set(2, d);
                    continue;
                }
                if (string.equalsIgnoreCase("numExtents")) {
                    this.measureList.set(3, d);
                    continue;
                }
                if (string.equalsIgnoreCase("indexes")) {
                    this.measureList.set(4, d);
                    continue;
                }
                if (string.equalsIgnoreCase("indexSize")) {
                    this.measureList.set(5, d);
                    continue;
                }
                if (string.equalsIgnoreCase("fileSize")) {
                    this.measureList.set(6, d);
                    continue;
                }
                if (string.equalsIgnoreCase("nsSizeMB")) {
                    this.measureList.set(7, d);
                    continue;
                }
                if (string.equalsIgnoreCase("ok")) {
                    this.measureList.set(8, d);
                    continue;
                }
                if (string.equalsIgnoreCase("fsUsedSize")) {
                    this.measureList.set(9, d);
                    continue;
                }
                if (!string.equalsIgnoreCase("fsTotalSize")) continue;
                this.measureList.set(10, d);
            }
            commandResult.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.measureList;
    }

    private void getServerStats(DB dB) {
        try {
            CommandResult commandResult = dB.command("serverStatus");
            Set set = commandResult.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string != null && (string.equalsIgnoreCase("uptime") || string.equalsIgnoreCase("version"))) {
                    v.toString();
                    this.serverHash.put(string, v);
                }
                if (string == null || v == null) continue;
                this.getServerMeasures(string, v);
            }
            commandResult.clear();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting server statistics for targetHost :" + this.targetHost + " Exception is : ", exception.toString());
            System.out.println("ERROR : MongoDbBaseTest Exception while getting server statistics for targetHost :" + this.targetHost + " Exception is :" + exception.toString());
            exception.printStackTrace();
        }
    }

    private void getHostInfo(DB dB) {
        try {
            CommandResult commandResult = dB.command("hostInfo");
            Set set = commandResult.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string == null || v == null) continue;
                this.getServerMeasures(string, v);
            }
            commandResult.clear();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting HOSTINFO for targetHost :" + this.targetHost + " Exception is : ", exception.toString());
            System.out.println("ERROR : MongoDbBaseTest Exception while getting HOSTINFO for targetHost :" + this.targetHost + " Exception is :" + exception.toString());
            exception.printStackTrace();
        }
    }

    private void getLogInfo(DB dB) {
        try {
            CommandResult commandResult = dB.command("getCmdLineOpts");
            Set set = commandResult.entrySet();
            for (Map.Entry entry : set) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (string == null || v == null || !string.equalsIgnoreCase("parsed")) continue;
                this.parseEntrySetValue(string, v);
            }
            commandResult.clear();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR : ", "MongoDbBaseTest Exception while getting LOGINFO for targetHost :" + this.targetHost + " Exception is : ", exception.toString());
            System.out.println("ERROR : MongoDbBaseTest Exception while getting LOGINFO for targetHost :" + this.targetHost + " Exception is :" + exception.toString());
            exception.printStackTrace();
        }
    }

    public void getServerMeasures(String string, Object object) {
        try {
            if (string != null && string.equalsIgnoreCase("asserts") || string.equalsIgnoreCase("connections") || string.equalsIgnoreCase("cursors") || string.equalsIgnoreCase("indexCounters") || string.equalsIgnoreCase("network") || string.equalsIgnoreCase("opcounters") || string.equalsIgnoreCase("opcountersRepl") || string.equalsIgnoreCase("mem") || string.equalsIgnoreCase("backgroundFlushing") || string.equalsIgnoreCase("dur") || string.equalsIgnoreCase("extra_info") || string.equalsIgnoreCase("storageEngine") || string.equalsIgnoreCase("extra")) {
                this.getEntrySetValues(string, object);
            } else if (string != null && (string.equalsIgnoreCase("globalLock") || string.equalsIgnoreCase("metrics") || string.equalsIgnoreCase("wiredTiger") || string.equalsIgnoreCase("locks"))) {
                this.parseEntrySetValue(string, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void parseEntrySetValue(String string, Object object) {
        try {
            this.measureList = new ArrayList();
            BasicDBObject basicDBObject = (BasicDBObject)object;
            Set set = basicDBObject.entrySet();
            for (Map.Entry entry : set) {
                String string2 = (String)entry.getKey();
                Object v = entry.getValue();
                if (string2 != null && string2.equalsIgnoreCase("totalTime") || string2.equalsIgnoreCase("lockTime")) continue;
                if (string2 != null && string2.equalsIgnoreCase("currentQueue") || string2.equalsIgnoreCase("activeClients") || string2.equalsIgnoreCase("cursor") || string2.equalsIgnoreCase("cache") || string2.equalsIgnoreCase("transaction") || string2.equalsIgnoreCase("concurrentTransactions") || string2.equalsIgnoreCase("systemLog") || string2.equalsIgnoreCase("thread-state") || string2.equalsIgnoreCase("thread-yield") || string2.equalsIgnoreCase("session")) {
                    this.getEntrySetValues(string2, v);
                }
                if (string2 != null && string2.equalsIgnoreCase("total") || string2.equalsIgnoreCase("readLock") || string2.equalsIgnoreCase("writeLock") || string2.equalsIgnoreCase("queries") || string2.equalsIgnoreCase("getmore") || string2.equalsIgnoreCase("insert") || string2.equalsIgnoreCase("update") || string2.equalsIgnoreCase("remove") || string2.equalsIgnoreCase("commands")) {
                    this.getEntrySetValues(string, string2, v);
                }
                if ((string2 == null || !string2.equalsIgnoreCase("Global")) && !string2.equalsIgnoreCase("MMAPV1Journal") && !string2.equalsIgnoreCase("Database") && !string2.equalsIgnoreCase("Collection") && !string2.equalsIgnoreCase("Metadata") && !string2.equalsIgnoreCase("oplog") || string.equalsIgnoreCase("WiredTiger")) continue;
                this.getLockEntrySetValues(string, string2, v);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getEntrySetValues(String string, Object object) {
        try {
            BasicDBObject basicDBObject = (BasicDBObject)object;
            Set set = basicDBObject.entrySet();
            Iterator iterator = set.iterator();
            this.measureList = new ArrayList();
            if (string != null && string.equalsIgnoreCase("cache")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("transaction")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("asserts")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("network")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("connections")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("cursor")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("currentQueue")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("opcounters")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("activeClients")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("concurrentTransactions")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("mem")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("extra_info")) {
                this.measureList.add("-5");
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("opcountersRepl")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("thread-state")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("thread-yield")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
            } else if (string != null && string.equalsIgnoreCase("session")) {
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
                this.measureList.add(-5);
            }
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getKey();
                Object object2 = entry.getValue();
                if (string2 != null && string2.equalsIgnoreCase("timeMs") || string2.equalsIgnoreCase("open") || string2.equalsIgnoreCase("read") || string2.equalsIgnoreCase("write")) {
                    BasicDBObject basicDBObject2 = (BasicDBObject)object2;
                    Set set2 = basicDBObject2.entrySet();
                    for (Map.Entry entry2 : set2) {
                        String string3 = (String)entry2.getKey();
                        String string4 = entry2.getValue().toString();
                        if (string2.equalsIgnoreCase("open")) {
                            if (string3 == null) continue;
                            if (string3.equalsIgnoreCase("noTimeout")) {
                                this.measureList.set(1, string4);
                                continue;
                            }
                            if (!string3.equalsIgnoreCase("total")) continue;
                            this.measureList.set(2, string4);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("write")) {
                            if (string3 == null) continue;
                            if (string3.equalsIgnoreCase("out")) {
                                this.measureList.set(0, string4);
                                continue;
                            }
                            if (string3.equalsIgnoreCase("available")) {
                                this.measureList.set(1, string4);
                                continue;
                            }
                            if (!string3.equalsIgnoreCase("totaltickets")) continue;
                            this.measureList.set(2, string4);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("read")) {
                            if (string3 == null) continue;
                            if (string3.equalsIgnoreCase("out")) {
                                this.measureList.set(3, string4);
                                continue;
                            }
                            if (string3.equalsIgnoreCase("available")) {
                                this.measureList.set(4, string4);
                                continue;
                            }
                            if (!string3.equalsIgnoreCase("totaltickets")) continue;
                            this.measureList.set(5, string4);
                            continue;
                        }
                        this.measureList.add(string4);
                    }
                    continue;
                }
                if (object2 == null) continue;
                object2 = object2.toString();
                if (string.equalsIgnoreCase("storageEngine")) {
                    this.serverHash.put(string, object2);
                    return;
                }
                if (string.equalsIgnoreCase("extra")) {
                    this.serverHash.put(string2, object2);
                    return;
                }
                if (string.equalsIgnoreCase("systemlog") && string2.equalsIgnoreCase("path")) {
                    this.serverHash.put(string2, object2);
                    return;
                }
                if (string.equalsIgnoreCase("transaction")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("transaction begins")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("transaction checkpoint max time (msecs)")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("transaction checkpoint min time (msecs)")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("transaction checkpoint most recent time (msecs)")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("transactions committed")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("transactions rolled back")) continue;
                    this.measureList.set(5, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("cache")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("bytes currently in the cache")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("maximum bytes configured")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("modified pages evicted")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("pages read into cache")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("pages written from cache")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("tracked dirty bytes in the cache")) {
                        this.measureList.set(5, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("tracked dirty pages in the cache")) {
                        this.measureList.set(6, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("unmodified pages evicted")) {
                        this.measureList.set(7, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("application threads page read from disk to cache count")) {
                        this.measureList.set(8, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("application threads page read from disk to cache time (usecs)")) {
                        this.measureList.set(9, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("application threads page write from cache to disk count")) {
                        this.measureList.set(10, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("application threads page write from cache to disk time (usecs)")) continue;
                    this.measureList.set(11, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("asserts")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("regular")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("warning")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("msg")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("user")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("rollovers")) continue;
                    this.measureList.set(4, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("network")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("bytesIn")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("bytesOut")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("numRequests")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("numSlowDNSOperations")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("numSlowSSLOperations")) continue;
                    this.measureList.set(4, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("connections")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("current")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("available")) continue;
                    this.measureList.set(1, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("cursor")) {
                    if (string2 == null || !string2.equalsIgnoreCase("timedOut")) continue;
                    this.measureList.set(0, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("currentQueue")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("total")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("readers")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("writers")) continue;
                    this.measureList.set(2, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("opcounters")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("insert")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("query")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("update")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("delete")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("getmore")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("command")) continue;
                    this.measureList.set(5, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("activeClients")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("total")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("readers")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("writers")) continue;
                    this.measureList.set(2, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("mem")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("bits")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("resident")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("virtual")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("supported")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("mapped")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("mappedWithJournal")) continue;
                    this.measureList.set(5, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("extra_info")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("heap_usage_bytes")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("page_faults")) continue;
                    this.measureList.set(1, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("opcountersRepl")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("insert")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("query")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("update")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("delete")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("getmore")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("command")) continue;
                    this.measureList.set(5, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("thread-state")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("active filesystem fsync calls")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("active filesystem read calls")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("active filesystem write calls")) continue;
                    this.measureList.set(2, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("thread-yield")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("application thread time evicting (usecs)")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("application thread time waiting for cache (usecs)")) continue;
                    this.measureList.set(1, object2);
                    continue;
                }
                if (string.equalsIgnoreCase("session")) {
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase("table alter failed calls")) {
                        this.measureList.set(0, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table alter successful calls")) {
                        this.measureList.set(1, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table alter unchanged and skipped")) {
                        this.measureList.set(2, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table compact failed calls")) {
                        this.measureList.set(3, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table compact successful calls")) {
                        this.measureList.set(4, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table create failed calls")) {
                        this.measureList.set(5, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table create successful calls")) {
                        this.measureList.set(6, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table drop failed calls")) {
                        this.measureList.set(7, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table drop successful calls")) {
                        this.measureList.set(8, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table rename failed calls")) {
                        this.measureList.set(9, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table rename successful calls")) {
                        this.measureList.set(10, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table salvage failed calls")) {
                        this.measureList.set(11, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table salvage successful calls")) {
                        this.measureList.set(12, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table truncate failed calls")) {
                        this.measureList.set(13, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table truncate successful calls")) {
                        this.measureList.set(14, object2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("table verify failed calls")) {
                        this.measureList.set(15, object2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("table verify successful calls")) continue;
                    this.measureList.set(16, object2);
                    continue;
                }
                this.measureList.add(object2);
            }
            this.serverHash.put(string, this.measureList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getLockEntrySetValues(String string, String string2, Object object) {
        try {
            BasicDBObject basicDBObject = (BasicDBObject)object;
            Set set = basicDBObject.entrySet();
            Hashtable hashtable = new Hashtable();
            for (Map.Entry entry : set) {
                String string3 = (String)entry.getKey();
                Object v = entry.getValue();
                BasicDBObject basicDBObject2 = (BasicDBObject)v;
                Set set2 = basicDBObject2.entrySet();
                Hashtable hashtable2 = new Hashtable();
                for (Map.Entry entry2 : set2) {
                    String string4 = (String)entry2.getKey();
                    String string5 = entry2.getValue().toString();
                    if (string5 == null) continue;
                    this.mongoLockHash.put(string3 + ":" + string4 + ":" + string2, string5);
                }
            }
            this.serverHash.put(string, this.mongoLockHash);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getEntrySetValues(String string, String string2, Object object) {
        try {
            BasicDBObject basicDBObject = (BasicDBObject)object;
            Set set = basicDBObject.entrySet();
            for (Map.Entry entry : set) {
                String string3 = (String)entry.getKey();
                String string4 = entry.getValue().toString();
                if (string4 == null) continue;
                this.measureList.add(string4);
            }
            this.topMongoOperationHash.put(string, this.measureList);
            this.serverHash.put("Top", this.topMongoOperationHash);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String dateFormat(String string) {
        String string2 = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getData() {
        Object object = sync;
        synchronized (object) {
            return (Hashtable)metricHash.get(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    protected SSLContext createSSLContext(String string, String string2) {
        KeyStore keyStore;
        Object object;
        Object object2;
        Object object3;
        TrustManagerFactory trustManagerFactory = null;
        try {
            object3 = new FileInputStream(string);
            object2 = CertificateFactory.getInstance("X.509");
            object = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object3);
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyStore.setCertificateEntry("caCert", (Certificate)object);
            trustManagerFactory.init(keyStore);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = null;
        try {
            object2 = new FileReader(string2);
            object = KeyStore.getInstance(KeyStore.getDefaultType());
            ((KeyStore)object).load(null);
            keyStore = new PEMParser((Reader)object2);
            PEMKeyPair pEMKeyPair = (PEMKeyPair)keyStore.readObject();
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pEMKeyPair);
            JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)keyStore.readObject();
            X509Certificate x509Certificate = jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
            ((KeyStore)object).setKeyEntry("alias", keyPair.getPrivate(), "".toCharArray(), new Certificate[]{x509Certificate});
            object3 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object3).init((KeyStore)object, "".toCharArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = null;
        try {
            object2 = SSLContext.getInstance("TLSv1.2");
            ((SSLContext)object2).init(((KeyManagerFactory)object3).getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        try {
            MongoDbBaseTest mongoDbBaseTest = new MongoDbBaseTest(stringArray);
            mongoDbBaseTest.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

