/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxDiscovery {
    private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    public boolean connectToJVM(String string, int n) {
        boolean bl = false;
        String string2 = string + ":" + n;
        String string3 = "jmxrmi";
        String string4 = "service:jmx:rmi:///jndi/rmi://" + string2 + "/" + string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string4);
            JMXConnector jMXConnector = JmxDiscovery.connectWithTimeout(jMXServiceURL, 1L, TimeUnit.SECONDS);
            MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            if (mBeanServerConnection != null) {
                bl = true;
                if (jMXConnector != null) {
                    jMXConnector.close();
                }
            }
        }
        catch (SecurityException securityException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXConnector connectWithTimeout(final JMXServiceURL jMXServiceURL, long l, TimeUnit timeUnit) throws IOException {
        final ArrayBlockingQueue<String> arrayBlockingQueue = new ArrayBlockingQueue<String>(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor(daemonThreadFactory);
        executorService.submit(new Runnable(){

            public void run() {
                try {
                    JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
                    if (!arrayBlockingQueue.offer(jMXConnector)) {
                        jMXConnector.close();
                    }
                }
                catch (Throwable throwable) {
                    arrayBlockingQueue.offer(throwable);
                }
            }
        });
        Object var6_5 = null;
        try {
            var6_5 = arrayBlockingQueue.poll(l, timeUnit);
            if (var6_5 == null && !arrayBlockingQueue.offer("")) {
                var6_5 = arrayBlockingQueue.take();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executorService.shutdown();
        }
        if (var6_5 == null) {
            throw new SocketTimeoutException("Connect timed out: " + jMXServiceURL);
        }
        if (var6_5 instanceof JMXConnector) {
            return var6_5;
        }
        try {
            throw (Throwable)var6_5;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    public static void main(String[] stringArray) {
        JmxDiscovery jmxDiscovery = new JmxDiscovery();
        long l = System.currentTimeMillis();
        boolean bl = jmxDiscovery.connectToJVM("192.168.8.27", 13600);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("check.... :" + bl + "    " + l3);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

