/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class JiraSprintTest
extends JiraBase {
    private boolean isFirst = true;
    private boolean isSsl = false;
    private boolean ssl_enabled = false;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    String user = "";
    String password = "";
    String urlString = "";
    String host = "";
    String targetHost = "";
    String portNo = "";
    String encodedAuth = "";
    public Hashtable ddCriticalIssue_ht = new Hashtable();
    public Hashtable ddToDO_ht = new Hashtable();
    public Hashtable prevhash = new Hashtable();
    public ArrayList prevList = new ArrayList();
    public ArrayList ddPrevList = new ArrayList();
    public Hashtable prevDDHash = new Hashtable();
    private final String DEFAULT_URI_SUFFIX = "";
    String synString = new String();
    String excludedProjects = "none";
    String excludedIssueTypes = "none";
    private String consoleURL = "";

    public JiraSprintTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isDynamicInfoTest = true;
        this.needAgentlessDD = true;
        try {
            this.user = this.getValueForParam("Username");
            this.password = this.getValueForParam("password");
            this.host = this.getValueForParam("host");
            this.targetHost = this.getValueForParam("trgtHost");
            this.portNo = this.getValueForParam("port");
            this.consoleURL = this.getValueForParam("console_URL");
            if (this.consoleURL == null || this.consoleURL.trim().equalsIgnoreCase("unconfigured") || this.consoleURL.trim().equalsIgnoreCase("none") || this.consoleURL.trim().equalsIgnoreCase("")) {
                this.logToErrorFile("Error", this.entity, "consoleURL is required");
            }
            String string = this.getValueForParam("ssl");
            this.encodedAuth = new String(Base64.encode((String)(this.user + ":" + this.password)));
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block10: {
            try {
                ArrayList<Double> arrayList = null;
                Hashtable hashtable2 = this.getJiraBoardNames();
                if (hashtable2 == null || hashtable2.size() <= 0) break block10;
                Set set = hashtable2.keySet();
                for (Long l : set) {
                    String string = (String)hashtable2.get(l);
                    Hashtable hashtable3 = this.getActiveSprintsForBoards(l);
                    Set set2 = hashtable3.keySet();
                    Iterator iterator = set2.iterator();
                    arrayList = new ArrayList<Double>();
                    while (iterator.hasNext()) {
                        Object object;
                        String string2;
                        Long l2 = (Long)iterator.next();
                        JSONObject jSONObject = (JSONObject)hashtable3.get(l2);
                        Long l3 = this.getIssuesForSprint(l, l2);
                        String string3 = (String)jSONObject.get((Object)"name");
                        ArrayList arrayList2 = this.getJqls(l2);
                        arrayList.add(new Double(l3.longValue()));
                        Iterator iterator2 = arrayList2.iterator();
                        int n = 0;
                        Long l4 = 0L;
                        while (iterator2.hasNext()) {
                            string2 = (String)iterator2.next();
                            object = new JSONObject();
                            object.put((Object)"jql", (Object)string2);
                            object.put((Object)"startAt", (Object)0);
                            object.put((Object)"maxResults", (Object)0);
                            String string4 = this.synString;
                            synchronized (string4) {
                                Long l5 = this.getTotalCountForMeasure((JSONObject)object);
                                arrayList.add(new Double(l5.longValue()));
                                if (n == 2) {
                                    l4 = l5;
                                }
                            }
                            ++n;
                        }
                        if (jSONObject != null) {
                            string2 = (String)jSONObject.get((Object)"startDate");
                            object = (String)jSONObject.get((Object)"endDate");
                            double d = this.getDaysRemaining((String)object);
                            double d2 = this.getSprintEstimationDays(string2, (String)object);
                            double d3 = this.getTimeElapsed(d2, d);
                            arrayList.add(new Double(d));
                            arrayList.add(new Double(d3));
                        }
                        double d = this.getWorkCompleted(new Double(l3.longValue()), l4);
                        arrayList.add(new Double(d));
                        this.addDDForToDO(string, string3, l2);
                        this.addDDForCriticalIssue(string, string3, l2);
                        this.addNewMeasure(string + ":" + string3, arrayList);
                    }
                }
            }
            catch (Throwable throwable) {
                this.logToErrorFile("Exception :", this.entity + " Exception occured in computeMeasures for " + this.targetHost, throwable.getMessage());
            }
        }
    }

    public Hashtable getJiraBoardNames() {
        String string = "/rest/agile/1.0/board?type=scrum";
        String string2 = "";
        Hashtable<Long, String> hashtable = null;
        try {
            string2 = this.consoleURL + string;
            Client client = Client.create();
            WebResource webResource = client.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string3 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string3 != null && !string3.equals("")) {
                    hashtable = new Hashtable<Long, String>();
                    JSONParser jSONParser = new JSONParser();
                    Object object = jSONParser.parse(string3.toString());
                    JSONObject jSONObject = (JSONObject)object;
                    JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"values");
                    for (JSONObject jSONObject2 : jSONArray) {
                        Long l = (Long)jSONObject2.get((Object)"id");
                        String string4 = (String)jSONObject2.get((Object)"name");
                        hashtable.put(l, string4);
                    }
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Failed to get board names... Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, "Failed to get board names. reqURL: " + string2 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Exception: Failed to get board names. reqURL: " + string2 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return hashtable;
    }

    public void addDDForToDO(String string, String string2, long l) {
        String string3 = "sprint = " + l + " AND status = \"To Do\"";
        ArrayList arrayList = this.getDDForMeasure(string3);
        if (this.ddToDO_ht != null) {
            this.ddToDO_ht.put(string + ":" + string2, arrayList);
        }
    }

    public void addDDForCriticalIssue(String string, String string2, long l) {
        String string3 = "sprint = " + l + " And resolution = Unresolved AND priority in (Highest, High)";
        ArrayList arrayList = this.getDDForMeasure(string3);
        if (this.ddCriticalIssue_ht != null) {
            this.ddCriticalIssue_ht.put(string + ":" + string2, arrayList);
        }
    }

    public ArrayList getJqls(Long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sprint = " + l + " AND status = \"To Do\"");
        arrayList.add("sprint = " + l + " AND status = \"In Progress\"");
        arrayList.add("sprint = " + l + " AND status = \"Done\"");
        arrayList.add("sprint = " + l + " And resolution = Unresolved AND priority in (Highest, High)");
        return arrayList;
    }

    public Long getTotalCountForMeasure(JSONObject jSONObject) {
        String string = "/rest/api/2/search";
        String string2 = "";
        Long l = 0L;
        try {
            String string3 = jSONObject.toString();
            string2 = this.consoleURL + string;
            Client client = Client.create();
            WebResource webResource = client.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)string3);
            int n = clientResponse.getStatus();
            String string4 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string4 != null && !string4.equals("")) {
                    JSONParser jSONParser = new JSONParser();
                    Object object = jSONParser.parse(string4.toString());
                    JSONObject jSONObject2 = (JSONObject)object;
                    Long l2 = (Long)jSONObject2.get((Object)"total");
                    if (l2 < 0L) {
                        l2 = -5L;
                    }
                    l = l2;
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Failed to get Total Count For Measure.. Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, "Failed to get Total Count For Measure. reqURL: " + string2 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Got exception in getTotalCountForMeasure method. reqURL: " + string2 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return l;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.254", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "eGfirewall"};
        JiraSprintTest jiraSprintTest = new JiraSprintTest(stringArray2);
        try {
            jiraSprintTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                System.out.println(" Timed out and hence going to kill the thread :" + System.currentTimeMillis());
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                System.out.println(" Timed out and killed the thread :" + System.currentTimeMillis());
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        System.out.println(" sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis());
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println("" + exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private Hashtable getActiveSprintsForBoards(Long l) {
        Hashtable hashtable = new Hashtable();
        String string = "/rest/agile/1.0/board/" + l + "/sprint?state=active";
        Hashtable hashtable2 = this.getActiveSprintPerBoard(string);
        return hashtable2;
    }

    private Hashtable getActiveSprintPerBoard(String string) {
        String string2 = "/rest/agile/1.0/board/1/sprint?state=active";
        String string3 = "";
        Hashtable<Long, JSONObject> hashtable = null;
        try {
            string3 = this.consoleURL + string;
            Client client = Client.create();
            WebResource webResource = client.resource(string3);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string4 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string4 != null && !string4.equals("")) {
                    hashtable = new Hashtable<Long, JSONObject>();
                    JSONParser jSONParser = new JSONParser();
                    Object object = jSONParser.parse(string4.toString());
                    JSONObject jSONObject = (JSONObject)object;
                    JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"values");
                    for (JSONObject jSONObject2 : jSONArray) {
                        Long l = (Long)jSONObject2.get((Object)"id");
                        String string5 = (String)jSONObject2.get((Object)"name");
                        String string6 = (String)jSONObject2.get((Object)"startDate");
                        String string7 = (String)jSONObject2.get((Object)"endDate");
                        hashtable.put(l, jSONObject2);
                    }
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Failed to  getActiveSprintPerBoard names... Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, "Failed to getActiveSprintPerBoard names... URL: " + this.url + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Got exception in getActiveSprintPerBoard method.");
            throwable.printStackTrace();
        }
        return hashtable;
    }

    public Long getIssuesForSprint(Long l, Long l2) {
        String string = "/rest/agile/1.0/board/" + l + "/sprint/" + l2 + "/issue";
        String string2 = "";
        ArrayList arrayList = null;
        Long l3 = -5L;
        try {
            string2 = this.consoleURL + string;
            Client client = Client.create();
            WebResource webResource = client.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string3 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string3 != null && !string3.equals("")) {
                    Long l4;
                    arrayList = new ArrayList();
                    JSONParser jSONParser = new JSONParser();
                    Object object = jSONParser.parse(string3.toString());
                    JSONObject jSONObject = (JSONObject)object;
                    l3 = l4 = (Long)jSONObject.get((Object)"total");
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Failed to get total Issues for Sprint... Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, "Failed to get total Issues for Sprint. reqURL: " + string2 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Exception: Failed to get total Issues for Sprint. reqURL: " + string2 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return l3;
    }

    public double getDaysRemaining(String string) throws ParseException {
        int n = 0;
        try {
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            simpleDateFormat.setTimeZone(timeZone);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTime(simpleDateFormat.parse(string));
            Date date = gregorianCalendar.getTime();
            Date date2 = new Date();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone);
            gregorianCalendar2.setTime(date2);
            Date date3 = gregorianCalendar2.getTime();
            long l = date.getTime() - date3.getTime();
            float f = l / 86400000L;
            if (f < 0.0f) {
                return 0.0;
            }
            do {
                gregorianCalendar2.add(5, 1);
                if (gregorianCalendar2.get(7) == 7 || gregorianCalendar2.get(7) == 1) continue;
                ++n;
            } while (gregorianCalendar2.getTimeInMillis() < gregorianCalendar.getTimeInMillis());
        }
        catch (ParseException parseException) {
            n = -5;
        }
        catch (Throwable throwable) {
            n = -5;
        }
        return n;
    }

    public double getSprintEstimationDays(String string, String string2) throws ParseException {
        int n = 0;
        try {
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            simpleDateFormat.setTimeZone(timeZone);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTime(simpleDateFormat.parse(string));
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone);
            gregorianCalendar2.setTime(simpleDateFormat.parse(string2));
            Date date = gregorianCalendar.getTime();
            Date date2 = gregorianCalendar2.getTime();
            if (date2.getTime() == date.getTime()) {
                return 0.0;
            }
            do {
                gregorianCalendar.add(5, 1);
                if (gregorianCalendar.get(7) == 7 || gregorianCalendar.get(7) == 1) continue;
                ++n;
            } while (gregorianCalendar.getTimeInMillis() < gregorianCalendar2.getTimeInMillis());
        }
        catch (ParseException parseException) {
            n = -5;
        }
        catch (Throwable throwable) {
            n = -5;
        }
        return n;
    }

    public double getWorkCompleted(double d, long l) {
        double d2 = (double)(l * 100L) / d;
        if (d2 > 100.0) {
            d2 = 100.0;
        } else if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public double getTimeElapsed(double d, double d2) {
        double d3 = 100.0 - d2 * 100.0 / d;
        if (d3 > 100.0) {
            d3 = 100.0;
        } else if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }
}

