/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMLanguage;
import com.egurkha.util.EgStreamReaderThread;
import com.egurkha.util.LogFileReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class JVMGCTest
extends JVMInstrumentation {
    private String JVM_1_3_1_MinorGC = "[GC";
    private String JVM_1_3_1_FullGC = "[Full GC ";
    private Hashtable prev_infoFileName = new Hashtable();
    private Hashtable logFileSizeLast = new Hashtable();
    private Hashtable logFileTimestampLast = new Hashtable();
    private Hashtable ddHash = new Hashtable();
    private String P_timeStamp = "NONE";
    private double P_totalHeapSizeBefore = 0.0;
    private double P_totalHeapSizeAfter = 0.0;
    private double P_totalGcTime = 0.0;
    private double P_numberOfGc = 0.0;
    private long agentlastMeasureTimestamp = 0L;
    private static String jvmGcProps = EgInstallInfo.getInstallDir() + "/agent/logs/jvmgc.properties";
    private static String JVMSync = new String("JVMSync");
    private static int configuredMaxDD = 100;
    private static final int defaultMaxDD = 100;
    private String JVM_Version = null;
    Hashtable resultHash = new Hashtable();
    private boolean measure_mode = true;

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("LogFileName", "part1@c:\\singtel1,part2@c:\\singtel2,part3@c:\\singtel3");
        hashtable.put("JREHome", "C:\\jdk1.3.1_08");
        JVMGCTest jVMGCTest = new JVMGCTest(stringArray);
        while (true) {
            jVMGCTest.computeMeasures(hashtable);
            try {
                Thread.currentThread();
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public JVMGCTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        String string = this.reportingName + ":" + this.portNo;
        JVMGCDataRepository.removeGCNotificationDatas(string);
        configuredMaxDD = this.getMaxDD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block116: {
            if (this.mode_type.equalsIgnoreCase("Log File")) {
                Object object;
                String string;
                this.ddHash = new Hashtable();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.JVM_1_3_1_MinorGC);
                arrayList.add(this.JVM_1_3_1_FullGC);
                if (this.JVM_Version == null) {
                    string = (String)hashtable.get("JREHome");
                    this.JVM_Version = this.getJVMVersion(string);
                    if (this.JVM_Version.equals("-1")) {
                        this.logToErrorFile("Error", "JVMGCTest.computeMeasures", "jdkHome is " + string);
                        this.logToErrorFile("Error", "JVMGCTest.computeMeasures", "Could not find JVM version; can't run JVMGCTest");
                        return;
                    }
                } else if (this.JVM_Version.equals("-1")) {
                    return;
                }
                string = (String)hashtable.get("LogFileName");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                boolean bl = false;
                try {
                    object = new File(jvmGcProps);
                    if (!((File)object).exists()) {
                        ((File)object).createNewFile();
                    } else {
                        this.agentlastMeasureTimestamp = ((File)object).lastModified();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object = "NONE";
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        ArrayList arrayList2;
                        NumberFormat numberFormat;
                        String string2;
                        double d;
                        double d2;
                        double d3;
                        Object object2;
                        String string3;
                        String string4;
                        int n;
                        Object object3;
                        Object object4;
                        try {
                            object4 = new File(jvmGcProps);
                            if (!((File)object4).exists()) {
                                ((File)object4).createNewFile();
                            } else {
                                this.agentlastMeasureTimestamp = ((File)object4).lastModified();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        object4 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer((String)object4, "@");
                        if (stringTokenizer2.countTokens() == 2) {
                            object = stringTokenizer2.nextToken();
                        } else {
                            if (bl) continue;
                            bl = true;
                        }
                        string = stringTokenizer2.nextToken();
                        File file = new File(string);
                        Object object5 = null;
                        if (file.isDirectory()) {
                            object3 = file.listFiles();
                            int n2 = 0;
                            if (object3 != null && ((File[])object3).length > 0) {
                                long l = 0L;
                                for (int i = 0; i < ((File[])object3).length; ++i) {
                                    if (((File)object3[i]).lastModified() <= l) continue;
                                    n2 = i;
                                    l = ((File)object3[i]).lastModified();
                                }
                                object5 = object3[n2];
                            }
                            if (object5 == null) {
                                this.logToErrorFile("Error", "JVMGCTest.computeMeasures", "Unable to find files inside the dir " + file);
                                continue;
                            }
                        } else {
                            object5 = file;
                        }
                        object3 = (String)this.prev_infoFileName.get(object);
                        if (!((File)object5).exists()) {
                            this.logToErrorFile("Error", "JVMGCTest.computeMeasures", "Log file " + ((File)object5).toString() + " does not exist for " + (String)object);
                            continue;
                        }
                        if (object3 != null && !((String)object3).equals(((File)object5).toString())) {
                            this.uploadValues((String)object, "[Full GC]", -1);
                            this.uploadValues((String)object, "[Minor GC]", -1);
                            this.prev_infoFileName.put(object, ((File)object5).toString());
                            this.logFileSizeLast.put(object, ((File)object5).length() + "");
                            this.logFileTimestampLast.put(object, ((File)object5).lastModified() + "");
                            continue;
                        }
                        if (((File)object5).length() == 0L) {
                            this.logToErrorFile("Error", "JVMGCTest.computeMeasures", "Log file " + ((File)object5).toString() + " is empty for " + (String)object);
                            this.uploadValues((String)object, "[Full GC]", -1);
                            this.uploadValues((String)object, "[Minor GC]", -1);
                            this.prev_infoFileName.put(object, ((File)object5).toString());
                            continue;
                        }
                        if (this.timeSinceLastTest == -1.0) {
                            String string5 = this.setInitialValues((String)object, (File)object5);
                            if (string5 == null) continue;
                        } else {
                            this.getInitialValues((String)object);
                        }
                        ArrayList arrayList3 = this.getGCOutputFromLogFile((File)object5, arrayList, (String)object);
                        ArrayList arrayList4 = null;
                        ArrayList arrayList5 = null;
                        if (arrayList3 != null && arrayList3.size() == 2) {
                            arrayList4 = (ArrayList)arrayList3.get(0);
                            arrayList5 = (ArrayList)arrayList3.get(1);
                        }
                        if (arrayList3 == null || arrayList3.size() == 0) {
                            this.uploadValues((String)object, "[Full GC]", 0);
                            this.uploadValues((String)object, "[Minor GC]", 0);
                            this.prev_infoFileName.put(object, ((File)object5).toString());
                            continue;
                        }
                        double d4 = 0.0;
                        double d5 = 0.0;
                        double d6 = 0.0;
                        double d7 = 0.0;
                        double d8 = 0.0;
                        double d9 = 0.0;
                        double d10 = 0.0;
                        double d11 = 0.0;
                        double d12 = 0.0;
                        double d13 = 0.0;
                        int n3 = 0;
                        if (arrayList4 != null) {
                            n3 = arrayList4.size();
                        }
                        String string6 = "";
                        ArrayList<ArrayList> arrayList6 = new ArrayList<ArrayList>();
                        ArrayList<ArrayList> arrayList7 = new ArrayList<ArrayList>();
                        String string7 = null;
                        String string8 = null;
                        String string9 = null;
                        for (n = 0; n < n3; ++n) {
                            string4 = (String)arrayList4.get(n);
                            string3 = this.parseValues(string4);
                            if (!this.JVM_Version.startsWith("1.3")) {
                                string6 = string3.substring(0, string3.indexOf(","));
                                string3 = string3.substring(string3.indexOf(",") + 1);
                            }
                            if (((StringTokenizer)(object2 = new StringTokenizer(string3, ","))).countTokens() != 4) continue;
                            d3 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            d2 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            d = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            string2 = ((StringTokenizer)object2).nextToken().trim();
                            numberFormat = NumberFormat.getInstance();
                            numberFormat.setMaximumFractionDigits(3);
                            if (string2.equals("F")) {
                                d7 += 1.0;
                                d4 += d3;
                                d5 += d2;
                                d6 += d;
                                if (d > d8) {
                                    d8 = d;
                                }
                                if (!this.JVM_Version.startsWith("1.3")) {
                                    string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                                    string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                                    string9 = this.filterComma(numberFormat.format(d));
                                    arrayList2 = this.getDDLine(string6, string7, string8, string9);
                                    arrayList6.add(arrayList2);
                                    continue;
                                }
                                string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                                string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                                string9 = this.filterComma(numberFormat.format(d));
                                arrayList2 = this.getDDLine("NONE", string7, string8, string9);
                                arrayList6.add(arrayList2);
                                continue;
                            }
                            d12 += 1.0;
                            d9 += d3;
                            d10 += d2;
                            d11 += d;
                            if (d > d13) {
                                d13 = d;
                            }
                            if (!this.JVM_Version.startsWith("1.3")) {
                                string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                                string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                                string9 = this.filterComma(numberFormat.format(d));
                                arrayList2 = this.getDDLine(string6, string7, string8, string9);
                                arrayList7.add(arrayList2);
                                continue;
                            }
                            string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                            string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                            string9 = this.filterComma(numberFormat.format(d));
                            arrayList2 = this.getDDLine("NONE", string7, string8, string9);
                            arrayList7.add(arrayList2);
                        }
                        n3 = 0;
                        if (arrayList5 != null) {
                            n3 = arrayList5.size();
                        }
                        for (n = 0; n < n3; ++n) {
                            string4 = null;
                            string3 = (String)arrayList5.get(n);
                            if (string3.indexOf("[GC [1 CMS-initial-mark:") > -1) {
                                this.calculateInitialMarkCms(string3);
                            } else if (string3.indexOf("[Full GC") <= -1 && string3.indexOf("[CMS-concurrent-") > -1) {
                                this.calculateCmsConcurrent(string3);
                            } else if (string3.indexOf("[GC[YG occupancy:") > -1) {
                                this.calculateGcYgOccupancy(string3);
                            } else if (string3.indexOf("(concurrent mode failure)") > -1) {
                                string4 = this.calculateConcurrentMode(string3);
                                d7 += 1.0;
                                this.reset();
                            } else if (string3.indexOf("[Full") > -1 && string3.indexOf("[CMS-concurrent-") > -1) {
                                object2 = this.CalculateIdx(string3);
                                d3 = JVMGCTest.parseStrToDbl((String)object2);
                            } else if (string3.indexOf("[Full") > -1 && string3.indexOf("[CMS Perm") > -1) {
                                d7 += 1.0;
                                string4 = this.calculateFullGc(string3);
                                this.reset();
                            }
                            if (string3.indexOf("[CMS-concurrent-reset:") > -1) {
                                d7 += 1.0;
                                string4 = this.P_timeStamp + "," + this.P_totalHeapSizeBefore + "," + this.P_totalHeapSizeAfter + "," + this.P_totalGcTime + "," + "F";
                                this.reset();
                            }
                            if (string4 == null) continue;
                            if (!this.JVM_Version.startsWith("1.3")) {
                                string6 = string4.substring(0, string4.indexOf(","));
                                string4 = string4.substring(string4.indexOf(",") + 1);
                            }
                            if (((StringTokenizer)(object2 = new StringTokenizer(string4, ","))).countTokens() != 4) continue;
                            d3 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            d2 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            d = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                            string2 = ((StringTokenizer)object2).nextToken().trim();
                            numberFormat = NumberFormat.getInstance();
                            numberFormat.setMaximumFractionDigits(3);
                            if (!string2.equals("F")) continue;
                            d4 += d3;
                            d5 += d2;
                            d6 += d;
                            if (d > d8) {
                                d8 = d;
                            }
                            if (!this.JVM_Version.startsWith("1.3")) {
                                string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                                string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                                string9 = this.filterComma(numberFormat.format(d));
                                arrayList2 = this.getDDLine(string6, string7, string8, string9);
                                arrayList6.add(arrayList2);
                                continue;
                            }
                            string7 = this.filterComma(numberFormat.format(this.convertToMBs(d3 + "")));
                            string8 = this.filterComma(numberFormat.format(this.convertToMBs(d2 + "")));
                            string9 = this.filterComma(numberFormat.format(d));
                            arrayList2 = this.getDDLine("NONE", string7, string8, string9);
                            arrayList6.add(arrayList2);
                        }
                        if (((String)object).equals("NONE")) {
                            this.ddHash.put("[Full GC]", arrayList6);
                            this.ddHash.put("[Minor GC]", arrayList7);
                        } else {
                            this.ddHash.put((String)object + "[Full GC]", arrayList6);
                            this.ddHash.put((String)object + "[Minor GC]", arrayList7);
                        }
                        ArrayList<Double> arrayList8 = null;
                        boolean bl2 = false;
                        if (d7 > 0.0) {
                            double d14 = d6 / d7;
                            d3 = this.timeSinceLastTest / d7;
                            arrayList8 = new ArrayList<Double>();
                            arrayList8.add(new Double(d7));
                            arrayList8.add(new Double(d6));
                            if (d3 >= 0.0) {
                                arrayList8.add(new Double(d3));
                            } else {
                                arrayList8.add(new Double(-5.0));
                            }
                            arrayList8.add(new Double(d14));
                            if (d3 > 0.0) {
                                arrayList8.add(new Double(d14 / d3 * 100.0));
                            } else {
                                arrayList8.add(new Double(-5.0));
                            }
                            arrayList8.add(new Double(d8));
                            arrayList8.add(new Double(d4 / d7 / 1024.0));
                            arrayList8.add(new Double(d5 / d7 / 1024.0));
                            if (this.numOutputFields > 8) {
                                d2 = d4 - d5;
                                d = 0.0;
                                if (d2 > 0.0) {
                                    d = d2 / d7;
                                } else {
                                    d2 = 0.0;
                                }
                                arrayList8.add(new Double(this.changeUnit(d2)));
                                arrayList8.add(new Double(this.changeUnit(d)));
                            }
                            if (((String)object).equals("NONE")) {
                                this.addNewMeasure("[Full GC]", arrayList8);
                            } else {
                                this.addNewMeasure((String)object + "[Full GC]", arrayList8);
                            }
                            bl2 = true;
                        } else if (d7 == 0.0) {
                            this.uploadValues((String)object, "[Full GC]", 0);
                        }
                        if (d12 > 0.0) {
                            double d15 = d11 / d12;
                            d3 = this.timeSinceLastTest / d12;
                            arrayList8 = new ArrayList();
                            arrayList8.add(new Double(d12));
                            arrayList8.add(new Double(d11));
                            if (d3 >= 0.0) {
                                arrayList8.add(new Double(d3));
                            } else {
                                arrayList8.add(new Double(-5.0));
                            }
                            arrayList8.add(new Double(d15));
                            if (d3 > 0.0) {
                                arrayList8.add(new Double(d15 / d3 * 100.0));
                            } else {
                                arrayList8.add(new Double(-5.0));
                            }
                            arrayList8.add(new Double(d13));
                            arrayList8.add(new Double(d9 / d12 / 1024.0));
                            arrayList8.add(new Double(d10 / d12 / 1024.0));
                            if (this.numOutputFields > 8) {
                                d2 = d9 - d10;
                                d = 0.0;
                                if (d2 > 0.0) {
                                    d = d2 / d12;
                                } else {
                                    d2 = 0.0;
                                }
                                arrayList8.add(new Double(this.changeUnit(d2)));
                                arrayList8.add(new Double(this.changeUnit(d)));
                            }
                            if (((String)object).equals("NONE")) {
                                this.addNewMeasure("[Minor GC]", arrayList8);
                            } else {
                                this.addNewMeasure((String)object + "[Minor GC]", arrayList8);
                            }
                            bl2 = true;
                        } else if (d12 == 0.0) {
                            this.uploadValues((String)object, "[Minor GC]", 0);
                        }
                        this.prev_infoFileName.put(object, ((File)object5).toString());
                        if (bl2) {
                            String string10 = "Summary";
                            double d16 = d12 + d7;
                            double d17 = d11 + d6;
                            double d18 = 0.0;
                            double d19 = 0.0;
                            double d20 = 0.0;
                            d18 = d13 > d8 ? d13 : d8;
                            double d21 = 0.0;
                            double d22 = 0.0;
                            d21 = d9 + d4;
                            d22 = d10 + d5;
                            if (d16 > 0.0) {
                                d19 = d17 / d16;
                                d20 = this.timeSinceLastTest / d16;
                            }
                            ArrayList<Double> arrayList9 = new ArrayList<Double>();
                            arrayList9.add(new Double(d16));
                            arrayList9.add(new Double(d17));
                            if (d20 >= 0.0) {
                                arrayList9.add(new Double(d20));
                            } else {
                                arrayList9.add(new Double(-5.0));
                            }
                            arrayList9.add(new Double(d19));
                            if (d20 > 0.0) {
                                arrayList9.add(new Double(d19 / d20 * 100.0));
                            } else {
                                arrayList9.add(new Double(-5.0));
                            }
                            arrayList9.add(new Double(d18));
                            arrayList9.add(new Double(this.changeUnit(d21 / d16)));
                            arrayList9.add(new Double(this.changeUnit(d22 / d16)));
                            if (this.numOutputFields > 8) {
                                double d23 = d21 - d22;
                                double d24 = 0.0;
                                if (d23 > 0.0) {
                                    d24 = d23 / d16;
                                } else {
                                    d23 = 0.0;
                                }
                                arrayList9.add(new Double(this.changeUnit(d23)));
                                arrayList9.add(new Double(this.changeUnit(d24)));
                            }
                            this.addNewMeasure(string10, arrayList9);
                            continue;
                        }
                        this.uploadValues("NONE", "Summary", 0);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception occured while parsing :" + exception.getMessage());
                    }
                    finally {
                        this.setPreviousValues((String)object);
                        this.reset();
                    }
                }
            } else if (this.mode_type.equalsIgnoreCase("JMX")) {
                JvmHelperThread jvmHelperThread = new JvmHelperThread(this.entity, this, this.urlStr, this.userName, this.password);
                long l = 0L;
                long l2 = this.timeout;
                long l3 = 250L;
                int n = 0;
                int n4 = 0;
                boolean bl = false;
                long l4 = System.currentTimeMillis();
                while (true) {
                    this.suspendForPeriod(l3);
                    if (jvmHelperThread.isDone()) {
                        n4 = jvmHelperThread.getStatusCode();
                        this.resultHash = jvmHelperThread.getResult();
                        bl = jvmHelperThread.isStatus();
                        break;
                    }
                    if (++n >= 5) {
                        n = 0;
                        l = System.currentTimeMillis() - l4;
                    } else {
                        l += l3;
                    }
                    if (l >= l2 || l3 <= 0L) {
                        jvmHelperThread.closeJVMconnectionWhenInterrupt();
                        break;
                    }
                    long l5 = l2 - l;
                    if (l5 >= l3) continue;
                    l3 = l5;
                }
                if (n4 == 100 && bl) {
                    try {
                        this.ddHash = new Hashtable();
                        if (this.resultHash != null && this.resultHash.size() > 0) {
                            ArrayList arrayList = (ArrayList)this.resultHash.get("gcResult");
                            ArrayList arrayList10 = GarbageCollectionUtil.parseGCvalues(arrayList, APMLanguage.JAVA, this.timeSinceLastTest, this.numOutputFields);
                            if (arrayList10 != null && arrayList10.size() > 0) {
                                Hashtable hashtable2 = (Hashtable)arrayList10.get(0);
                                this.ddHash = (Hashtable)arrayList10.get(1);
                                if (hashtable2 != null) {
                                    Set set = hashtable2.keySet();
                                    for (String string : set) {
                                        ArrayList arrayList11 = (ArrayList)hashtable2.get(string);
                                        this.addNewMeasure(string, arrayList11);
                                    }
                                }
                            } else {
                                this.uploadValues("Minor GC:", "Total", 0);
                                this.uploadValues("Full GC:", "Total", 0);
                                this.uploadValues("NONE", "Summary", 0);
                            }
                            break block116;
                        }
                        this.uploadValues("Minor GC:", "Total", 0);
                        this.uploadValues("Full GC:", "Total", 0);
                        this.uploadValues("NONE", "Summary", 0);
                    }
                    catch (Exception exception) {
                        System.out.println("Exception occured while parsing the data in Test code - " + exception.getMessage());
                        exception.printStackTrace();
                    }
                } else {
                    System.out.println(this.entity.toUpperCase() + " : Connection to JVM is not established for Host : " + this.reportingName);
                }
            }
        }
    }

    private ArrayList getDDLine(String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        if (this.numOutputFields > 8) {
            double d = this.getClaimedBytes(string2, string3);
            arrayList.add(JVMInstrumentation.formatValue(d));
        }
        return arrayList;
    }

    private ArrayList getDDLine(String string, double d, double d2, double d3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(JVMInstrumentation.formatValue(d));
        arrayList.add(JVMInstrumentation.formatValue(d2));
        arrayList.add(JVMInstrumentation.formatValue(d3));
        if (this.numOutputFields > 8) {
            double d4 = d - d2;
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            arrayList.add(JVMInstrumentation.formatValue(d4));
        }
        return arrayList;
    }

    private double getClaimedBytes(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            d2 = 0.0;
        }
        if (d >= 0.0 && d2 >= 0.0) {
            d3 = d - d2;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    protected ArrayList getDDMeasures(String string) {
        return (ArrayList)this.ddHash.get(string);
    }

    private String filterComma(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (string.indexOf(",") > -1) {
            stringBuffer = stringBuffer.deleteCharAt(string.indexOf(","));
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getGCOutputFromLogFile(File file, ArrayList arrayList, String string) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList arrayList4;
        block26: {
            long l = file.lastModified();
            long l2 = file.length();
            String string2 = (String)this.logFileSizeLast.get(string);
            long l3 = 0L;
            long l4 = 0L;
            if (string2 != null) {
                l3 = Long.parseLong(string2);
            }
            if ((string2 = (String)this.logFileTimestampLast.get(string)) != null) {
                l4 = Long.parseLong(string2);
            }
            if (l == l4 && l2 == l3) {
                return null;
            }
            if (l2 < l3) {
                l3 = l2;
                this.reset();
                l3 = 0L;
            }
            arrayList4 = new ArrayList();
            arrayList3 = new ArrayList<String>();
            arrayList2 = new ArrayList<String>();
            try {
                LogFileReader logFileReader = new LogFileReader(file, l3);
                String string3 = "";
                if (this.JVM_Version.startsWith("1.3")) {
                    block7: while ((string3 = logFileReader.readLine()) != null) {
                        if (string3.indexOf("[GC") <= -1 && string3.indexOf("[Full GC ") <= -1) continue;
                        if (string3.indexOf("->") > -1) {
                            arrayList3.add(string3);
                            continue;
                        }
                        boolean bl = false;
                        if (string3.indexOf("[Full GC") > -1) {
                            bl = true;
                        }
                        while ((string3 = logFileReader.readLine()) != null) {
                            if (string3.indexOf("->") <= -1) continue;
                            string3 = bl ? "[Full GC " + string3 : "[GC " + string3;
                            arrayList3.add(string3);
                            continue block7;
                        }
                    }
                    break block26;
                }
                int n = 0;
                String string4 = "";
                while ((string4 = logFileReader.readLine()) != null) {
                    block27: {
                        block28: {
                            if (n > 1) {
                                string3 = string4;
                                ++n;
                                break;
                            }
                            if (string3.indexOf("[GC") <= -1 && string3.indexOf("[Full GC ") <= -1 && string3.indexOf("[Full GC") <= -1 && string3.indexOf("[GC [1 CMS-initial-mark:") <= -1 && string3.indexOf("(concurrent mode failure)") <= -1 && string3.indexOf("[CMS-concurrent-") <= -1 && string3.indexOf("[CMS-concurrent-reset:") <= -1) break block27;
                            if (string3.indexOf("[GC [1 CMS-initial-mark:") <= -1 && string3.indexOf("[CMS-concurrent-") <= -1 && string3.indexOf("(concurrent mode failure)") <= -1 && (string3.indexOf("[Full GC ") <= -1 || string3.indexOf("[CMS") <= -1) && string3.indexOf("[GC[YG occupancy:") <= -1) break block28;
                            if (!(string3 = string3.trim()).endsWith("secs]")) break block27;
                            arrayList2.add(string3);
                            break block27;
                        }
                        if (string3.indexOf("->") > -1) {
                            arrayList3.add(string3);
                        } else {
                            boolean bl = false;
                            if (string3.indexOf("[Full GC") > -1) {
                                bl = true;
                            }
                            String string5 = null;
                            if (!string3.startsWith("[GC") && !string3.startsWith("[Full GC")) {
                                int n2;
                                String string6 = null;
                                String string7 = ": [GC ";
                                if (bl) {
                                    string7 = ": [Full GC ";
                                }
                                if ((n2 = string3.indexOf(string7)) > -1) {
                                    string6 = string3.substring(0, n2);
                                    int n3 = string6.lastIndexOf(" ");
                                    string5 = n3 > -1 ? string6.substring(n3 + 1, n2) : string6.substring(0, n2);
                                }
                                if (string5 != null) {
                                    try {
                                        Double.parseDouble(string5);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        string5 = null;
                                    }
                                }
                            }
                            while ((string3 = logFileReader.readLine()) != null) {
                                if (string3.indexOf("->") <= -1) continue;
                                string3 = bl ? (string5 != null ? string5 + ":[Full GC " + string3 : "[Full GC " + string3) : (string5 != null ? string5 + ":[GC " + string3 : "[GC " + string3);
                                arrayList3.add(string3);
                                break;
                            }
                        }
                    }
                    string3 = string4;
                }
                l2 -= (long)string3.length();
            }
            catch (IOException iOException) {
                System.out.println("Error while skipping N char in the file:" + iOException.toString());
            }
            finally {
                this.setCurrentValue("logFileTimestamp", l + "");
                this.setCurrentValue("logFileSize", l2 + "");
                this.logFileTimestampLast.put(string, l + "");
                this.logFileSizeLast.put(string, l2 + "");
            }
        }
        arrayList4.add(arrayList3);
        arrayList4.add(arrayList2);
        return arrayList4;
    }

    private String parseValues(String string) {
        int n;
        String string2 = "M";
        if (string.indexOf("[Full GC") > -1) {
            string2 = "F";
        }
        int n2 = 0;
        n2 = string.lastIndexOf("K->");
        if (n2 == -1) {
            return null;
        }
        String string3 = string.substring(0, n2);
        int n3 = string3.lastIndexOf(" ");
        if (n3 == -1) {
            return null;
        }
        string3 = string3.substring(n3);
        String string4 = string.substring(n2 + 3);
        int n4 = string4.indexOf("K(");
        if (n4 == -1) {
            return null;
        }
        String string5 = string4.substring(0, n4);
        int n5 = string4.indexOf(" ");
        if ((string4 = string4.substring(n5 + 1)).indexOf("icms_dc") > -1 && string4.indexOf(",") > -1) {
            string4 = string4.substring(string4.indexOf(",") + 1);
            string4 = string4.trim();
        }
        if ((n = string4.indexOf(" secs]")) == -1) {
            return null;
        }
        String string6 = string4.substring(0, n);
        String string7 = "";
        if (this.JVM_Version.startsWith("1.3")) {
            string7 = string3 + "," + string5 + "," + string6 + "," + string2;
        } else {
            String string8 = "NONE";
            if (string.indexOf(": [") > -1) {
                string8 = string.substring(0, string.indexOf(": ["));
            } else if (string.indexOf(":[") > -1) {
                string8 = string.substring(0, string.indexOf(":["));
            }
            string7 = string8 + "," + string3.trim() + "," + string5 + "," + string6 + "," + string2;
        }
        return string7;
    }

    private String getJVMVersion(String string) {
        string = string.endsWith(System.getProperty("file.separator")) ? string : string + System.getProperty("file.separator");
        String string2 = string + "bin" + System.getProperty("file.separator") + "java";
        File file = new File(string2);
        if (!file.exists() && !(file = new File(string2 + ".exe")).exists()) {
            System.out.println("Java executable is not found at " + file.toString());
            return "-1";
        }
        String string3 = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            string3 = "cmd /c ";
        }
        string3 = string3 + "\"" + string2 + "\"" + " -version";
        try {
            String string4;
            int n;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string3);
            EgStreamReaderThread egStreamReaderThread = new EgStreamReaderThread(process.getInputStream());
            EgStreamReaderThread egStreamReaderThread2 = new EgStreamReaderThread(process.getErrorStream());
            egStreamReaderThread.start();
            egStreamReaderThread2.start();
            process.waitFor();
            ArrayList arrayList = egStreamReaderThread.getData();
            String string5 = null;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                string4 = (String)arrayList.get(n);
                if (!string4.startsWith("java version") || (string5 = (string4 = this.replaceAll(string4, "\"", "")).substring("java version".length())) == null || string5.trim().length() <= 0) continue;
                string5 = string5.trim();
            }
            arrayList = egStreamReaderThread2.getData();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                string4 = (String)arrayList.get(n);
                if (!string4.startsWith("java version")) continue;
                string5 = (string4 = this.replaceAll(string4, "\"", "")).substring("java version".length());
                if (string5 == null || string5.trim().length() <= 0) break;
                string5 = string5.trim();
                break;
            }
            return string5;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "-1";
    }

    protected String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    private void uploadValues(String string, String string2, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d = new Double(n);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        arrayList.add(d);
        if (this.numOutputFields > 8) {
            arrayList.add(d);
            arrayList.add(d);
        }
        if (string.equals("NONE")) {
            this.addNewMeasure(string2, arrayList);
        } else {
            this.addNewMeasure(string + string2, arrayList);
        }
    }

    private String CalculateIdx(String string) {
        String string2 = null;
        int n = string.lastIndexOf("secs]");
        int n2 = string.lastIndexOf("real") + 5;
        if (n > -1 && n2 > -1) {
            string2 = string.substring(n2, n);
        }
        return string2;
    }

    private void reset() {
        this.P_totalGcTime = 0.0;
        this.P_timeStamp = "NONE";
        this.P_totalHeapSizeAfter = 0.0;
        this.P_totalHeapSizeBefore = 0.0;
        this.P_numberOfGc = 0.0;
    }

    protected double convertToMBs(String string) {
        try {
            double d = Double.parseDouble(string);
            return d / 1024.0;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentValue(String string, String string2) {
        Properties properties = new Properties();
        String string3 = this.reportingName + ":" + string;
        InputStream inputStream = null;
        try {
            String string4 = JVMSync;
            synchronized (string4) {
                inputStream = new FileInputStream(jvmGcProps);
                properties.load(new BufferedInputStream(inputStream));
                properties.setProperty(string3, string2);
                properties.store(new BufferedOutputStream(new FileOutputStream(jvmGcProps)), "eG Java Monitor Information file <P> PLEASE DO NOT DELETE <P>");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPreviousValue(String string) {
        String string2 = null;
        String string3 = this.reportingName + ":" + string;
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String string4 = JVMSync;
            synchronized (string4) {
                inputStream = new FileInputStream(jvmGcProps);
                properties.load(new BufferedInputStream(inputStream));
                string2 = properties.getProperty(string3);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    private static double parseStrToDbl(String string) {
        double d = 0.0;
        if (string != null) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                System.out.println("Exception occured while parsing :  " + string);
            }
        }
        return d;
    }

    private void calculateInitialMarkCms(String string) {
        this.P_timeStamp = string.substring(0, string.indexOf(": [GC"));
        this.P_numberOfGc = 1.0;
        String string2 = this.CalculateIdx(string);
        double d = JVMGCTest.parseStrToDbl(string2);
        this.P_totalGcTime += d;
        int n = string.indexOf("] ");
        int n2 = string.indexOf(",");
        String string3 = string.substring(n + 2, n2);
        String string4 = string3.substring(0, string3.indexOf("(") - 1);
        this.P_totalHeapSizeBefore = Double.parseDouble(string4);
    }

    private void calculateCmsConcurrent(String string) {
        String string2 = this.CalculateIdx(string);
        double d = JVMGCTest.parseStrToDbl(string2);
        this.P_totalGcTime += d;
    }

    private void calculateGcYgOccupancy(String string) {
        String string2 = this.CalculateIdx(string);
        double d = JVMGCTest.parseStrToDbl(string2);
        this.P_totalGcTime += d;
        String string3 = null;
        String string4 = null;
        int n = string.lastIndexOf("[1 CMS-remark:");
        if (n > -1) {
            string3 = string.substring(n);
        }
        int n2 = string3.indexOf("]");
        int n3 = string3.indexOf(",");
        if (n2 > -1 && n3 > -1) {
            string4 = string3.substring(n2, n3);
        }
        n3 = string4.indexOf("(") - 1;
        int n4 = string4.indexOf("] ");
        if (n3 > -1 && n4 > -1) {
            String string5 = string4.substring(n4 + 1, n3);
            string5 = string5.trim();
            this.P_totalHeapSizeAfter = Double.parseDouble(string5);
        }
    }

    private String calculateConcurrentMode(String string) {
        String string2 = null;
        String string3 = this.CalculateIdx(string);
        double d = JVMGCTest.parseStrToDbl(string3);
        this.P_totalGcTime += d;
        int n = string.indexOf(", [");
        int n2 = string.indexOf("] ");
        String string4 = null;
        if (n > -1 && n2 > -1) {
            string4 = string.substring(n2 + 1, n);
        }
        n2 = string4.indexOf("(") - 1;
        int n3 = string4.indexOf("->");
        String string5 = null;
        String string6 = null;
        if (n2 > -1 && n3 > -1) {
            string5 = string4.substring(n3 + 2, n2);
            string6 = string4.substring(0, n3 - 1);
            string5 = string5.trim();
            string6 = string6.trim();
        }
        string2 = this.P_timeStamp + "," + string6 + "," + string5 + "," + this.P_totalGcTime + "," + "F";
        return string2;
    }

    private String calculateFullGc(String string) {
        String string2 = null;
        String string3 = this.CalculateIdx(string);
        double d = JVMGCTest.parseStrToDbl(string3);
        this.P_timeStamp = string.substring(0, string.indexOf(": [Full"));
        String string4 = string.substring(string.indexOf("secs]") + "secs]".length(), string.lastIndexOf("[CMS"));
        String string5 = string4.substring(0, string4.indexOf("->") - 1);
        string5 = string5.trim();
        String string6 = string4.substring(string4.indexOf("->") + 2, string4.indexOf("(") - 1);
        string6 = string6.trim();
        string2 = this.P_timeStamp + "," + string5 + "," + string6 + "," + d + "," + "F";
        return string2;
    }

    private void setPreviousValues(String string) {
        this.setCurrentValue("P_numberOfGc:" + string, this.P_numberOfGc + "");
        this.setCurrentValue("P_timeStamp:" + string, this.P_timeStamp + "");
        this.setCurrentValue("P_totalHeapSizeBefore:" + string, this.P_totalHeapSizeBefore + "");
        this.setCurrentValue("P_totalHeapSizeAfter:" + string, this.P_totalHeapSizeAfter + "");
    }

    private String setInitialValues(String string, File file) {
        String string2 = "Dummy";
        long l = System.currentTimeMillis();
        String string3 = this.getPreviousValue("logFileTimestamp:" + string);
        if (string3 == null) {
            this.setInitialValues(string);
            return null;
        }
        String string4 = this.getPreviousValue("logFileSize:" + string);
        String string5 = this.getPreviousValue("P_numberOfGc:" + string);
        this.P_numberOfGc = JVMGCTest.parseStrToDbl(string5);
        this.P_timeStamp = this.getPreviousValue("P_timeStamp:" + string);
        this.logFileSizeLast.put(string, string4 + "");
        this.logFileTimestampLast.put(string, string3 + "");
        String string6 = this.getPreviousValue("P_totalHeapSizeBefore:" + string);
        this.P_totalHeapSizeBefore = JVMGCTest.parseStrToDbl(string6);
        String string7 = this.getPreviousValue("P_totalHeapSizeAfter:" + string);
        this.P_totalHeapSizeAfter = JVMGCTest.parseStrToDbl(string7);
        this.uploadValues(string, "[Full GC]", -1);
        this.uploadValues(string, "[Minor GC]", -1);
        this.prev_infoFileName.put(string, file.toString());
        if (this.agentlastMeasureTimestamp > 0L) {
            long l2 = (l - this.agentlastMeasureTimestamp) / 1000L / 60L;
            if (l2 > 240L) {
                this.logFileSizeLast.put(string, file.length() + "");
                this.logFileTimestampLast.put(string, file.lastModified() + "");
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    private void setInitialValues(String string) {
        this.setCurrentValue("logFileTimestamp:" + string, "0");
        this.setCurrentValue("logFileSize:" + string, "0");
        this.setCurrentValue("P_numberOfGc:" + string, "0");
        this.setCurrentValue("P_timeStamp:" + string, "0");
        this.setCurrentValue("P_totalHeapSizeBefore:" + string, "0");
        this.setCurrentValue("P_totalHeapSizeAfter:" + string, "0");
    }

    private void getInitialValues(String string) {
        String string2 = this.getPreviousValue("P_numberOfGc:" + string);
        this.P_numberOfGc = JVMGCTest.parseStrToDbl(string2);
        this.P_timeStamp = this.getPreviousValue("P_timeStamp:" + string);
        String string3 = this.getPreviousValue("P_totalHeapSizeBefore:" + string);
        this.P_totalHeapSizeBefore = JVMGCTest.parseStrToDbl(string3);
        String string4 = this.getPreviousValue("P_totalHeapSizeAfter:" + string);
        this.P_totalHeapSizeAfter = JVMGCTest.parseStrToDbl(string4);
    }

    public int getMaximumDD() {
        return configuredMaxDD;
    }

    private int getMaxDD() {
        int n = -1;
        String string = testerInfo.getValueFor("DD_ROWS", "JVMGCTest_Max_DD");
        if (string != null && string.length() > 0) {
            try {
                int n2;
                n = n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 100;
        }
        return n;
    }
}

