/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JRunServerTest
extends GenericTest {
    double totalMemory;
    double freeMemeory;
    double numOfSessions;
    double numOfSessionsInMem;
    String homeDir;
    String temp;
    String fileName;
    BufferedReader data;
    String line;
    StringTokenizer st;
    long lastModifiedTime;
    long newTime;
    File f = null;
    boolean flag = true;
    ArrayList measureList = null;
    long startTime;
    String[] servList = null;
    EgDateInfo date = new EgDateInfo();
    int i;
    String serverName = null;
    boolean debug = false;
    ArrayList lastModifiedTimeList = new ArrayList();
    ArrayList currentModifiedTimeList = new ArrayList();
    ArrayList flagList = new ArrayList();
    boolean firstTime = true;
    long msecPerHour = 3600000L;

    public static void main(String[] stringArray) {
        JRunServerTest jRunServerTest = new JRunServerTest(stringArray);
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < 10; ++i) {
            try {
                jRunServerTest.executeTest();
                Thread.sleep(10000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JRunServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.startTime = 0L;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            this.usage();
            return;
        }
        if (stringArray.length > 2 && !stringArray[2].equalsIgnoreCase("-port")) {
            this.usage();
            return;
        }
        if (stringArray.length > 4 && !stringArray[4].equalsIgnoreCase("-homeDir")) {
            this.usage();
            return;
        }
        this.homeDir = stringArray[5];
    }

    public void usage() {
        System.err.println("Usage: JRunThreadTest -host <targetHost> -port <Port> -homeDir <homeDir> ");
    }

    public synchronized boolean CheckForUpdate(File file) {
        this.currentModifiedTimeList.set(this.i, new Long(file.lastModified()));
        if (this.debug) {
            System.out.println("currentModifiedTimeList :" + this.currentModifiedTimeList.get(this.i) + " lastModifiedTimeList:" + this.lastModifiedTimeList.get(this.i));
        }
        if ((Long)this.currentModifiedTimeList.get(this.i) <= (Long)this.lastModifiedTimeList.get(this.i)) {
            return false;
        }
        this.lastModifiedTimeList.set(this.i, this.currentModifiedTimeList.get(this.i));
        return true;
    }

    public void cleanUpArrayList(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.remove(0);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        this.measureList = new ArrayList();
        if (!hashtable.containsKey("homeDir")) {
            this.setErrorMessage("Home path to JRun server has not been passed");
            return;
        }
        this.homeDir = (String)hashtable.get("homeDir");
        if (System.currentTimeMillis() - this.startTime > this.msecPerHour || this.startTime == 0L) {
            this.servList = this.getServerList(this.homeDir);
            this.startTime = System.currentTimeMillis();
            this.firstTime = true;
            this.cleanUpArrayList(this.currentModifiedTimeList);
            this.cleanUpArrayList(this.lastModifiedTimeList);
            this.cleanUpArrayList(this.flagList);
        }
        if (this.firstTime) {
            for (n = 0; n < this.servList.length; ++n) {
                this.currentModifiedTimeList.add(n, new Long(0L));
                this.lastModifiedTimeList.add(n, new Long(0L));
                this.flagList.add(n, new Boolean(true));
            }
            this.firstTime = false;
        }
        this.i = 0;
        if (this.servList != null) {
            n = 0;
            while (this.i < this.servList.length) {
                this.measureList = new ArrayList();
                this.fileName = this.homeDir + "/logs/" + this.servList[this.i];
                this.serverName = this.servList[this.i].substring(0, this.servList[this.i].indexOf("-"));
                this.f = new File(this.fileName);
                if (((Boolean)this.flagList.get(this.i)).booleanValue()) {
                    this.lastModifiedTimeList.set(this.i, new Long(this.f.lastModified()));
                    this.flagList.set(this.i, new Boolean(false));
                }
                if (this.CheckForUpdate(this.f)) {
                    try {
                        this.data = new BufferedReader(new FileReader(this.fileName));
                        if (this.data == null) {
                            this.setErrorMessage("No data in file");
                            return;
                        }
                        String string = "";
                        while ((this.line = this.data.readLine()) != null) {
                            string = this.line;
                        }
                        this.data.close();
                        this.data = null;
                        if (string != null && string.indexOf("metrics") > 0) {
                            this.st = new StringTokenizer(string);
                            if (this.st.countTokens() == 19) {
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.totalMemory = Double.parseDouble(this.st.nextToken()) / 1024.0;
                                this.freeMemeory = Double.parseDouble(this.st.nextToken()) / 1024.0;
                                this.numOfSessions = Double.parseDouble(this.st.nextToken());
                                this.numOfSessionsInMem = Double.parseDouble(this.st.nextToken());
                            } else if (this.st.countTokens() == 17) {
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.totalMemory = Double.parseDouble(this.st.nextToken()) / 1024.0;
                                this.freeMemeory = Double.parseDouble(this.st.nextToken()) / 1024.0;
                                this.numOfSessions = Double.parseDouble(this.st.nextToken());
                                this.numOfSessionsInMem = Double.parseDouble(this.st.nextToken());
                            }
                            if (this.debug) {
                                System.out.println("\nservList :" + this.serverName);
                                System.out.println("totalMemory (MB)" + this.totalMemory);
                                System.out.println("freeMemeory(MB) " + this.freeMemeory);
                                System.out.println("numOfSessions (N)" + this.numOfSessions);
                                System.out.println("numOfSessionsInMem (N)" + this.numOfSessionsInMem);
                            }
                            this.setMeasures();
                        }
                        this.resetValue();
                        this.setMeasures();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.setErrorMessage("The monitoring log file not found");
                        if (this.debug) {
                            System.out.println("The monitoring log file not found");
                        }
                        this.resetValue();
                        this.setMeasures();
                        try {
                            if (this.data != null) {
                                this.data.close();
                            }
                            this.data = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (this.debug) {
                            System.out.println("AA" + exception);
                        }
                        exception.printStackTrace();
                        this.resetValue();
                        this.setMeasures();
                        try {
                            if (this.data != null) {
                                this.data.close();
                            }
                            this.data = null;
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        return;
                    }
                } else {
                    try {
                        this.resetValue();
                        this.setMeasures();
                        if (this.data != null) {
                            this.data.close();
                        }
                        this.data = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++this.i;
            }
        } else {
            return;
        }
    }

    private String[] getServerList(String string) {
        string = string + "/logs";
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("metrics.log") <= 0) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private void resetValue() {
        this.totalMemory = -1.0;
        this.freeMemeory = -1.0;
        this.numOfSessions = -1.0;
        this.numOfSessionsInMem = -1.0;
    }

    private void setMeasures() {
        this.measureList.add(new Double(this.totalMemory));
        this.measureList.add(new Double(this.freeMemeory));
        this.measureList.add(new Double(this.numOfSessions));
        this.measureList.add(new Double(this.numOfSessionsInMem));
        this.addNewMeasure(this.serverName, this.measureList);
    }
}

