/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class IOTaskTest
extends GenericTest {
    long num_lines = 99999L;
    String fileName = "";
    boolean usedebug = false;

    public IOTaskTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("No_Of_Lines_To_Write");
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase("none")) {
            try {
                this.num_lines = Long.parseLong(string);
            }
            catch (Exception exception) {
                System.out.println(this.reportingName + ":[IOTaskTest] invalid data for No Of lines To write hence setting to default 99999");
                this.num_lines = 99999L;
            }
        }
        this.fileName = this.getValueForParam("File_Location");
        if (this.fileName == null || this.fileName.length() == 0 || this.fileName.equalsIgnoreCase("none")) {
            System.out.println(this.reportingName + ":[IOTaskTest] File location is null hence setting it to default " + EgInstallInfo.getInstallDir() + "/tmp/iotask.txt");
            this.fileName = EgInstallInfo.getInstallDir() + "/tmp/iotask.txt";
        }
        this.setMeasureCount(this.measureCount);
    }

    public void computeMeasures(Hashtable hashtable) {
        long l;
        if (this.usedebug) {
            System.out.println(this.reportingName + ":[IOTaskTest]  no of lines to write is " + this.num_lines + "  " + new Date());
        }
        long l2 = System.currentTimeMillis();
        for (l = 0L; l < this.num_lines; ++l) {
            this.logToErrFile("TEST", "me", "" + l);
        }
        l = System.currentTimeMillis();
        long l3 = l - l2;
        if (this.usedebug) {
            System.out.println(this.reportingName + ":[IOTaskTest] write time in millisecs = " + l3 + " " + new Date());
        }
        this.readFile();
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
        if (this.usedebug) {
            System.out.println(this.reportingName + ":[IOTaskTest] read time in millisecs = " + l5 + " " + new Date());
        }
        long l6 = l3 + l5;
        this.deleteFile();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double((double)l5 / 1000.0));
        arrayList.add(new Double((double)l3 / 1000.0));
        arrayList.add(new Double((double)l6 / 1000.0));
        if (this.usedebug) {
            System.out.println(this.reportingName + ":[IOTaskTest] measures = " + arrayList + " " + new Date());
        }
        this.addNewMeasure(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logToErrFile(String string, String string2, String string3) {
        PrintWriter printWriter = null;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        try {
            printWriter = new PrintWriter(new FileWriter(this.fileName, true));
            String string5 = new String(string4 + " " + string + " " + string2 + " " + string3);
            printWriter.println(string5);
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println(this.reportingName + ":Cannot write in log file ");
            exception.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    System.err.println(this.reportingName + ":[IOTaskTest]  exception in closing logWriter");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile() {
        File file = new File(this.fileName);
        if (file.exists() && file.isFile() && file.canRead()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                }
            }
            catch (Exception exception) {
                System.err.println(this.reportingName + ":[IOTaskTest]  exception in reading file");
                exception.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        System.err.println(this.reportingName + ":[IOTaskTest]  exception in closing br");
                    }
                }
            }
        }
    }

    public void deleteFile() {
        File file = new File(this.fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void main(String[] stringArray) {
        IOTaskTest iOTaskTest = new IOTaskTest(stringArray);
        iOTaskTest.usedebug = true;
        iOTaskTest.computeMeasures(new Hashtable());
    }
}

