/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBTCPIPSvrTest
extends IIBResourceStatisticsBase {
    private static final int TCP_IP_CLIENT_NODES_STAT_MEASURE_COUNT = 7;
    public Hashtable prevhash = new Hashtable();

    public IIBTCPIPSvrTest(String[] args) {
        super(args);
        this.setMeasureCount(7);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable currHashtable = new Hashtable();
        currHashtable = this.getData("TCPIPServerNodes");
        if (currHashtable == null || currHashtable.size() == 0 || currHashtable.isEmpty()) {
            return;
        }
        if (currHashtable != null) {
            Enumeration en = currHashtable.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (this.prevhash != null && this.prevhash.size() > 0) {
                    ArrayList prevlist = (ArrayList)this.prevhash.get(key);
                    ArrayList currentlist = (ArrayList)currHashtable.get(key);
                    if (prevlist == null || currentlist == null) continue;
                    double openConnections = (Double)currentlist.get(0);
                    double currClosedConnections = (Double)currentlist.get(1);
                    double prevClosedConnections = (Double)prevlist.get(1);
                    double closedConnections = currClosedConnections - prevClosedConnections;
                    double currFailedSSLConnections = (Double)currentlist.get(2);
                    double prevFailedSSLConnections = (Double)prevlist.get(2);
                    double failedSSLConnection = currFailedSSLConnections - prevFailedSSLConnections;
                    double messagesReceived = (Double)currentlist.get(3);
                    double messagesSent = (Double)currentlist.get(4);
                    double bytesReceived = (Double)currentlist.get(5);
                    double bytesSent = (Double)currentlist.get(6);
                    double messageReceivedRate = 0.0;
                    double messageSentRate = 0.0;
                    double bytesReceivedRate = 0.0;
                    double bytesSentRate = 0.0;
                    if (this.timeSinceLastTest > 0.0) {
                        messageReceivedRate = messagesReceived / this.timeSinceLastTest;
                        messageSentRate = messagesSent / this.timeSinceLastTest;
                        bytesReceivedRate = bytesReceived / this.timeSinceLastTest;
                        bytesSentRate = bytesSent / this.timeSinceLastTest;
                    } else {
                        this.printOut("WARNING : timeSinceLastTest value less than zero ");
                        messageReceivedRate = -5.0;
                        messageSentRate = -5.0;
                        bytesReceivedRate = -5.0;
                        bytesSentRate = -5.0;
                    }
                    if (EgTest.debug) {
                        this.printOut(" openConnections ======>" + openConnections);
                        this.printOut(" closedConnections ======>" + closedConnections);
                        this.printOut(" failedSSLConnection ======>" + failedSSLConnection);
                        this.printOut(" messageReceivedRate ======>" + messageReceivedRate);
                        this.printOut(" messageSentRate =====>" + messageSentRate);
                        this.printOut(" bytesReceivedRate ======>" + bytesReceivedRate);
                        this.printOut(" bytesSentRate ======>" + bytesSentRate);
                    }
                    ArrayList<Double> measurelist = new ArrayList<Double>();
                    measurelist.add(new Double(openConnections));
                    measurelist.add(new Double(closedConnections));
                    measurelist.add(new Double(failedSSLConnection));
                    measurelist.add(new Double(messageReceivedRate));
                    measurelist.add(new Double(messageSentRate));
                    measurelist.add(new Double(bytesReceivedRate));
                    measurelist.add(new Double(bytesSentRate));
                    if (EgTest.debug) {
                        this.printOut(" key1====>" + key + " value1===>" + measurelist);
                    }
                    this.addNewMeasure(key, measurelist);
                    continue;
                }
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                if (EgTest.debug) {
                    this.printOut("NotAvaliablevalue key==>" + key + " value===>" + al);
                }
                this.addNewMeasure(key, al);
            }
            this.prevhash = currHashtable;
            if (EgTest.debug) {
                this.printOut("previoushash======>" + this.prevhash);
            }
        }
    }

    public static void main(String[] args) {
        IIBTCPIPSvrTest obj = new IIBTCPIPSvrTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

