/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBJVMGCTest
extends IIBResourceStatisticsBase {
    private static final int JVM_GC_STAT_MEASURE_COUNT = 3;
    public Hashtable prevhash = new Hashtable();

    public IIBJVMGCTest(String[] args) {
        super(args);
        this.setMeasureCount(3);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable currHashtable = new Hashtable();
        currHashtable = this.getData("JVM_GC");
        if (currHashtable == null || currHashtable.size() == 0 || currHashtable.isEmpty()) {
            return;
        }
        if (currHashtable != null) {
            Enumeration en = currHashtable.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (this.prevhash != null && this.prevhash.size() > 0) {
                    ArrayList prevlist = (ArrayList)this.prevhash.get(key);
                    ArrayList currentlist = (ArrayList)currHashtable.get(key);
                    if (prevlist == null || currentlist == null) continue;
                    double gcTime = 0.0;
                    double gcCollections = 0.0;
                    double gcPCT = 0.0;
                    double currGCTime = (Double)currentlist.get(0);
                    double currGCCollections = (Double)currentlist.get(1);
                    double prevGCTime = (Double)prevlist.get(0);
                    double prevGCCollections = (Double)prevlist.get(1);
                    if (currGCTime > 0.0 && prevGCTime > 0.0) {
                        gcTime = currGCTime - prevGCTime;
                        if (this.timeSinceLastTest > 0.0) {
                            gcPCT = gcTime / this.timeSinceLastTest;
                        } else {
                            this.printOut(" WARNING :timeSinceLastTest value is  less than zero");
                            gcPCT = -5.0;
                        }
                    } else {
                        gcTime = -5.0;
                        gcPCT = -5.0;
                        this.printOut("WARNING : current GCTime previous GCTime are less than zero");
                    }
                    if (currGCCollections > 0.0 && prevGCCollections > 0.0) {
                        gcCollections = currGCCollections - prevGCCollections;
                    } else {
                        gcCollections = -5.0;
                        this.printOut("WARNING : current GC collections previous GC collections are less than zero");
                    }
                    if (gcTime == -5.0 && gcCollections == 0.0) {
                        gcTime = 0.0;
                    }
                    if (EgTest.debug) {
                        this.printOut(" gcTime ======>" + gcTime);
                        this.printOut(" gcPCT ======>" + gcPCT);
                        this.printOut(" gcCollections ======>" + gcCollections);
                    }
                    ArrayList<Double> measurelist = new ArrayList<Double>();
                    measurelist.add(new Double(gcTime));
                    measurelist.add(new Double(gcPCT));
                    measurelist.add(new Double(gcCollections));
                    if (EgTest.debug) {
                        this.printOut(" key1====>" + key + " value1===>" + measurelist);
                    }
                    this.addNewMeasure(key, measurelist);
                    continue;
                }
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                if (EgTest.debug) {
                    this.printOut("NotAvaliablevalue key==>" + key + " value===>" + al);
                }
                this.addNewMeasure(key, al);
            }
            this.prevhash = currHashtable;
            if (EgTest.debug) {
                this.printOut(" previoushash======>" + this.prevhash);
            }
        }
    }

    public static void main(String[] args) {
        IIBJVMGCTest obj = new IIBJVMGCTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

