/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpAccessLogHelper {
    public static HttpAccessLog HttpLogFormat(String string, String string2, String string3) {
        HttpAccessLog httpAccessLog = null;
        try {
            if (string == null || string.trim().length() <= 0 || string2 == null || string2.trim().length() <= 0) {
                return httpAccessLog;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = "(\\[.+?\\]|[^\"]\\S*|\".+?\")\\s*";
            Matcher matcher = Pattern.compile(string4).matcher(string);
            while (matcher.find()) {
                arrayList.add(matcher.group(1));
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            matcher = Pattern.compile(string4).matcher(string2);
            while (matcher.find()) {
                arrayList2.add(matcher.group(1));
            }
            if (arrayList.size() != arrayList2.size()) {
                System.out.println("[HttpAccessLogHelper] valueTokens.size(): " + arrayList.size() + ", formatTokens.size(): " + arrayList2.size());
                System.out.println("[HttpAccessLogHelper] String and format does not match. Skipping: " + string + ", format: " + string2);
                return httpAccessLog;
            }
            StringTokenizer stringTokenizer = null;
            String string5 = null;
            httpAccessLog = new HttpAccessLog();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string6 = (String)arrayList.get(i);
                if (string6 == null || string6.trim().length() == 0) continue;
                string6 = string6.trim();
                String string7 = (String)arrayList2.get(i);
                if ((string7 = string7.trim()).endsWith("\\")) {
                    string7 = string7.substring(0, string7.length() - 1);
                }
                string7 = string7.trim();
                try {
                    if (string7.equals("%h")) {
                        httpAccessLog.setRemoteHost(string6);
                        continue;
                    }
                    if (string7.equals("%H")) {
                        httpAccessLog.setProtocol(string6);
                        continue;
                    }
                    if (string7.equals("%f")) {
                        httpAccessLog.setFileName(string6);
                        continue;
                    }
                    if (string7.equals("%l")) {
                        httpAccessLog.setRemoteLogName(string6);
                        continue;
                    }
                    if (string7.equals("%u")) {
                        httpAccessLog.setRemoteUser(string6);
                        continue;
                    }
                    if (string7.equals("%U")) {
                        httpAccessLog.setUrlPath(string6);
                        continue;
                    }
                    if (string7.equals("%m")) {
                        httpAccessLog.setMethod(string6);
                        continue;
                    }
                    if (string7.equals("%v")) {
                        httpAccessLog.setServerName(string6);
                        continue;
                    }
                    if (string7.equals("%V")) {
                        httpAccessLog.setServerIP(string6);
                        continue;
                    }
                    if (string7.equals("%p")) {
                        httpAccessLog.setServerPort(HttpAccessLogHelper.getIntValue(string6));
                        continue;
                    }
                    if (string7.equals("%q")) {
                        httpAccessLog.setUrlQuery(string6);
                        continue;
                    }
                    if (string7.equals("%P")) {
                        httpAccessLog.setProcessID(HttpAccessLogHelper.getIntValue(string6));
                        continue;
                    }
                    if (string7.equals("%T") || string7.indexOf("%T") > 0) {
                        double d = -5.0;
                        if (string7.equals("%T")) {
                            d = HttpAccessLogHelper.getIntValue(string6);
                        } else {
                            stringTokenizer = new StringTokenizer(string6, string3);
                            while (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                            }
                            if (string5 != null && string5.trim().length() > 0) {
                                d = HttpAccessLogHelper.getIntValue(string5);
                            }
                        }
                        if (d > 0.0) {
                            d *= 1000.0;
                        }
                        httpAccessLog.setTimeTaken(d);
                        continue;
                    }
                    if (string7.equals("%D") || string7.indexOf("%D") > 0) {
                        double d = -5.0;
                        if (string7.equals("%D")) {
                            d = HttpAccessLogHelper.getIntValue(string6);
                        } else {
                            stringTokenizer = new StringTokenizer(string6, string3);
                            while (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                            }
                            if (string5 != null && string5.trim().length() > 0) {
                                d = HttpAccessLogHelper.getIntValue(string5);
                            }
                        }
                        if (d > 0.0) {
                            d /= 1000.0;
                        }
                        httpAccessLog.setTimeTaken(d);
                        continue;
                    }
                    if (string7.equals("%I")) {
                        httpAccessLog.setReceivedBytes(HttpAccessLogHelper.getDoubleValue(string6));
                        continue;
                    }
                    if (string7.equals("%O")) {
                        httpAccessLog.setBytesSent(HttpAccessLogHelper.getDoubleValue(string6));
                        continue;
                    }
                    if (string7.equals("%t")) {
                        if (string6.startsWith("[")) {
                            string6 = string6.substring(1);
                        }
                        if (string6.endsWith("]")) {
                            string6 = string6.substring(0, string6.length() - 1);
                        }
                        httpAccessLog.setDateTimeString(string6);
                        continue;
                    }
                    if (string7.equals("\\\"%r\\\"") || string7.equals("%r") || string7.equals("\"%r\"")) {
                        string6 = HttpAccessLogHelper.removeDoubleQuotes(string6);
                        httpAccessLog.setFirstLine(string6);
                        continue;
                    }
                    if (string7.equals("%>s") || string7.equals("%s")) {
                        httpAccessLog.setHTTPStatus(HttpAccessLogHelper.getDoubleValue(string6));
                        continue;
                    }
                    if (string7.equals("%b")) {
                        try {
                            if (string6.equals("-")) continue;
                            double d = Double.parseDouble(string6);
                            if (d > 0.0) {
                                d /= 1024.0;
                            }
                            httpAccessLog.setTotResponseSize(d);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (string7.equalsIgnoreCase("\\\"%{Referer}i\\\"") || string7.equalsIgnoreCase("%{Referer}i") || string7.equalsIgnoreCase("\"%{Referer}i\"")) {
                        string6 = HttpAccessLogHelper.removeDoubleQuotes(string6);
                        httpAccessLog.setReferer(string6);
                        continue;
                    }
                    if (string7.equalsIgnoreCase("\\\"%{User-agent}i\\\"") || string7.equalsIgnoreCase("%{User-agent}i") || string7.equalsIgnoreCase("\"%{User-agent}i\"")) {
                        string6 = HttpAccessLogHelper.removeDoubleQuotes(string6);
                        httpAccessLog.setUserAgent(string6);
                        continue;
                    }
                    System.out.println("[HttpAccessLogHelper] Unexpected tokFormat: " + string7 + ", tokValue: " + string6);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("[HttpAccessLogHelper] HttpLogFormat(-,-) line: " + string + ", format: " + string2);
                    System.out.println("[HttpAccessLogHelper] HttpLogFormat(-,-) Error while populating above format and line, " + numberFormatException);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpAccessLog;
    }

    public static String removeDoubleQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "-";
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static int getIntValue(String string) {
        int n = -5;
        if (string == null || string.trim().length() == 0) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -5;
        }
        return n;
    }

    public static double getDoubleValue(String string) {
        double d = -5.0;
        if (string == null || string.trim().length() == 0) {
            return d;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public static boolean isExclude(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        boolean bl = Pattern.compile(string2).matcher(string).find();
        return bl;
    }
}

