/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class HdpNNUptimeTest
extends HadoopBase {
    double prevValue = 0.0;
    double diffuptime = 0.0;
    double rebooted = 0.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private boolean isReportMgrTime = true;
    private String installdir = "";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private String reportMgrTime = new String("");
    public ArrayList ddNNUptimeList = new ArrayList();
    private boolean isFirstTime = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdpNNUptimeTest(String[] stringArray) {
        super(stringArray);
        this.installdir = EgInstallInfo.getInstallDir() + "/agent/logs/HadoopNameNodeUptime_" + this.targetHost + "_" + this.portNo + ".log";
        this.f = new File(this.installdir);
        this.fixedTestPeriod = true;
        this.reportMgrTime = this.getValueForParam("reportmanagertime");
        this.isReportMgrTime = this.reportMgrTime == null || !this.reportMgrTime.equalsIgnoreCase("no") && !this.reportMgrTime.equalsIgnoreCase("false");
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.needAgentlessDD = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = "[computeMeasures] : ";
            String string2 = this.getJSONDataFromURL("jmx", this.targetHost, this.nameNodeWebPortNo, this.userNameNN);
            if (string2 == null || string2.trim().length() == 0) {
                this.logMessage = string + "Response for method is null or empty ,Could not proceed further ,So test returning";
                this.printOut(this.logMessage, debug);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            Hashtable hashtable2 = this.getNameNodeDataTest(string2);
            System.out.println(this.entity + " getMeasureDataHash::" + hashtable2);
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (int i = 0; i < this.measureCount; ++i) {
                    arrayList.add(new Double(-5.0));
                }
                this.addNewMeasure(arrayList);
                this.logMessage = string + "getMeasureDataHash is empty, passing default measures ";
                this.printOut(this.logMessage, debug);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            double d = -5.0;
            double d2 = 0.0;
            double[] dArray = new double[1];
            long l = this.f.lastModified();
            String string3 = "";
            String string4 = "";
            String string5 = "";
            ArrayList<Double> arrayList = new ArrayList<Double>();
            double d3 = 5.0;
            double d4 = -5.0;
            String string6 = "";
            if (hashtable2.containsKey("Uptime")) {
                string3 = (String)hashtable2.get("Uptime");
                double d5 = this.getDoubleValue(string3);
                d = d5 / 1000.0;
            }
            if (hashtable2.containsKey("State")) {
                string4 = (String)hashtable2.get("State");
                if (string4.equalsIgnoreCase("standby") || string4.equalsIgnoreCase("stopping")) {
                    d3 = 0.0;
                } else if (string4.equalsIgnoreCase("initializing")) {
                    d3 = 1.0;
                } else if (string4.equalsIgnoreCase("active")) {
                    d3 = 2.0;
                }
            }
            if (hashtable2.containsKey("FSState")) {
                string5 = (String)hashtable2.get("FSState");
                if (string5.equalsIgnoreCase("safemode")) {
                    d4 = 0.0;
                }
                if (string5.equalsIgnoreCase("Operational")) {
                    d4 = 1.0;
                }
            }
            dArray[0] = d;
            if (this.isFirstTime) {
                this.isFirstTime = false;
                d = dArray[0];
                this.writeDoubleToFile(d);
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                d2 = d / 60.0;
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                this.addNewMeasure(arrayList);
            } else {
                d = dArray[0];
                this.prevValue = this.readDoubleFromFile();
                if (d < this.prevValue) {
                    long l2;
                    arrayList.add(new Double(1.0));
                    arrayList.add(new Double(d));
                    d2 = d / 60.0;
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    this.addNewMeasure(arrayList);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    Date date = null;
                    long l3 = 0L;
                    long l4 = 0L;
                    String string7 = "";
                    String string8 = "";
                    long l5 = System.currentTimeMillis();
                    if (this.isReportMgrTime) {
                        l2 = l5 - l;
                        l3 = dateInfo.egetUTCDate() - l2;
                        string7 = dateInfo.egetDate(l3);
                        l4 = dateInfo.egetUTCDate() - (long)d * 1000L;
                        string8 = dateInfo.egetDate(l4);
                    } else {
                        l3 = l;
                        date = new Date(l3);
                        string7 = simpleDateFormat.format(date);
                        l4 = l5 - (long)d * 1000L;
                        date = new Date(l4);
                        string8 = simpleDateFormat.format(date);
                    }
                    l2 = l4 - l3;
                    System.out.println(this.entity + " this is down duration" + l2);
                    if (l2 > 0L) {
                        double d6 = (double)l2 / 1000.0 / 60.0;
                        String string9 = "No";
                        if (this.checkMaintenance()) {
                            string9 = "Yes";
                        }
                        string6 = string7 + fieldSep + string8 + fieldSep + this.round(d6, 4) + fieldSep + string9;
                        this.ddNNUptimeList.add(string6);
                    }
                } else {
                    this.diffuptime = d - this.prevValue;
                    d2 = d / 60.0;
                    arrayList.add(new Double(0.0));
                    arrayList.add(new Double(this.diffuptime));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    this.addNewMeasure(arrayList);
                }
            }
            this.writeDoubleToFile(d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
        }
    }

    private Hashtable getNameNodeDataTest(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Object var2_2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "[getNameNodeDataTest] : ";
        String string3 = null;
        String string4 = null;
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"beans");
            JSONObject jSONObject2 = null;
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject2 = (JSONObject)jSONArray.get(i);
                string3 = this.getValueFromJSONObject(jSONObject2, "name");
                if (string3.equalsIgnoreCase("java.lang:type=Runtime")) {
                    string4 = this.getValueFromJSONObject(jSONObject2, "Uptime");
                    System.out.println("UPTIME::" + string4);
                    hashtable.put("Uptime", string4);
                    bl = true;
                }
                if (string3.equalsIgnoreCase("Hadoop:service=NameNode,name=FSNamesystemState")) {
                    string5 = this.getValueFromJSONObject(jSONObject2, "FSState");
                    System.out.println("fileSystemState::" + string5);
                    hashtable.put("FSState", string5);
                    bl2 = true;
                }
                if (string3.equalsIgnoreCase("Hadoop:service=NameNode,name=NameNodeStatus")) {
                    string6 = this.getValueFromJSONObject(jSONObject2, "State");
                    System.out.println("nameNodeState::" + string6);
                    hashtable.put("State", string6);
                    bl3 = true;
                }
                if (!(bl && bl2 && bl3)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception happened while  parsing the outputs :";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string2 + "  Output Hashtable :" + hashtable);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile(double d) {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {}
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readDoubleFromFile() {
        double d = 0.0;
        try {
            if (!this.f.exists()) {
                double d2 = -5.0;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dis.close();
            }
            catch (Exception exception) {}
            this.dis = null;
        }
        return d;
    }

    public void freeTest() {
        this.ddNNUptimeList = new ArrayList();
    }

    public static void main(String[] stringArray) {
        HdpNNUptimeTest hdpNNUptimeTest = new HdpNNUptimeTest(stringArray);
        hdpNNUptimeTest.computeMeasures(new Hashtable());
    }
}

