/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.EgManagerObject;
import com.eg.EgTesterInfo;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Vector;

class EgVmAgentThread
extends Thread {
    public int connTimeOut = 10000;
    public long reconnectTimePeriod = 21600000L;
    public boolean isConnected = false;
    private int vmAgentPort = 60001;
    private Socket vmAgent;
    private Vector aListAvailVmAgents = new Vector();
    private ObjectOutputStream vmAgentOutStream;
    private EgManagerObject managerObject = null;
    static String strSyc = new String("managerObject");
    static String strSycMainAgent = new String("MainAgentObject");
    static EgVmAgentThread thread = null;
    EgMainAgent parentObj = null;

    private EgVmAgentThread() {
    }

    public static EgVmAgentThread getInstance() {
        if (thread == null) {
            thread = new EgVmAgentThread();
        }
        return thread;
    }

    public void setVmAgentPort(int n) {
        this.vmAgentPort = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagerObject(EgManagerObject egManagerObject) {
        String string = strSyc;
        synchronized (string) {
            this.managerObject = egManagerObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainAgent(EgMainAgent egMainAgent) {
        String string = strSycMainAgent;
        synchronized (string) {
            this.parentObj = egMainAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVmAgents(Vector vector) {
        String string = strSyc;
        synchronized (string) {
            if (vector != null && vector.size() > 0) {
                this.aListAvailVmAgents = (Vector)vector.clone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getVmAgents() {
        String string = strSyc;
        synchronized (string) {
            if (this.aListAvailVmAgents != null && this.aListAvailVmAgents.size() > 0) {
                return (Vector)this.aListAvailVmAgents.clone();
            }
            return null;
        }
    }

    private void prepareManagerObject() {
        if (this.parentObj != null) {
            String string = EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + "/final/servlet";
            boolean bl = false;
            if (EgMainAgent.sslFlag != null) {
                if (EgMainAgent.sslFlag.equalsIgnoreCase("true")) {
                    bl = true;
                }
            }
            this.managerObject = new EgManagerObject(EgMainAgent.mgrIp, EgMainAgent.isAuthenticationRequired, this.parentObj.highSecurity, EgMainAgent.isProxySet, bl, EgMainAgent.isEncryptionRequired, string, EgMainAgent.proxyHost, EgMainAgent.proxyPort, EgMainAgent.proxyUsername, EgMainAgent.proxyPassword);
        } else {
            this.managerObject = null;
        }
    }

    public void run() {
        Vector vector = null;
        while (true) {
            this.vmAgentPort = (int)EgMainAgent.WmiInsideViewPort;
            EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
            String string = egTesterInfo.getValueFor("AGENT_SETTINGS", "VmAgentsReconnectPeriod");
            if (string != null && string.length() > 0) {
                try {
                    this.reconnectTimePeriod = Long.parseLong(string) * 1000L;
                }
                catch (Exception exception) {
                    this.reconnectTimePeriod = 21600000L;
                }
            }
            egTesterInfo = null;
            try {
                vector = this.getVmAgents();
                if (vector != null && vector.size() > 0) {
                    this.prepareManagerObject();
                    if (this.managerObject != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            try {
                                String string2 = (String)vector.get(i);
                                this.connectToVmAgent(string2, this.vmAgentPort, this.connTimeOut);
                                if (this.isConnected && this.openStreams()) {
                                    this.sendManagerInfo();
                                }
                                this.closeAll();
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                try {
                                    this.closeAll();
                                    continue;
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                }
                            }
                        }
                    }
                    this.threadSleep(this.reconnectTimePeriod);
                    continue;
                }
                this.threadSleep(300000L);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.threadSleep(this.reconnectTimePeriod);
                continue;
            }
            break;
        }
    }

    private void connectToVmAgent(String string, int n, int n2) {
        try {
            int n3 = n2 / 2;
            if (n3 < 1000) {
                n3 = 1000;
            }
            this.vmAgent = new Socket(string, n);
            this.vmAgent.setSoTimeout(n3);
            this.isConnected = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isConnected = false;
        }
    }

    private boolean openStreams() {
        try {
            if (this.isConnected) {
                this.vmAgentOutStream = new ObjectOutputStream(this.vmAgent.getOutputStream());
                if (this.vmAgentOutStream != null) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void sendManagerInfo() {
        try {
            if (this.isConnected) {
                this.vmAgentOutStream.writeUTF("ManagerInfo:" + this.managerObject.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void closeAll() throws Exception {
        if (this.vmAgentOutStream != null) {
            this.vmAgentOutStream.close();
            this.vmAgentOutStream = null;
        }
        if (this.vmAgent != null) {
            this.vmAgent.close();
            this.vmAgent = null;
        }
    }

    public void threadSleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        EgManagerObject egManagerObject = new EgManagerObject("192.168.10.79", false, false, false, false, false, "http://192.168.10.79:911/final/servlet", "none", "none", "none", "none");
        Vector<String> vector = new Vector<String>();
        vector.add("192.168.10.79");
        EgVmAgentThread egVmAgentThread = EgVmAgentThread.getInstance();
        egVmAgentThread.setManagerObject(egManagerObject);
        egVmAgentThread.setVmAgents(vector);
        egVmAgentThread.start();
    }
}

