/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class EgSybMonitorInstaller {
    private String host = "";
    private String port = "";
    private String user = "sa";
    private String pwd = "";
    private String newUser = "";
    private String newPwd = "";
    private boolean newUserCreation = false;
    private boolean newDatabaseCreation = false;
    private String file = "";
    private String name = "sp_egmonitor";
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private String procDatabase = "";
    private String device = "master";
    private int dbSize = 30;

    public EgSybMonitorInstaller(String string) {
        this.file = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Object object;
        String string = "";
        if (stringArray == null) return;
        if (stringArray.length != 1) return;
        String string2 = "";
        string = stringArray[0];
        int n = string.indexOf("lib");
        if (n >= 0) {
            object = string.substring(0, n - 1);
            EgInstallInfo.setInstallDir((String)object);
        }
        object = null;
        try {
            EgSybMonitorInstaller egSybMonitorInstaller = new EgSybMonitorInstaller(string.trim());
            object = new BufferedReader(new InputStreamReader(System.in));
            egSybMonitorInstaller.getInputs((BufferedReader)object);
            boolean bl = egSybMonitorInstaller.getNewdataBaseInputs((BufferedReader)object);
            if (!bl) {
                System.err.println("Please provide valid inputs ");
                return;
            }
            egSybMonitorInstaller.getNewUserInputs((BufferedReader)object);
            if (egSybMonitorInstaller.newDatabaseCreation && !egSybMonitorInstaller.createDB(egSybMonitorInstaller.procDatabase, egSybMonitorInstaller.device, egSybMonitorInstaller.dbSize)) {
                System.out.println("database " + egSybMonitorInstaller.procDatabase);
                System.out.println("device " + egSybMonitorInstaller.device);
                System.out.println("size  " + egSybMonitorInstaller.dbSize);
                System.err.println("Database Creation failed... Exiting the configuration ");
                return;
            }
            String string3 = EgInstallInfo.getInstallDir() + "/agent/config/eg_sybase.ini";
            IniFile iniFile = new IniFile(string3, true);
            iniFile.setValue("EG_SYBASE", "DB_NAME", egSybMonitorInstaller.procDatabase);
            iniFile.saveFile();
            if (egSybMonitorInstaller.newUserCreation) {
                System.out.println("\nCreating new user..\n");
                if (!egSybMonitorInstaller.createNewUser(egSybMonitorInstaller.newUser, egSybMonitorInstaller.newPwd, egSybMonitorInstaller.procDatabase)) {
                    System.err.println("User creation step has failed.");
                    return;
                }
                System.out.println("\nThe user has been created successfully in the database.");
                System.out.println("Please use this user name and password to configure the Sybase related tests \nusing the eG Admin UI.");
            }
            if (!egSybMonitorInstaller.install()) {
                System.out.println("eG Sybase monitor procedure installation step has failed.");
                return;
            }
            System.out.println("eG Sybase setup completed successfully!!!");
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            try {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean createDB(String string, String string2, int n) {
        SybConnection sybConnection = this.getConnection(this.host, this.port, this.user, this.pwd);
        SybStatement sybStatement = null;
        if (sybConnection == null) {
            return false;
        }
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || n <= 0) {
            System.out.println("dbName is " + string);
            System.out.println("device " + string2);
            System.out.println("Size is " + n);
            System.err.println("Invalid inputs. Please check Database name or Device or size");
            return false;
        }
        String string3 = "create database " + this.procDatabase + " on " + string2 + "=" + n;
        System.out.println("query to create database is " + string3);
        try {
            sybStatement = (SybStatement)sybConnection.createStatement();
            sybStatement.executeUpdate(string3);
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
        }
        catch (Exception exception) {
            System.err.println("Invalid inputs. Please check Database name or Device or size");
            exception.printStackTrace();
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean install() {
        boolean bl;
        block20: {
            bl = false;
            String string = this.readQueryFromFile(this.file, "sp_egmonitor");
            String string2 = this.readQueryFromFile(this.file, "sp_eglockdetails");
            String string3 = this.readQueryFromFile(this.file, "sp_egmonitor_dd");
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            SybConnection sybConnection = null;
            SybStatement sybStatement = null;
            try {
                sybConnection = this.newDatabaseCreation || !this.procDatabase.equalsIgnoreCase("master") ? this.getConnection(this.host, this.port, this.user, this.pwd, true) : this.getConnection(this.host, this.port, this.user, this.pwd);
                if (sybConnection == null) {
                    boolean bl2 = false;
                    this.closeStmt(sybStatement);
                    this.closeConn(sybConnection);
                    return bl2;
                }
                sybStatement = (SybStatement)sybConnection.createStatement();
                String string4 = "if exists (select * from tempdb.dbo.sysobjects where name = 'egtempmonitor')\n";
                string4 = string4 + "begin\n";
                string4 = string4 + "drop table tempdb.dbo.egtempmonitor";
                string4 = string4 + "\nend";
                try {
                    sybStatement.executeUpdate(string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string5 = "create table tempdb.dbo.egtempmonitor(field_name char(79),group_name char(25),value int)";
                try {
                    sybStatement.executeUpdate(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("\nInstalling the procedure sp_egmonitor...");
                String string6 = "";
                try {
                    string6 = this.getProcDropQuery("sp_egmonitor", this.procDatabase);
                    sybStatement.executeUpdate(this.getProcDropQuery("sp_egmonitor", this.procDatabase));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sybStatement.executeUpdate(string);
                System.out.println("Granting permissions..");
                sybStatement.executeUpdate("grant all on sp_egmonitor to sa_role");
                System.out.println("\nInstalling the procedure sp_eglockdetails...");
                try {
                    sybStatement.executeUpdate(this.getProcDropQuery("sp_eglockdetails", this.procDatabase));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sybStatement.executeUpdate(string2);
                System.out.println("Granting permissions..");
                sybStatement.executeUpdate("grant all on sp_eglockdetails to sa_role");
                System.out.println("\nInstalling the procedure sp_egmonitor_dd...");
                try {
                    sybStatement.executeUpdate(this.getProcDropQuery("sp_egmonitor_dd", this.procDatabase));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sybStatement.executeUpdate(string3);
                System.out.println("Granting permissions..");
                sybStatement.executeUpdate("grant all on sp_egmonitor_dd to sa_role");
                bl = true;
                this.closeStmt(sybStatement);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
                break block20;
            }
            catch (Exception exception) {
                boolean bl3 = false;
                return bl3;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeStmt(sybStatement);
                this.closeConn(sybConnection);
            }
            this.closeConn(sybConnection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean createNewUser(String string, String string2, String string3) {
        SybStatement sybStatement;
        SybConnection sybConnection;
        boolean bl;
        block7: {
            bl = false;
            sybConnection = this.getConnection(this.host, this.port, this.user, this.pwd);
            sybStatement = null;
            if (sybConnection != null) break block7;
            boolean bl2 = false;
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
            return bl2;
        }
        try {
            sybStatement = (SybStatement)sybConnection.createStatement();
            String string4 = "sp_addlogin " + string + "," + this.newPwd + "," + string3;
            sybStatement.executeUpdate(string4);
            string4 = "sp_role 'grant',sa_role," + string;
            sybStatement.executeUpdate(string4);
            string4 = "sp_role 'grant',sybase_ts_role," + string;
            sybStatement.executeUpdate(string4);
            bl = true;
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
        }
        catch (SQLException sQLException) {
            bl = false;
            System.out.println(sQLException.getMessage());
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
            this.closeStmt(sybStatement);
            this.closeConn(sybConnection);
            {
                catch (Throwable throwable) {
                    this.closeStmt(sybStatement);
                    this.closeConn(sybConnection);
                    throw throwable;
                }
            }
        }
        return bl;
    }

    private String getProcDropQuery(String string, String string2) {
        if (string2.equalsIgnoreCase("master")) {
            String string3 = "if exists (select * from master.dbo.sysobjects where name = '" + string + "')\n";
            string3 = string3 + "begin\n";
            string3 = string3 + "drop procedure " + string;
            string3 = string3 + "\nend";
            return string3;
        }
        String string4 = "if exists (select * from " + string2 + ".dbo.sysobjects where name = '" + string + "')\n";
        string4 = string4 + "begin\n";
        string4 = string4 + "use " + string2 + "\n";
        string4 = string4 + "drop procedure " + string;
        string4 = string4 + "\nend";
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readQueryFromFile(String string, String string2) {
        String string3 = "";
        String string4 = "/*" + string2 + ":start";
        String string5 = "/*" + string2 + ":end";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            String string6 = "";
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.startsWith(string5)) {
                    bl = false;
                    break;
                }
                if (bl) {
                    stringBuffer.append(string6);
                    stringBuffer.append("\n");
                }
                if (!string6.startsWith(string4)) continue;
                bl = true;
            }
            string3 = stringBuffer.toString();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        return this.getConnection(string, string2, string3, string4, false);
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, boolean bl) {
        SybConnection sybConnection = null;
        try {
            Class.forName(this.driver);
            String string5 = "";
            string5 = bl ? "jdbc:sybase:Tds:" + string + ":" + string2 + "/" + this.procDatabase + "" : "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", "iso_1");
            sybConnection = (SybConnection)DriverManager.getConnection(string5, properties);
        }
        catch (Exception exception) {
            String string6 = exception.toString();
            if (string6.indexOf("java.net.ConnectException") >= 0) {
                System.out.println("\nConnection could not be established with the Sybase Adaptive server.\n");
            } else if (string6.indexOf("java.sql.SQLException") >= 0 && string6.indexOf("Login failed") >= 0) {
                System.out.println("\nLogin failed. Please enter the correct password for sa user.\n");
            } else if (string6.indexOf("Incorrect URL format") >= 0) {
                System.out.println("\nIncorrect URL format. Please enter the correct IP address and port number.\n");
            }
            exception.printStackTrace();
        }
        return sybConnection;
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getInputs(BufferedReader bufferedReader) {
        try {
            System.out.println("\nPlease enter the details of Sybase Adaptive server which is running\non this machine.\n");
            System.out.print("IP address\t\t: ");
            this.host = bufferedReader.readLine();
            System.out.print("Port number\t\t: ");
            this.port = bufferedReader.readLine();
            this.pwd = this.getPassword("Password for sa login\t: ");
            System.out.println("host is " + this.host);
            System.out.println("port is " + this.port);
            System.out.println("pwd is " + this.pwd);
            System.out.println("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getNewdataBaseInputs(BufferedReader bufferedReader) {
        try {
            System.out.print("\nDo you want me to create a new database to store eG System procedures and Tables? [y/n]:");
            String string = bufferedReader.readLine();
            this.newDatabaseCreation = string.equalsIgnoreCase("y");
            if (this.newDatabaseCreation) {
                System.out.println("\nPlease enter the new Database Name.: ");
                this.procDatabase = bufferedReader.readLine();
                System.out.println("\nPlease enter the device name for the new Database Name..[DEFAULT='default'] :");
                this.device = bufferedReader.readLine();
                if (this.device == null || this.device.trim().length() == 0) {
                    this.device = "default";
                }
                System.out.println("\nPlease enter the size of the database in MB without units  [DEFAULT=30] :");
                String string2 = "";
                string2 = bufferedReader.readLine();
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = "30";
                }
                this.dbSize = Integer.parseInt(string2);
            } else {
                System.out.println("\nPlease enter the Existing Database Name you wish to use .[DEFAULT=master] :");
                this.procDatabase = bufferedReader.readLine();
            }
            System.out.println("the New Database Name is :" + this.procDatabase);
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error getting user inoputs for database creation " + exception.toString());
            return false;
        }
    }

    private void getNewUserInputs(BufferedReader bufferedReader) {
        try {
            System.out.println("To monitor a Sybase Adaptive server, the eG Agent requires a user account \nwith the sa_role and sybase_ts_role privileges");
            System.out.print("\nDo you want me to create a user with sa_role and sybase_ts_role privileges\nin the database? [y/n]:");
            String string = bufferedReader.readLine();
            if (string.equalsIgnoreCase("y")) {
                this.newUserCreation = true;
            }
            if (this.newUserCreation) {
                boolean bl = false;
                while (true) {
                    if (bl) {
                        System.out.println("\nPlease reenter the user details.\n");
                    } else {
                        System.out.println("\nPlease enter the new user details.\n");
                    }
                    System.out.print("User\t\t: ");
                    this.newUser = bufferedReader.readLine();
                    this.newPwd = this.getPassword("Password\t: ");
                    if (this.newPwd.length() < 6) {
                        System.out.println("\nThe specified password is too short. Passwords must be at least 6 character(s) long.");
                        bl = true;
                        continue;
                    }
                    String string2 = this.getPassword("Retype password\t: ");
                    if (!this.newPwd.equals(string2)) {
                        System.out.println("\nPasswords do not match.");
                        bl = true;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getPassword(String string) {
        EgHider egHider = new EgHider(System.out, string);
        egHider.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        egHider.interrupt();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string2;
    }

    class EgHider
    extends Thread {
        PrintStream out;
        boolean finish = false;

        public EgHider(PrintStream printStream, String string) {
            this.out = printStream;
            printStream.print(string + "   ");
        }

        public void run() {
            while (!this.finish) {
                this.out.print("\b\b\b   ");
                try {
                    EgHider.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    this.finish = true;
                }
            }
        }
    }
}

