/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class EgNfsCheck {
    long timeout = 30000L;
    static String filesystem = "/etc/filesystems";

    public EgNfsCheck(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("-timeout")) continue;
                String string = stringArray[i + 1];
                try {
                    this.timeout = Long.parseLong(string);
                    this.timeout *= 1000L;
                    continue;
                }
                catch (Exception exception) {
                    this.timeout = 30000L;
                }
            }
        }
    }

    public ArrayList getNfsDirs() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(filesystem));
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bufferedReader != null) {
                String string = "";
                String string2 = "";
                while ((string = bufferedReader.readLine()) != null) {
                    int n;
                    if (string == null || string.trim().length() == 0) continue;
                    if ((string = string.trim()).startsWith("/") && string.endsWith(":")) {
                        string2 = string.substring(0, string.length() - 1);
                    }
                    if (string2.trim().length() <= 0 || !string.startsWith("vfs") || !string.endsWith("nfs") || (n = string.indexOf("=")) < 0) continue;
                    String string3 = string.substring(0, n).trim();
                    String string4 = string.substring(n + 1).trim();
                    if (!string3.equalsIgnoreCase("vfs") || !string4.equalsIgnoreCase("nfs")) continue;
                    arrayList.add(string2);
                    string2 = "";
                }
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        EgNfsCheck egNfsCheck = new EgNfsCheck(stringArray);
        egNfsCheck.checkNfs();
        System.exit(-1);
        Runtime.getRuntime().halt(1);
    }

    public ArrayList checkNfs() {
        long l = this.timeout;
        ArrayList arrayList = this.getNfsDirs();
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            DirExistThread dirExistThread = new DirExistThread(string, this.timeout);
            long l2 = 1000L;
            int n = 0;
            while ((long)n < l) {
                try {
                    Thread.sleep(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dirExistThread.done) break;
                n = (int)((long)n + l2);
            }
            arrayList2.add(string + "?" + dirExistThread.fileExist + "?" + dirExistThread.respTime);
            System.out.println("eG=" + string + " " + dirExistThread.fileExist + " " + dirExistThread.respTime);
        }
        System.out.println("Nfs eG done!");
        return arrayList2;
    }
}

