/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ESIndexingTest
extends ElasticSearchBase {
    Hashtable indexRateTable = new Hashtable();
    Hashtable indexedDocTable = new Hashtable();
    Hashtable deletedDocTable = new Hashtable();
    Hashtable refreshTimeTable = new Hashtable();
    Hashtable refreshCountTable = new Hashtable();
    Hashtable mergeTimeTable = new Hashtable();
    Hashtable mergeCountTable = new Hashtable();
    Hashtable flushTimeTable = new Hashtable();
    Hashtable flushCountTable = new Hashtable();
    Hashtable statusReportTable = new Hashtable();
    Hashtable statusMsgReportTable = new Hashtable();
    boolean firstTime = false;
    DecimalFormat formatter = new DecimalFormat("##");
    DecimalFormat formatter2 = new DecimalFormat("##.##");
    DecimalFormat formatter3 = new DecimalFormat("##.###");

    public ESIndexingTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info(this.logPrefix + " Initializing ElasticSearchIndexingTest ...");
            this.setMeasureCount(this.measureCount);
            logger.info(this.logPrefix + " ElasticSearchIndexingTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing ElasticSearchIndexingTest", (Throwable)exception);
        }
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block19: {
            this.statusReportTable = new Hashtable();
            this.statusMsgReportTable = new Hashtable();
            try {
                Object object;
                logger.debug(this.logPrefix + " ElasticSearchIndexingTest - Test cycle START ");
                String string = this.getElasticSearchRestURLForTest(this.entity);
                logger.debug(this.logPrefix + " [computeMeasures] the URL is :" + string);
                String string2 = this.getMoreThanOneJson(string);
                logger.debug(this.logPrefix + " [computeMeasures] the JSON Data is :" + string2);
                Configuration configuration = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
                ArrayList arrayList = null;
                if (string2 != null && string2.length() > 4) {
                    try {
                        arrayList = (ArrayList)JsonPath.using((Configuration)configuration).parse(string2).read("$['indices'].* ", new Predicate[0]);
                        arrayList.add("$['_all']");
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        logger.debug(this.logPrefix + " [computeMeasures] No indices found");
                        logger.debug(this.logPrefix + " ElasticSearchIndexingTest - Test cycle END ");
                        return;
                    }
                    catch (Exception exception) {
                        logger.warn(this.logPrefix + " [computeMeasures] Unable to get JSON paths from JSON Data" + exception.getMessage() + exception.getCause());
                        logger.debug(this.logPrefix + " ElasticSearchIndexingTest - Test cycle END ");
                        return;
                    }
                } else {
                    logger.warn(this.logPrefix + " [computeMeasures] JSON data is NULL or Empty.  jsonData : " + string2);
                    return;
                }
                Hashtable hashtable2 = this.jsonBuilder(string2, this.entity.toUpperCase() + "_JSONPATH", arrayList);
                Hashtable hashtable3 = this.getElasticIndexingDiscriptors(string2, hashtable2);
                Hashtable hashtable4 = this.getElasticSearchIndexMappingTable(this.entity.toUpperCase() + "_INDEX");
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                Iterator iterator = (Iterator)((Object)hashtable3.keys());
                boolean bl = false;
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (((String)object).equalsIgnoreCase("summary")) {
                        bl = true;
                        continue;
                    }
                    ArrayList arrayList2 = this.getESIndexingFinalMeasures((String)object, hashtable3, hashtable4, this.indexRateTable);
                    double d = (Double)arrayList2.get(0);
                    if (d == 0.0) {
                        ++n3;
                    }
                    if (d == 1.0) {
                        ++n2;
                    }
                    if (d == 2.0) {
                        ++n;
                    }
                    logger.info(this.logPrefix + "  [computeMeasures]  " + (String)object + " - measure contains \n" + arrayList2);
                    this.addNewMeasure((String)object, arrayList2);
                }
                if (hashtable3.size() > 0 && bl) {
                    object = this.getESIndexingFinalMeasures("Summary", hashtable3, hashtable4, this.indexRateTable);
                    ((ArrayList)object).set(2, new Double(n));
                    ((ArrayList)object).set(3, new Double(n2));
                    ((ArrayList)object).set(4, new Double(n3));
                    ((ArrayList)object).set(5, new Double(hashtable3.size() - 1));
                    this.addNewMeasure("Summary", (ArrayList)object);
                    bl = false;
                    logger.info(this.logPrefix + "  [computeMeasures]  Summary - measure contains \n" + object);
                }
                this.firstTime = false;
                break block19;
                {
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                logger.debug(this.logPrefix + " ElasticSearchIndexingTest - Test cycle END ");
            }
        }
    }

    public Hashtable getElasticIndexingDiscriptors(String string, Hashtable hashtable) {
        logger.debug(this.logPrefix + "  [getElasticIndexingDiscriptors]  jsonData :" + string);
        if (string.contains("|*|")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|*|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Iterator iterator = (Iterator)((Object)hashtable.keys());
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    Hashtable hashtable2 = (Hashtable)hashtable.get(string3);
                    Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                    while (iterator2.hasNext()) {
                        String string4 = (String)iterator2.next();
                        Object v = hashtable2.get(string4);
                        try {
                            Object object;
                            if (string2 != null && (object = JsonPath.read((String)string2, (String)v.toString(), (Predicate[])new Predicate[0])) != null) {
                                hashtable2.put(string4, object);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        hashtable.put(string3, hashtable2);
                    }
                }
            }
        }
        logger.debug(this.logPrefix + "  [getElasticIndexingDiscriptors]  The measure table after replacing the path with the values :\n" + hashtable);
        return hashtable;
    }

    public ArrayList getESIndexingFinalMeasures(String string, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        ArrayList arrayList = this.finalMeasures(this.measureCount);
        Hashtable hashtable4 = (Hashtable)hashtable.get(string);
        Iterator iterator = (Iterator)((Object)hashtable4.keys());
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -5.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = hashtable4.get(string2).toString();
            if (!hashtable2.containsKey(string2)) continue;
            int n = Integer.parseInt(hashtable2.get(string2).toString());
            try {
                double d12 = Double.parseDouble(string3);
                arrayList.set(n, new Double(d12));
                if (n == 1) {
                    if (this.firstTime) {
                        hashtable3.put(string, d12);
                        d = d12 / (double)this.measurePeriod * 1000.0;
                        logger.debug(this.logPrefix + "The index rate value per Measure Period is : \n(" + d12 + "/" + this.measurePeriod + ")*1000 = " + d);
                        arrayList.set(n, new Double(this.formatter2.format(d)));
                    } else {
                        Object v = hashtable3.get(string);
                        double d13 = 0.0;
                        if (v != null) {
                            d13 = (Double)v;
                        }
                        if (d13 <= d12) {
                            double d14 = d12 - d13;
                            logger.debug(this.logPrefix + " [getESIndexingFinalMeasures]  The index rate after difference between previous and current valu is \n:" + d12 + " - " + d13 + "=" + d14);
                            d = d14 / (double)this.measurePeriod * 1000.0;
                            logger.debug(this.logPrefix + "The index rate value per Measure Period is : \n(" + d14 + "/" + this.measurePeriod + ")*1000" + d);
                            arrayList.set(n, new Double(this.formatter2.format(d)));
                            hashtable3.put(string, d12);
                        } else {
                            hashtable3.put(string, d12);
                            d = d12 / (double)this.measurePeriod * 1000.0;
                            logger.debug(this.logPrefix + " [getESIndexingFinalMeasures]  The index rate value per Measure Period is :\n (" + d12 + "/" + this.measurePeriod + ")*1000" + d);
                            arrayList.set(n, new Double(this.formatter2.format(d)));
                        }
                    }
                } else if (n == 6) {
                    arrayList.set(n, new Double(Double.parseDouble(EgUtils.convertMemoryValues(string3, "B", "MB"))));
                } else if (n == 7) {
                    d2 = d12;
                    arrayList.set(n, new Double(d2));
                    d5 = this.getDifferenceValue(string, d12, "Deleted Document count ", this.indexedDocTable);
                } else if (n == 8) {
                    d3 = d12;
                    arrayList.set(n, new Double(d3));
                } else if (n == 9) {
                    d6 = this.getDifferenceValue(string, d12, "Refresh count ", this.refreshCountTable);
                    arrayList.set(n, new Double(d6));
                } else if (n == 10) {
                    d7 = this.getDifferenceValue(string, d12, "Refresh Time ", this.refreshTimeTable);
                    arrayList.set(n, new Double(this.formatter3.format(d7 / 1000.0)));
                } else if (n == 11) {
                    d8 = this.getDifferenceValue(string, d12, "Merge count ", this.mergeCountTable);
                    arrayList.set(n, new Double(d8));
                } else if (n == 12) {
                    d9 = this.getDifferenceValue(string, d12, "Merge Time ", this.mergeTimeTable);
                    arrayList.set(n, new Double(this.formatter3.format(d9 / 1000.0)));
                } else if (n == 13) {
                    d11 = this.getDifferenceValue(string, d12, "Flush count ", this.flushCountTable);
                    arrayList.set(n, new Double(d11));
                } else if (n == 14) {
                    d10 = this.getDifferenceValue(string, d12, "Flush Time ", this.flushTimeTable);
                    arrayList.set(n, new Double(this.formatter3.format(d10 / 1000.0)));
                }
                arrayList.set(22, new Double(d5));
                arrayList.set(23, new Double(d4));
            }
            catch (Exception exception) {
                if (string3.equalsIgnoreCase("red")) {
                    arrayList.set(n, new Double(0.0));
                    this.statusReportTable.put(string, "red");
                    this.statusMsgReportTable.put(string, " Primary shards are missing in the cluster");
                    continue;
                }
                if (string3.equalsIgnoreCase("yellow")) {
                    arrayList.set(n, new Double(1.0));
                    this.statusReportTable.put(string, "yellow");
                    this.statusMsgReportTable.put(string, " Replica shards are unallocated in the cluster");
                    continue;
                }
                if (!string3.equalsIgnoreCase("green")) continue;
                arrayList.set(n, new Double(2.0));
                this.statusReportTable.put(string, "green");
                this.statusMsgReportTable.put(string, "All shards are allocated in the cluster");
            }
        }
        double d15 = d6 > 0.0 ? d7 / d6 : 0.0;
        arrayList.set(24, new Double(this.formatter3.format(d15 / 1000.0)));
        double d16 = d8 > 0.0 ? d9 / d8 : 0.0;
        arrayList.set(25, new Double(this.formatter2.format(d16 / 1000.0)));
        double d17 = d11 > 0.0 ? d10 / d11 : 0.0;
        arrayList.set(26, new Double(this.formatter3.format(d17 / 1000.0)));
        logger.debug(this.logPrefix + "  [getESIndexingFinalMeasures]  The final ArrayList - measure contains :\n" + arrayList);
        String string4 = (String)this.statusMsgReportTable.get(string);
        if (string4 != null && string4.contains("Replica shards")) {
            this.statusMsgReportTable.put(string, this.formatter.format(arrayList.get(21)) + string4);
        }
        return arrayList;
    }

    public Hashtable getIndexHealthStatus() {
        return this.statusReportTable;
    }

    public Hashtable getIndexHealthStatusMsg() {
        return this.statusMsgReportTable;
    }

    private double getDifferenceValue(String string, Double d, String string2, Hashtable hashtable) {
        double d2 = 0.0;
        if (this.firstTime) {
            hashtable.put(string, d);
            logger.debug(this.logPrefix + "The first " + string2 + " value is " + d);
        } else {
            Object v = hashtable.get(string);
            double d3 = 0.0;
            if (v != null) {
                d3 = (Double)v;
            }
            if (d3 <= d) {
                double d4 = d - d3;
                logger.debug(this.logPrefix + " [getDifferenceValue]  The " + string2 + "  difference between current and previous value is \n:" + d + " - " + d3 + "=" + d4);
                logger.debug(this.logPrefix + "The " + string2 + " value is " + d);
                d2 = d4;
                hashtable.put(string, d);
            } else {
                hashtable.put(string, d);
                d2 = d;
                logger.debug(this.logPrefix + "The " + string2 + " value is " + d);
            }
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        ESIndexingTest eSIndexingTest = new ESIndexingTest(stringArray);
        while (true) {
            eSIndexingTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

