/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EMCECSBaseRESTExecutor {
    private static final int j = 124;
    String port = null;
    String ecsUser = null;
    String ecsPass = null;
    String baseURLString = null;
    private long collectionTimeout;
    private static final String def_IdleTimeout = "120";
    String tmp_timeout = null;
    String reportingName = null;
    String entity = null;
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private static final String EMC_ECS_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm";
    String logMessage = "";
    String className = this.getClass().getName();
    String DEFAULT_SERVICE_SET = null;
    String targetHost = null;
    protected static final String ECS_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/EMCECSLog";
    double ecsLogSizeLimitInMB = 5000000.0;
    double ecsLastMeaPeriodInSec = 300.0;
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 500;
    protected static final int DEFAULT_ALERT_MESSAGE_LIMIT = 1000;
    protected static final String SPACE = new String(" ");
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    protected static final String CACHE_CONTROL = "Cache-Control";
    protected static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    protected static final String REQUEST_METHOD = "GET";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String X_SDS_AUTH_TOKEN = "X-SDS-AUTH-TOKEN";
    protected static final String COLONS = ":";
    private static final String EMC_ECS_REST_OUTPUT = "EMC_ECS_REST_OUTPUT:";
    private static final String NAMESPACE_OUTPUT = "NAMESPACE_OUTPUT:";
    private static final String CLUSTER_CAPACITY_OUTPUT = "CLUSTER_CAPACITY_OUTPUT:";
    private static final String NODES_OUTPUT = "NODES_OUTPUT:";
    private static final String REPLICATION_GROUPS_OUTPUT = "REPLICATION_GROUPS_OUTPUT:";
    private static final String STORAGE_POOLS_OUTPUT = "STORAGE_POOLS_OUTPUT:";
    private static final String ALL_VDC_LIST_OUTPUT = "ALL_VDC_LIST_OUTPUT:";
    private static final String ALL_BUCKETS_LIST_OUTPUT = "ALL_BUCKETS_LIST_OUTPUT:";
    private static final String DATA_STORES_OUTPUT = "DATA_STORES_OUTPUT:";
    private static final String VDC_ALERTS_OUTPUT = "VDC_ALERTS_OUTPUT:";
    private static final String VDC_UNACKNOWLEDGED_ALERTS_OUTPUT = "VDC_UNACKNOWLEDGED_ALERTS_OUTPUT:";
    private static final String EVENTS_OUTPUT = "EVENTS_OUTPUT:";
    private static final String LOCAL_ZONE_OUTPUT = "LOCAL_ZONE_OUTPUT:";
    private static final String REPLICATION_GROUPS_PERF_OUTPUT = "REPLICATION_GROUPS_PERF_OUTPUT:";
    private static final String NODE_PERF_OUTPUT = "NODE_PERF_OUTPUT:";
    private static final String NODES_DISK_CAPACITY_OUTPUT = "NODES_DISK_CAPACITY_OUTPUT:";
    private static final String NODE_PROCESS_PERF_OUTPUT = "NODE_PROCESS_PERF_OUTPUT:";
    private static final String STORAGE_POOLS_PERF_OUTPUT = "STORAGE_POOLS_PERF_OUTPUT:";
    private static final String SEPERATOR_1 = "~!~";
    private static final String SEPERATOR_2 = "~#~";
    boolean deep_debug = false;
    private static final String JSON_OBJECT_PARSING_EXCEPTION_MESSAGE = "JSONException while parsing JSONObjects :";
    protected static final String DEBUG = "DEBUG";
    protected static final String INFO = "INFO";
    protected static final String WARNING = "WARNING";
    protected static final String ERROR = "ERROR";

    public EMCECSBaseRESTExecutor(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    this.targetHost = new String(stringArray[++i]);
                    if (this.targetHost != null) {
                        this.targetHost = this.targetHost.trim();
                    }
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    this.port = new String(stringArray[++i]);
                    if (this.port == null) continue;
                    this.port = this.port.trim();
                    continue;
                }
                if (stringArray[i].equals("-username") && i + 1 < stringArray.length) {
                    this.ecsUser = new String(stringArray[++i]);
                    if (this.ecsUser == null) continue;
                    this.ecsUser = this.ecsUser.trim();
                    continue;
                }
                if (stringArray[i].equals("-password") && i + 1 < stringArray.length) {
                    this.ecsPass = new String(stringArray[++i]);
                    if (this.ecsPass != null) {
                        this.ecsPass = this.ecsPass.trim();
                    }
                    this.ecsPass = this.decrypt(this.ecsPass);
                    continue;
                }
                if (stringArray[i].equals("-timeout") && i + 1 < stringArray.length) {
                    string = new String(stringArray[++i]);
                    try {
                        this.collectionTimeout = Long.parseLong(string) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            this.collectionTimeout = Long.parseLong(def_IdleTimeout) * 1000L;
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                    continue;
                }
                if (stringArray[i].equals("-reportingName") && i + 1 < stringArray.length) {
                    this.reportingName = new String(stringArray[++i]);
                    if (this.reportingName == null) continue;
                    this.reportingName = this.reportingName.trim();
                    continue;
                }
                if (stringArray[i].equals("-entity") && i + 1 < stringArray.length) {
                    this.entity = new String(stringArray[++i]);
                    if (this.entity == null) continue;
                    this.entity = this.entity.trim();
                    continue;
                }
                if (stringArray[i].equals("-log_size") && i + 1 < stringArray.length) {
                    if ((string = new String(stringArray[++i])) != null && string.length() > 0) {
                        string = string.trim();
                        try {
                            this.ecsLogSizeLimitInMB = Double.parseDouble(string);
                            this.ecsLogSizeLimitInMB *= 1048576.0;
                        }
                        catch (Exception exception) {
                            this.printOut("[" + this.className + "]: [Constructor ]: strECSLogSizeLimitInMB : " + string + " ,exception :" + exception.toString());
                            this.ecsLogSizeLimitInMB = 5000000.0;
                        }
                    }
                    this.printOut("[" + this.className + "]: [Constructor ]: ecsLogSizeLimitInMB : " + this.ecsLogSizeLimitInMB);
                    continue;
                }
                if (!stringArray[i].equals("-mea_period_in_sec") || i + 1 >= stringArray.length) continue;
                if ((string = new String(stringArray[++i])) != null && string.length() > 0) {
                    string = string.trim();
                    try {
                        this.ecsLastMeaPeriodInSec = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        this.printOut("[" + this.className + "]: [Constructor ]: strLastMeaPeriodInSeconds : " + string + " ,exception :" + exception.toString());
                        this.ecsLastMeaPeriodInSec = 300.0;
                    }
                }
                this.printOut("[" + this.className + "]: [Constructor ]: ecsLastMeaPeriodInSec : " + this.ecsLastMeaPeriodInSec);
            }
            this.baseURLString = "https://" + this.targetHost + COLONS + this.port + "/";
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(COLONS) == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, COLONS);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        EMCECSBaseRESTExecutor eMCECSBaseRESTExecutor = new EMCECSBaseRESTExecutor(stringArray);
        eMCECSBaseRESTExecutor.getJSONDataFromURL(eMCECSBaseRESTExecutor.targetHost, eMCECSBaseRESTExecutor.port);
    }

    public void getJSONDataFromURL(String string, String string2) {
        String string3;
        Object object;
        Enumeration enumeration;
        Object object2;
        String string4;
        Enumeration enumeration2;
        Object object3;
        String string5 = "getJSONDataFromURL";
        string5 = this.methodNameTemplate(string5);
        String string6 = null;
        Object var9_5 = null;
        long l = System.currentTimeMillis();
        this.enableSSLForEMCECS();
        this.printOut(string5 + "Before creating the session ");
        String string7 = this.createSession();
        long l2 = System.currentTimeMillis();
        this.printOut(string5 + "Tracing - - createSession  took " + (l2 - l) + " millisecs");
        this.printOut(string5 + "After create the session Session ID  : " + string7);
        if (string7 == null) {
            this.printOut(string5 + " Session value is null  " + RETURNING_INFO_MESSAGE);
            return;
        }
        String string8 = "NAMESPACE_OUTPUT:none";
        String string9 = "CLUSTER_CAPACITY_OUTPUT:none";
        String string10 = "NODES_OUTPUT:none";
        String string11 = "REPLICATION_GROUPS_OUTPUT:none";
        String string12 = "STORAGE_POOLS_OUTPUT:none";
        String string13 = "ALL_VDC_LIST_OUTPUT:none";
        Object object4 = "ALL_BUCKETS_LIST_OUTPUT:none";
        String string14 = "DATA_STORES_OUTPUT:none";
        String string15 = "VDC_ALERTS_OUTPUT:none";
        String string16 = "EVENTS_OUTPUT:none";
        String string17 = "VDC_UNACKNOWLEDGED_ALERTS_OUTPUT:none";
        String string18 = "LOCAL_ZONE_OUTPUT:none";
        String string19 = "REPLICATION_GROUPS_PERF_OUTPUT:none";
        String string20 = "NODE_PERF_OUTPUT:none";
        Object object5 = "NODES_DISK_CAPACITY_OUTPUT:none";
        Object object6 = "NODE_PROCESS_PERF_OUTPUT:none";
        String string21 = "STORAGE_POOLS_PERF_OUTPUT:none";
        String string22 = "";
        ArrayList arrayList = new ArrayList();
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "object/namespaces.json";
            this.printOut(string5 + "NameSpace data URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for NameSpace metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string8 = ((DataCollectionThread)object3).getResponseString();
            arrayList = this.getNameSpaceALFromJSONString(string8);
            string8 = NAMESPACE_OUTPUT + string8;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "NameSpace data URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "object/capacity.json";
            this.printOut(string5 + "Cluster capacity URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Cluster capacity metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string9 = ((DataCollectionThread)object3).getResponseString();
            string9 = CLUSTER_CAPACITY_OUTPUT + string9;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Cluster capacity URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "vdc/nodes.json";
            this.printOut(string5 + "Nodes URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Nodes metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string22 = string10 = ((DataCollectionThread)object3).getResponseString();
            string10 = NODES_OUTPUT + string10;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Nodes URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "vdc/data-service/vpools.json";
            this.printOut(string5 + "Replication groups info URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Replication groups info metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string11 = ((DataCollectionThread)object3).getResponseString();
            string11 = REPLICATION_GROUPS_OUTPUT + string11;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Replication groups URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "vdc/data-services/varrays.json";
            this.printOut(string5 + "Storage pools info URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Storage pools info metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string12 = ((DataCollectionThread)object3).getResponseString();
            string12 = STORAGE_POOLS_OUTPUT + string12;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Storage pools URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "object/vdcs/vdc/list.json";
            this.printOut(string5 + "All VDC info URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for All VDC info metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string13 = ((DataCollectionThread)object3).getResponseString();
            string13 = ALL_VDC_LIST_OUTPUT + string13;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "All VDC info URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object3 = "";
            if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        object3 = (String)object3 + SEPERATOR_2;
                    }
                    String string23 = (String)arrayList.get(i);
                    string6 = this.baseURLString + "object/bucket.json?namespace=" + string23;
                    this.printOut(string5 + "Bucket info URL before call data collection thread  =========> " + string6);
                    enumeration2 = new DataCollectionThread(string6, string7);
                    this.runThread((MonitoredThread)((Object)enumeration2), "DataCollection", 20L);
                    this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Bucket info metrics " + (System.currentTimeMillis() - l2) + "ms.");
                    string4 = ((DataCollectionThread)((Object)enumeration2)).getResponseString();
                    object3 = (String)object3 + string4;
                }
                object4 = object3;
                object4 = ALL_BUCKETS_LIST_OUTPUT + (String)object4;
            } else {
                this.printOut(string5 + "There is no bucket information in this node");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Bucket URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "vdc/data-stores.json";
            this.printOut(string5 + "Data stores URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Data stores metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string14 = ((DataCollectionThread)object3).getResponseString();
            string14 = DATA_STORES_OUTPUT + string14;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Data stores URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object3 = this.getEMCECSFrequencyURI(this.ecsLastMeaPeriodInSec);
            string6 = this.baseURLString + "vdc/alerts.json" + (String)object3;
            this.printOut(string5 + "VDC Alerts URL before call data collection thread  =========> " + string6);
            DataCollectionThread dataCollectionThread = new DataCollectionThread(string6, string7);
            this.runThread(dataCollectionThread, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for VDC Alerts metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string15 = dataCollectionThread.getResponseString();
            string15 = VDC_ALERTS_OUTPUT + string15;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "VDC Alerts URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object3 = "?acknowledged=false";
            string6 = this.baseURLString + "vdc/alerts.json" + (String)object3;
            this.printOut(string5 + "VDC unacknowledged alerts  URL before call data collection thread  =========> " + string6);
            DataCollectionThread dataCollectionThread = new DataCollectionThread(string6, string7);
            this.runThread(dataCollectionThread, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for VDC unacknowledged alerts  metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string17 = dataCollectionThread.getResponseString();
            string17 = VDC_UNACKNOWLEDGED_ALERTS_OUTPUT + string17;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "VDC unacknowledged alerts  URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object3 = this.getEMCECSFrequencyURI(this.ecsLastMeaPeriodInSec);
            string6 = this.baseURLString + "vdc/events.json" + (String)object3;
            this.printOut(string5 + "ECS events URL before call data collection thread  =========> " + string6);
            DataCollectionThread dataCollectionThread = new DataCollectionThread(string6, string7);
            this.runThread(dataCollectionThread, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for events metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string16 = dataCollectionThread.getResponseString();
            string16 = EVENTS_OUTPUT + string16;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Events  URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "dashboard/zones/localzone?dataType=current";
            this.printOut(string5 + "Local zone URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Local zone metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string18 = ((DataCollectionThread)object3).getResponseString();
            string18 = LOCAL_ZONE_OUTPUT + string18;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Local zone URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "dashboard/zones/localzone/replicationgroups?dataType=current";
            this.printOut(string5 + "Replication group URL before call data collection thread  =========> " + string6);
            object3 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object3, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for replication groups metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string19 = ((DataCollectionThread)object3).getResponseString();
            string19 = REPLICATION_GROUPS_PERF_OUTPUT + string19;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Replication groups perf URL =========> " + string6 + " ,Exception raised ", exception);
        }
        object3 = new Hashtable();
        Hashtable hashtable = new Hashtable();
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "dashboard/zones/localzone/nodes?dataType=current";
            this.printOut(string5 + "Node perf URL before call data collection thread  =========> " + string6);
            object2 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object2, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Node perf metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string20 = ((DataCollectionThread)object2).getResponseString();
            object3 = this.getDisksHTFromJSONString(string20);
            hashtable = this.getProcessHTFromJSONString(string20);
            string20 = NODE_PERF_OUTPUT + string20;
            this.printOut(string5 + " diskInfoHT :" + object3);
            this.printOut(string5 + " processInfoHT :" + hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Node perf URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object2 = "";
            if (object3 != null && !((Hashtable)object3).isEmpty() && ((Hashtable)object3).size() > 0) {
                int n = 0;
                enumeration2 = ((Hashtable)object3).keys();
                if (enumeration2 != null && enumeration2.hasMoreElements()) {
                    while (enumeration2 != null && enumeration2.hasMoreElements()) {
                        if (n != 0) {
                            object2 = (String)object2 + SEPERATOR_2;
                        }
                        if (((String)((Object)(enumeration = (String)((Hashtable)object3).get(string4 = (String)enumeration2.nextElement())))).startsWith("/")) {
                            enumeration = ((String)((Object)enumeration)).substring(1);
                            this.printOut(string5 + "Node  diskURL  =========> " + (String)((Object)enumeration));
                        }
                        string6 = this.baseURLString + (String)((Object)enumeration) + "?dataType=current";
                        this.printOut(string5 + "Node disk capacity URL before call data collection thread  =========> " + string6);
                        object = new DataCollectionThread(string6, string7);
                        this.runThread((MonitoredThread)object, "DataCollection", 20L);
                        this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Node disk capacity metrics " + (System.currentTimeMillis() - l2) + "ms.");
                        string3 = ((DataCollectionThread)object).getResponseString();
                        object2 = (String)object2 + string3;
                        ++n;
                    }
                    object5 = object2;
                    object5 = NODES_DISK_CAPACITY_OUTPUT + (String)object5;
                } else {
                    this.printOut(string5 + "There is no elements in while iterate the disk data");
                    this.putWarningMessageToLogfile(string5 + "There is no elements in while iterate the disk data ");
                }
            } else {
                this.printOut(string5 + "There is no disk information in this node");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Node disk perf URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            object2 = "";
            Hashtable hashtable2 = new Hashtable();
            hashtable2 = this.getNodeNameHTFromJSONString(string22);
            boolean bl = false;
            if (hashtable2 != null && !hashtable2.isEmpty() && hashtable2.size() > 0) {
                bl = true;
            }
            if (hashtable != null && !hashtable.isEmpty() && hashtable.size() > 0) {
                int n = 0;
                enumeration = hashtable.keys();
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        if (n != 0) {
                            object2 = (String)object2 + SEPERATOR_2;
                        }
                        object = (String)enumeration.nextElement();
                        string3 = (String)hashtable.get(object);
                        Object object7 = object;
                        if (bl && ((String)(object7 = "" + hashtable2.get(object))).trim().length() == 0) {
                            object7 = object;
                        }
                        if (string3.startsWith("/")) {
                            string3 = string3.substring(1);
                            this.printOut(string5 + "Node  processURL  =========> " + string3);
                        }
                        string6 = this.baseURLString + string3 + "?dataType=current";
                        this.printOut(string5 + "Node process perf URL before call data collection thread  =========> " + string6);
                        DataCollectionThread dataCollectionThread = new DataCollectionThread(string6, string7);
                        this.runThread(dataCollectionThread, "DataCollection", 20L);
                        this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Node process perf metrics " + (System.currentTimeMillis() - l2) + "ms.");
                        String string24 = dataCollectionThread.getResponseString();
                        string24 = "{\"eg_node_name\":\"" + (String)object7 + "\", \"eg_node_process\": " + string24 + "  }";
                        object2 = (String)object2 + string24;
                        ++n;
                    }
                    object6 = object2;
                    object6 = NODE_PROCESS_PERF_OUTPUT + (String)object6;
                    this.printOut(string5 + "After nodeProcessPerfJSONText  :" + (String)object6);
                } else {
                    this.printOut(string5 + "There is no elements in while iterate the process data");
                    this.putWarningMessageToLogfile(string5 + "There is no elements in while iterate the process data ");
                }
            } else {
                this.printOut(string5 + "There is no process information in this node");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Node process perf URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string6 = this.baseURLString + "dashboard/zones/localzone/storagepools?dataType=current";
            this.printOut(string5 + "Storage pools perf URL before call data collection thread  =========> " + string6);
            object2 = new DataCollectionThread(string6, string7);
            this.runThread((MonitoredThread)object2, "DataCollection", 20L);
            this.printOut(string5 + "Data Collected for  " + this.targetHost + " for Storage pools perf metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string21 = ((DataCollectionThread)object2).getResponseString();
            string21 = STORAGE_POOLS_PERF_OUTPUT + string21;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string5 + "Storage pools perf URL =========> " + string6 + " ,Exception raised ", exception);
        }
        this.printOut(string5 + "------------------------------------------------------------------------------------------------------------");
        object2 = "EMC_ECS_REST_OUTPUT:~!~" + string8 + SEPERATOR_1 + string9 + SEPERATOR_1 + string10 + SEPERATOR_1 + string11 + SEPERATOR_1 + string12 + SEPERATOR_1 + string13 + SEPERATOR_1 + (String)object4 + SEPERATOR_1 + string14 + SEPERATOR_1 + string15 + SEPERATOR_1 + string17 + SEPERATOR_1 + string16 + SEPERATOR_1 + string18 + SEPERATOR_1 + string19 + SEPERATOR_1 + string20 + SEPERATOR_1 + (String)object5 + SEPERATOR_1 + (String)object6 + SEPERATOR_1 + string21;
        this.printOut(string5 + " All of the data collection process is completed ,going to remove the session ,but please check data collected properly ");
        String string25 = this.deleteSession(string7);
        System.out.println((String)object2);
        this.printOut(string5 + "Data collection for all process for   " + this.targetHost + " took  " + (System.currentTimeMillis() - l) + "ms.");
    }

    protected String getEMCECSFrequencyURI(double d) {
        String string = "getEMCECSFrequencyURI";
        string = this.methodNameTemplate(string);
        String string2 = "";
        try {
            if (d < 0.0) {
                return "";
            }
            String string3 = null;
            String string4 = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EMC_ECS_TIME_FORMAT, Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            string4 = simpleDateFormat.format(new Date());
            this.printOut(string + "Current time in GMT : " + string4);
            String string5 = simpleDateFormat.format(new Date());
            Date date = null;
            try {
                date = simpleDateFormat.parse(string5);
            }
            catch (java.text.ParseException parseException) {
                this.logMessage = string + "Exception happened while  parsing the time string  ";
                this.printOutStackTrace(this.logMessage, parseException);
                this.logMessage = "";
            }
            catch (Exception exception) {
                this.printOutStackTrace(string + "Error", exception);
            }
            long l = date.getTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l - (long)d * 1000L);
            string3 = simpleDateFormat.format(calendar.getTime());
            this.logMessage = string + "Back time in GMT for message test input :" + string3 + ", time since last test(seconds) :" + d;
            this.printOut(this.logMessage);
            this.logMessage = "";
            string2 = "?dataType=historical&start_time=" + string3 + "&end_time=" + string4 + "&limit=" + 1000;
            this.logMessage = string + "URI for Alerts :" + string2;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + "exception raised while preparing the back time URL :", exception);
        }
        return string2;
    }

    private Hashtable getNodeNameHTFromJSONString(String string) {
        Hashtable<String, String> hashtable;
        block9: {
            hashtable = new Hashtable<String, String>();
            String string2 = "getNodeNameHTFromJSONString";
            string2 = this.methodNameTemplate(string2);
            String string3 = "";
            String string4 = "";
            try {
                if (string == null || string.length() <= 0) break block9;
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = null;
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string);
                    this.printOut(string2 + "  " + jSONObject);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                JSONArray jSONArray = null;
                jSONArray = (JSONArray)jSONObject.get((Object)"node");
                JSONObject jSONObject2 = null;
                if (jSONArray != null && jSONArray.size() > 0) {
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        try {
                            jSONObject2 = (JSONObject)jSONArray.get(i);
                            this.printOut(string2 + " API Result for nodes names: " + jSONObject2, this.deep_debug);
                            if (jSONObject2 != null && !jSONObject2.isEmpty() && jSONObject2.size() > 0) {
                                string3 = this.getValueFromJSONObject(jSONObject2, "nodename");
                                string4 = this.getValueFromJSONObject(jSONObject2, "nodeid");
                                hashtable.put(string4, string3);
                            }
                        }
                        catch (Exception exception) {
                            this.logMessage = string2 + JSON_OBJECT_PARSING_EXCEPTION_MESSAGE;
                            this.printOutStackTrace(this.logMessage, exception);
                            this.logMessage = "";
                            exception.printStackTrace();
                        }
                        this.printOut(string2 + " NODE names  Hashtable :  " + hashtable);
                    }
                    break block9;
                }
                this.printOut(string2 + " There is no nodes ");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printOutStackTrace(string2 + "exception raised while parse the data :", exception);
            }
        }
        return hashtable;
    }

    private ArrayList getNameSpaceALFromJSONString(String string) {
        ArrayList<String> arrayList;
        block7: {
            arrayList = new ArrayList<String>();
            String string2 = "getNameSpaceALFromJSONString";
            string2 = this.methodNameTemplate(string2);
            String string3 = "";
            try {
                if (string == null || string.length() <= 0) break block7;
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = null;
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                JSONArray jSONArray = null;
                jSONArray = (JSONArray)jSONObject.get((Object)"namespace");
                JSONObject jSONObject2 = null;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    try {
                        jSONObject2 = (JSONObject)jSONArray.get(i);
                        this.printOut(string2 + " API Result for namespace: " + jSONObject2, this.deep_debug);
                        if (jSONObject2 == null || jSONObject2.isEmpty() || jSONObject2.size() <= 0) continue;
                        string3 = this.getValueFromJSONObject(jSONObject2, "name");
                        arrayList.add(string3);
                        continue;
                    }
                    catch (Exception exception) {
                        this.logMessage = string2 + JSON_OBJECT_PARSING_EXCEPTION_MESSAGE;
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        exception.printStackTrace();
                    }
                }
                this.printOut(string2 + " NAMESPACE ArrayList :  " + arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printOutStackTrace(string2 + "exception raised while parse the data :", exception);
            }
        }
        return arrayList;
    }

    private Hashtable getDisksHTFromJSONString(String string) {
        Hashtable<String, String> hashtable;
        block7: {
            String string2 = "getDisksHTFromJSONString";
            string2 = this.methodNameTemplate(string2);
            hashtable = new Hashtable<String, String>();
            try {
                if (string == null || string.length() <= 0) break block7;
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = null;
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (Exception exception) {
                    this.printOutStackTrace(string2 + "Error", exception);
                }
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"_embedded");
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"_instances");
                if (jSONArray.size() > 0) {
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        JSONObject jSONObject3 = (JSONObject)jSONArray.get(i);
                        String string3 = (String)jSONObject3.get((Object)"id");
                        JSONObject jSONObject4 = (JSONObject)jSONObject3.get((Object)"_links");
                        JSONObject jSONObject5 = (JSONObject)jSONObject4.get((Object)"disks");
                        String string4 = (String)jSONObject5.get((Object)"href");
                        this.printOut(string2 + "Node ID : " + string3 + " ,URL  :" + string4);
                        if (string4 == null || string4.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0) continue;
                        hashtable.put(string3, string4);
                    }
                    break block7;
                }
                this.logMessage = string2 + " There is no disks in " + this.targetHost + " ,So returning with null data ";
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printOutStackTrace(string2 + "exception raised while parsing the data :", exception);
            }
        }
        return hashtable;
    }

    private Hashtable getProcessHTFromJSONString(String string) {
        Hashtable<String, String> hashtable;
        block7: {
            String string2 = "getProcessHTFromJSONString";
            string2 = this.methodNameTemplate(string2);
            hashtable = new Hashtable<String, String>();
            try {
                if (string == null || string.length() <= 0) break block7;
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = null;
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (Exception exception) {
                    this.printOutStackTrace(string2 + "Error", exception);
                }
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"_embedded");
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"_instances");
                if (jSONArray.size() > 0) {
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        JSONObject jSONObject3 = (JSONObject)jSONArray.get(i);
                        String string3 = (String)jSONObject3.get((Object)"id");
                        JSONObject jSONObject4 = (JSONObject)jSONObject3.get((Object)"_links");
                        JSONObject jSONObject5 = (JSONObject)jSONObject4.get((Object)"processes");
                        String string4 = (String)jSONObject5.get((Object)"href");
                        this.printOut(string2 + "Node ID : " + string3 + " ,URL  :" + string4);
                        if (string4 == null || string4.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0) continue;
                        hashtable.put(string3, string4);
                    }
                    break block7;
                }
                this.logMessage = string2 + " There is no process in " + this.targetHost + " ,So returning with null data ";
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printOutStackTrace(string2 + "exception raised while parsing the data :", exception);
            }
        }
        return hashtable;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut(string3 + "jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            this.logMessage = string3 + JSON_OBJECT_PARSING_EXCEPTION_MESSAGE;
            this.printOutStackTrace(this.logMessage, exception);
            exception.printStackTrace();
        }
        return string2;
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        String string2 = "runThread";
        string2 = this.methodNameTemplate(string2);
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.printOutStackTrace(string2, interruptedException);
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.collectionTimeout) {
            this.printOut(string2 + "Thread " + string + " still alive");
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string3 = "";
        this.printOut(string2 + "mt.status   :" + monitoredThread.status);
        this.printOut(string2 + "mt.isAlive   :" + monitoredThread.isAlive());
        if (monitoredThread.isAlive()) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " timed out with exception.";
            } else {
                bl = true;
                string3 = " timed out.";
            }
        } else if (monitoredThread.status != 1) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " got done with exception.";
            } else {
                bl = true;
                string3 = " aborted without exception";
            }
        }
        this.printOut(string2 + "interruptThread   :" + bl);
        if (bl) {
            monitoredThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            this.printOut(string2 + "Error: Thread " + string + " " + string3);
            this.putErrorMessageToLogfile("Thread " + string + string3);
            throw new Exception("Thread " + string + " " + string3);
        }
    }

    protected String createSession() {
        String string = "createSession";
        string = this.methodNameTemplate(string);
        this.printOut(string + "Entered into createSession() block");
        String string2 = null;
        try {
            long l = System.currentTimeMillis();
            CreateSessionThread createSessionThread = new CreateSessionThread();
            this.runThread(createSessionThread, "createAndConnect", 20L);
            string2 = createSessionThread.getSessionID();
            this.printOut(string + "Client created and connected to " + this.targetHost + " service in " + (System.currentTimeMillis() - l) + "ms.");
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace("Error while getting connection ,Could not create client or Could not connect with created client,Exception details", exception);
            return null;
        }
    }

    protected String deleteSession(String string) {
        String string2 = "deleteSession";
        string2 = this.methodNameTemplate(string2);
        this.printOut(string2 + "Entered into deleteSession() block");
        String string3 = null;
        try {
            long l = System.currentTimeMillis();
            DeleteSessionThread deleteSessionThread = new DeleteSessionThread(string);
            this.runThread(deleteSessionThread, "createAndDelete", 20L);
            string3 = deleteSessionThread.getResponseString();
            this.printOut(string2 + "Client created and connected to " + this.targetHost + " service in " + (System.currentTimeMillis() - l) + "ms.");
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace("Error while getting connection ,Could not delete client or Could not delete with created client,Exception details", exception);
            return null;
        }
    }

    void enableSSLForEMCECS() {
        String string = null;
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var4_4 = null;
        MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = "[enableSSLForEMCECS]";
            this.printOutStackTrace(string, noSuchAlgorithmException);
        }
        try {
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException keyManagementException) {
            string = "[enableSSLForEMCECS]";
            this.printOutStackTrace(string, keyManagementException);
        }
        SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
        HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        EMCECSBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.ecsLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        EMCECSBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.ecsLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        EMCECSBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.ecsLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        EMCECSBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.ecsLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = ECS_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            EMCECSBaseRESTExecutor.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    class DeleteSessionThread
    extends MonitoredThread {
        String sessId = null;
        public String responseString = null;
        String value_X_SDS_AUTH_TOKEN = "";
        String uriStr = null;

        DeleteSessionThread(String string) {
            String string2 = "DeleteSessionThread::Constructor";
            string2 = EMCECSBaseRESTExecutor.this.methodNameTemplate(string2);
            this.value_X_SDS_AUTH_TOKEN = string;
        }

        public void run() {
            String string = "DeleteSessionThread::run";
            string = EMCECSBaseRESTExecutor.this.methodNameTemplate(string);
            try {
                this.setName("createAndDelete");
                HttpURLConnection httpURLConnection = null;
                this.uriStr = EMCECSBaseRESTExecutor.this.baseURLString + "logout.json";
                EMCECSBaseRESTExecutor.this.printOut(string + "URL String   :" + this.uriStr);
                URL uRL = new URL(null, this.uriStr);
                String string2 = EMCECSBaseRESTExecutor.this.ecsUser + EMCECSBaseRESTExecutor.COLONS + EMCECSBaseRESTExecutor.this.ecsPass;
                String string3 = Base64Coder.encodeString(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod(EMCECSBaseRESTExecutor.REQUEST_METHOD);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(500);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.CONTENT_TYPE, EMCECSBaseRESTExecutor.CONTENT_TYPE_APPLICATION_JSON);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.X_SDS_AUTH_TOKEN, this.value_X_SDS_AUTH_TOKEN);
                httpURLConnection.setRequestProperty(EMCECSBaseRESTExecutor.CACHE_CONTROL, EMCECSBaseRESTExecutor.CACHE_CONTROL_NO_CACHE);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    EMCECSBaseRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + this.uriStr;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    if (n > 300) {
                        EMCECSBaseRESTExecutor.this.putInfoMessageToLogfile(EMCECSBaseRESTExecutor.this.logMessage);
                    }
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    this.status = 1;
                    EMCECSBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                    Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                    EMCECSBaseRESTExecutor.this.printOut(string + "getHeaderFields : " + map);
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (EMCECSBaseRESTExecutor.this.deep_debug) {
                    EMCECSBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while delete the session ", exception);
                this.status = -1;
                exception.printStackTrace();
            }
        }

        protected String getResponseString() {
            return this.responseString;
        }

        protected String decodeResponse(InputStream inputStream) {
            try {
                Scanner scanner = new Scanner(inputStream);
                scanner.useDelimiter("\\A");
                return scanner.hasNext() ? scanner.next() : "";
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
                return null;
            }
        }
    }

    class DataCollectionThread
    extends MonitoredThread {
        URL url = null;
        String urlString = null;
        String session_id = null;
        String responseString = null;

        DataCollectionThread(String string, String string2) {
            String string3 = "DataCollectionThread::Constructor";
            string3 = EMCECSBaseRESTExecutor.this.methodNameTemplate(string3);
            try {
                this.setName("DataCollection_" + EMCECSBaseRESTExecutor.this.reportingName);
                this.url = new URL(null, string);
                this.session_id = string2;
                this.urlString = string;
                EMCECSBaseRESTExecutor.this.printOut(string3 + "urlStr  : " + string);
                EMCECSBaseRESTExecutor.this.printOut(string3 + "session_id : " + this.session_id);
                if (this.session_id == null || this.session_id.trim().length() > 0) {
                    this.status = -1;
                    return;
                }
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while construct the URL", exception);
                exception.printStackTrace();
            }
        }

        public void run() {
            String string = "DataCollectionThread::run";
            string = EMCECSBaseRESTExecutor.this.methodNameTemplate(string);
            Object var2_2 = null;
            try {
                if (this.session_id == null || this.session_id.trim().length() == 0) {
                    EMCECSBaseRESTExecutor.this.putErrorMessageToLogfile(string + " Session value is null.Exiting data collection");
                    this.status = -1;
                    return;
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection.setRequestMethod(EMCECSBaseRESTExecutor.REQUEST_METHOD);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(500);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.CONTENT_TYPE, EMCECSBaseRESTExecutor.CONTENT_TYPE_APPLICATION_JSON);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.X_SDS_AUTH_TOKEN, this.session_id);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.CACHE_CONTROL, EMCECSBaseRESTExecutor.CACHE_CONTROL_NO_CACHE);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    EMCECSBaseRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + this.urlString;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    if (n > 300) {
                        EMCECSBaseRESTExecutor.this.putInfoMessageToLogfile(EMCECSBaseRESTExecutor.this.logMessage);
                    }
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (EMCECSBaseRESTExecutor.this.deep_debug) {
                    EMCECSBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
                this.status = this.responseString == null || this.responseString.trim().length() == 0 ? -1 : 1;
            }
            catch (Exception exception) {
                this.status = -1;
                exception.printStackTrace();
                EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Exception inside the thread run method", exception);
            }
        }

        protected String decodeResponse(InputStream inputStream) {
            try {
                Scanner scanner = new Scanner(inputStream);
                scanner.useDelimiter("\\A");
                return scanner.hasNext() ? scanner.next() : "";
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
                return null;
            }
        }

        public String getResponseString() {
            String string = "getResponseString";
            string = EMCECSBaseRESTExecutor.this.methodNameTemplate(string);
            this.responseString = EMCECSBaseRESTExecutor.this.replaceAll(this.responseString, System.lineSeparator(), "");
            EMCECSBaseRESTExecutor.this.printOut(string + "After decode for the method  " + string + "  ====> Response  : " + this.responseString);
            return this.responseString;
        }
    }

    class CreateSessionThread
    extends MonitoredThread {
        String sessId = null;
        public String responseString = null;
        String value_X_SDS_AUTH_TOKEN = "";

        CreateSessionThread() {
        }

        public void run() {
            String string = "CreateSessionThread::run";
            string = EMCECSBaseRESTExecutor.this.methodNameTemplate(string);
            try {
                this.setName("createAndConnect");
                String string2 = EMCECSBaseRESTExecutor.this.baseURLString + "login.json";
                EMCECSBaseRESTExecutor.this.printOut(string + "URL String   :" + string2);
                HttpURLConnection httpURLConnection = null;
                URL uRL = new URL(null, string2);
                String string3 = EMCECSBaseRESTExecutor.this.ecsUser + EMCECSBaseRESTExecutor.COLONS + EMCECSBaseRESTExecutor.this.ecsPass;
                String string4 = Base64Coder.encodeString(string3);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod(EMCECSBaseRESTExecutor.REQUEST_METHOD);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(500);
                httpURLConnection.addRequestProperty(EMCECSBaseRESTExecutor.CONTENT_TYPE, EMCECSBaseRESTExecutor.CONTENT_TYPE_APPLICATION_JSON);
                httpURLConnection.setRequestProperty(EMCECSBaseRESTExecutor.AUTHORIZATION, BASIC + string4);
                httpURLConnection.setRequestProperty(EMCECSBaseRESTExecutor.CACHE_CONTROL, EMCECSBaseRESTExecutor.CACHE_CONTROL_NO_CACHE);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    EMCECSBaseRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + string2;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    if (n > 300) {
                        EMCECSBaseRESTExecutor.this.putInfoMessageToLogfile(EMCECSBaseRESTExecutor.this.logMessage);
                    }
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                    EMCECSBaseRESTExecutor.this.printOut(string + "getHeaderFields : " + map);
                    this.value_X_SDS_AUTH_TOKEN = httpURLConnection.getHeaderField(EMCECSBaseRESTExecutor.X_SDS_AUTH_TOKEN);
                    if (this.value_X_SDS_AUTH_TOKEN == null) {
                        EMCECSBaseRESTExecutor.this.printOut(string + "Key 'X-SDS-AUTH-TOKEN' is not found!");
                    } else {
                        EMCECSBaseRESTExecutor.this.printOut(string + "X-SDS-AUTH-TOKEN - " + this.value_X_SDS_AUTH_TOKEN);
                    }
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    EMCECSBaseRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (EMCECSBaseRESTExecutor.this.deep_debug) {
                    EMCECSBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                    EMCECSBaseRESTExecutor.this.logMessage = "";
                }
                this.status = this.value_X_SDS_AUTH_TOKEN == null || this.value_X_SDS_AUTH_TOKEN.trim().length() == 0 ? -1 : 1;
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while creating client or connecting with created client", exception);
                this.status = -1;
                exception.printStackTrace();
            }
        }

        protected String getSessionID() {
            return this.value_X_SDS_AUTH_TOKEN;
        }

        protected String decodeResponse(InputStream inputStream) {
            String string = "decodeResponse";
            string = EMCECSBaseRESTExecutor.this.methodNameTemplate(string);
            try {
                if (inputStream != null && inputStream.toString().trim().length() > 0) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\\A");
                    return scanner.hasNext() ? scanner.next() : "";
                }
                EMCECSBaseRESTExecutor.this.logMessage = string + " Response is null or empty";
                EMCECSBaseRESTExecutor.this.printOut(EMCECSBaseRESTExecutor.this.logMessage);
                EMCECSBaseRESTExecutor.this.putWarningMessageToLogfile(EMCECSBaseRESTExecutor.this.logMessage);
                EMCECSBaseRESTExecutor.this.logMessage = "";
            }
            catch (Exception exception) {
                EMCECSBaseRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
            }
            return null;
        }
    }

    abstract class MonitoredThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;

        MonitoredThread() {
        }

        public abstract void run();
    }
}

