/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DiskSpaceTestAutmnClnupHelper {
    private static final String className = "DiskSpaceTestAutmnClnupHelper";
    private static final String CONST_GLOB = "glob:";
    private static final String CONST_EXCEPTION = "EXCEPTION";
    private static final String CONST_DEBUG = "DEBUG";

    static Map getSubObjectsForDir(String startPathStr, boolean isWindows, DiskSpaceTest diskSpaceTest, boolean isDebug_methodEntryExit, boolean isDebug) {
        return DiskSpaceTestAutmnClnupHelper.getSubObjectsForDir(startPathStr, isWindows, diskSpaceTest, null, isDebug_methodEntryExit, isDebug);
    }

    static Map getSubObjectsForDir(String startPathStr, boolean isWindows, DiskSpaceTest diskSpaceTest, Integer maxDpth, boolean isDebug_methodEntryExit, boolean isDebug) {
        String methodName = "getSubObjectsForDir";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- startPathStr: " + startPathStr + ", isWindows: " + isWindows + ", diskSpaceTest: " + diskSpaceTest + ", isDebug_methodEntryExit: " + isDebug_methodEntryExit + ", isDebug: " + isDebug, null);
        }
        final boolean isWindowsOS = isWindows;
        HashMap subObjects = new HashMap();
        subObjects.put("files", null);
        subObjects.put("folders", null);
        try {
            startPathStr = DiskSpaceTestAutmnClnupHelper.replaceAll(startPathStr, "\\", "/", isDebug_methodEntryExit, isDebug);
            Path startPath = Paths.get(startPathStr, new String[0]);
            final ArrayList files = new ArrayList();
            final ArrayList folders = new ArrayList();
            int maxDepth = 0;
            maxDepth = maxDpth == null ? Integer.MAX_VALUE : maxDpth;
            if (new File(startPathStr).exists()) {
                Files.walkFileTree(startPath, Collections.<FileVisitOption>emptySet(), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                        if (attrs.isDirectory()) {
                            if (isWindowsOS) {
                                folders.add(path.toString().toUpperCase());
                            } else {
                                folders.add(path.toString());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (!attrs.isDirectory()) {
                            if (isWindowsOS) {
                                files.add(path.toString().toUpperCase());
                            } else {
                                files.add(path.toString());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException ioe) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            subObjects.put("files", files);
            subObjects.put("folders", folders);
        }
        catch (Exception e) {
            if (isDebug) {
                DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
            diskSpaceTest.logToErrorFile("ERROR", "DiskSpaceTestAutmnClnupHelper : " + methodName, "Issue in fetching files and folders for the clean up rule " + startPathStr);
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "subObjects: " + subObjects, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return subObjects;
    }

    static Map getSubObjectsForWildCard(String wildCardPath, boolean isWindows, DiskSpaceTest diskSpaceTest, boolean isDebug_methodEntryExit, boolean isDebug) {
        String methodName = "getSubObjectsForWildCard";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- wildCardPath: " + wildCardPath + ", isWindows: " + isWindows + ", diskSpaceTest: " + diskSpaceTest + ", isDebug_methodEntryExit: " + isDebug_methodEntryExit + ", isDebug: " + isDebug, null);
        }
        final boolean isWindowsOS = isWindows;
        HashMap subObjects = new HashMap();
        subObjects.put("files", null);
        subObjects.put("folders", null);
        try {
            int starIndex;
            wildCardPath = DiskSpaceTestAutmnClnupHelper.replaceAll(wildCardPath, "\\", "/", isDebug_methodEntryExit, isDebug);
            final ArrayList files = new ArrayList();
            final ArrayList folders = new ArrayList();
            String pathExcludeWildCard = null;
            String wildCardSegment = null;
            if (wildCardPath != null && !wildCardPath.trim().startsWith("*") && (starIndex = wildCardPath.indexOf("*")) > -1) {
                int lastBckwdSlshIndex;
                String tempWildCardPathSegmnt;
                int lastFrwdSlshIndex;
                int lastSlashIndex;
                if (wildCardPath.endsWith("/*")) {
                    wildCardPath = String.valueOf(wildCardPath) + "*";
                }
                int n = lastSlashIndex = (lastFrwdSlshIndex = (tempWildCardPathSegmnt = wildCardPath.substring(0, starIndex)).lastIndexOf("/")) > (lastBckwdSlshIndex = tempWildCardPathSegmnt.lastIndexOf("\\")) ? lastFrwdSlshIndex : lastBckwdSlshIndex;
                if (lastSlashIndex > -1) {
                    pathExcludeWildCard = wildCardPath.substring(0, lastSlashIndex + 1);
                    wildCardSegment = wildCardPath.substring(lastSlashIndex + 1);
                }
                String patternToBeMatched = CONST_GLOB + pathExcludeWildCard + wildCardSegment;
                final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(patternToBeMatched);
                if (new File(pathExcludeWildCard).exists()) {
                    Files.walkFileTree(Paths.get(pathExcludeWildCard, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                            if (pathMatcher.matches(path)) {
                                if (isWindowsOS) {
                                    folders.add(path.toString().toUpperCase());
                                } else {
                                    folders.add(path.toString());
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            if (pathMatcher.matches(path)) {
                                if (isWindowsOS) {
                                    files.add(path.toString().toUpperCase());
                                } else {
                                    files.add(path.toString());
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path path, IOException ioe) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            subObjects.put("files", files);
            subObjects.put("folders", folders);
        }
        catch (Exception e) {
            if (isDebug) {
                DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
            diskSpaceTest.logToErrorFile("ERROR", "DiskSpaceTestAutmnClnupHelper : " + methodName, "Issue in fetching files and folders for the clean up rule " + wildCardPath);
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "subObjects: " + subObjects, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return subObjects;
    }

    private static String replaceAll(String content, String oldValue, String newValue, boolean isDebug_methodEntryExit, boolean isDebug) {
        String methodName = "replaceAll";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "content: " + content + " , " + "oldValue: " + oldValue + " , " + "newValue: " + newValue + " , ", null);
        }
        String replacedContent = content;
        if (content != null && oldValue != null && newValue != null && content.indexOf(oldValue) > -1) {
            StringBuffer replacedContentBuf = new StringBuffer();
            while (content.indexOf(oldValue) > -1) {
                replacedContentBuf.append(String.valueOf(content.substring(0, content.indexOf(oldValue))) + newValue);
                content = content.substring(content.indexOf(oldValue) + oldValue.length(), content.length());
            }
            if (content.length() > 0) {
                replacedContentBuf.append(content);
            }
            replacedContent = replacedContentBuf.toString();
        }
        if (isDebug) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "replacedContent: " + replacedContent.toString(), null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutmnClnupHelper.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return replacedContent;
    }

    private static void logForDebug(String level, String className, String methodName, String message, Throwable t) {
        try {
            String curDate = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss.SSS").format(new Date());
            if (t == null) {
                System.out.println(String.valueOf(curDate) + " : " + level + " : " + className + ": " + methodName + " : " + message);
            } else {
                System.out.println(String.valueOf(curDate) + " : " + CONST_EXCEPTION + " : " + className + ": " + methodName + " : " + t.getMessage());
                t.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

