/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;

public class Db2DPFSortTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String dbName;
    private HashMap lastValues;
    private ArrayList activeDatabases;
    private double Db2Version = 0.0;
    private boolean validCheckDone = false;
    String query = "";

    public Db2DPFSortTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.lastValues = new HashMap();
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap hashMap = this.getSortStats();
        if (debug) {
            System.out.println("[Db2DPFSortTest]stats=======>" + hashMap);
        }
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                if (debug) {
                    System.out.println("[Db2DPFSortTest]strDbName======>" + string);
                    System.out.println("[Db2DPFSortTest]activeDatabases======>" + this.activeDatabases);
                }
                if (this.activeDatabases.contains(string)) {
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                this.addNewMeasure(string, this.getNotAvailableMeasures());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getSortStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        DB2JdbcHelper dB2JdbcHelper = null;
        String string = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.validCheckDone) {
            this.Db2Version = this.getVersion();
        }
        if (this.Db2Version >= 9.1 && this.Db2Version <= 9.4) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME,SORT_HEAP_ALLOCATED,ACTIVE_SORTS,TOTAL_SORTS,SORT_OVERFLOWS,TOTAL_SORT_TIME FROM table(SNAP_GET_DB_V91(CAST (NULL AS VARCHAR(128)))) AS DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.5 && this.Db2Version <= 9.6) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME,SORT_HEAP_ALLOCATED,ACTIVE_SORTS,TOTAL_SORTS,SORT_OVERFLOWS,TOTAL_SORT_TIME FROM table(SNAP_GET_DB_V95(CAST (NULL AS VARCHAR(128)))) AS DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.7 && this.Db2Version <= 9.9) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME,SORT_HEAP_ALLOCATED,ACTIVE_SORTS,TOTAL_SORTS,SORT_OVERFLOWS,TOTAL_SORT_TIME FROM table(SNAP_GET_DB_V97(CAST (NULL AS VARCHAR(128)))) AS DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 10.0) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME,SORT_HEAP_ALLOCATED,ACTIVE_SORTS,TOTAL_SORTS,SORT_OVERFLOWS,TOTAL_SORT_TIME FROM table(SNAP_GET_DB(CAST (NULL AS VARCHAR(128)))) AS DB order by DBPARTITIONNUM";
        }
        try {
            statement = connection.createStatement();
            statement.execute(this.query);
            if (debug) {
                System.out.println("[Db2DPFSortTest]query=======>" + this.query);
            }
            resultSet = statement.executeQuery(this.query);
            this.activeDatabases = new ArrayList();
            while (resultSet.next()) {
                String string2 = resultSet.getString("DBPARTITIONNUM");
                String string3 = resultSet.getString("DB_NAME");
                string = string3 + "_" + string2;
                d = resultSet.getDouble("SORT_HEAP_ALLOCATED");
                d2 = resultSet.getDouble("ACTIVE_SORTS");
                d3 = resultSet.getDouble("TOTAL_SORTS");
                d4 = resultSet.getDouble("SORT_OVERFLOWS");
                d5 = resultSet.getDouble("TOTAL_SORT_TIME");
                if (debug) {
                    System.out.println("[Db2DPFSortTest]cur SORT_HEAP_ALLOCATED=======>" + d + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]cur ACTIVE_SORTS=======>" + d2 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]cur TOTAL_SORTS=======>" + d3 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]cur SORT_OVERFLOWS=======>" + d4 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]cur TOTAL_SORT_TIME=======>" + d5 + "  info=====>" + string);
                }
                this.activeDatabases.add(string);
                ArrayList<Double> arrayList = (ArrayList<Double>)this.lastValues.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Double>(3);
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                } else {
                    double d10 = (Double)arrayList.get(0);
                    double d11 = (Double)arrayList.get(1);
                    double d12 = (Double)arrayList.get(2);
                    double d13 = d3 - d10;
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (this.timeSinceLastTest > 0.0) {
                        d7 = d13 / this.timeSinceLastTest;
                    }
                    if (d13 > 0.0) {
                        d8 = (d4 - d11) / d13;
                        d9 = (d5 - d12) / d13;
                    } else {
                        d8 = 0.0;
                        d9 = 0.0;
                    }
                    d9 = d9 < 0.0 ? -5.0 : d9;
                    double d14 = d8 = d8 < 0.0 ? -5.0 : d8;
                    if (debug) {
                        System.out.println("[Db2DPFSortTest]pre TOTAL_SORTS=======>" + d10 + "  info=====>" + string);
                        System.out.println("[Db2DPFSortTest]pre SORT_OVERFLOWS=======>" + d11 + "  info=====>" + string);
                        System.out.println("[Db2DPFSortTest]pre TOTAL_SORT_TIME=======>" + d12 + "  info=====>" + string);
                    }
                    arrayList.set(0, new Double(d3));
                    arrayList.set(1, new Double(d4));
                    arrayList.set(2, new Double(d5));
                }
                d6 = d2 > 0.0 ? d / d2 : 0.0;
                if (debug) {
                    System.out.println("[Db2DPFSortTest]Sort_heap_allocated=======>" + d + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]Avg_sort_heap_space_used=======>" + d6 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]Sort_rate=======>" + d7 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]Pct_sort_overflow=======>" + d8 + "  info=====>" + string);
                    System.out.println("[Db2DPFSortTest]Avg_sort_time=======>" + d9 + "  info=====>" + string);
                }
                this.lastValues.put(string, arrayList);
                ArrayList<Double> arrayList2 = new ArrayList<Double>(5);
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d6));
                arrayList2.add(new Double(d7));
                arrayList2.add(new Double(d8));
                arrayList2.add(new Double(d9));
                hashMap.put(string, arrayList2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashMap;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFSortTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(5);
        for (int i = 0; i < 5; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getVersion() {
        DB2JdbcHelper dB2JdbcHelper;
        double d;
        String string;
        String string2;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block11: {
            connection = null;
            statement = null;
            resultSet = null;
            string2 = "";
            string = "";
            d = 9.1;
            dB2JdbcHelper = null;
            String string3 = "SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            if (debug) {
                System.out.println("[DB2ActivityTest] querystring Version=====>" + string2);
            }
            if (string2 != null && string2.trim().length() != 0) break block11;
            this.logToErrorFile("DB22ActivityTest:", "Query  select @@version returning null ", "");
            this.validCheckDone = true;
            double d2 = d;
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            return d2;
        }
        try {
            this.validCheckDone = true;
            string2 = string2.toUpperCase().trim();
            String string4 = "";
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            if (n > 2) {
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (string4.indexOf("DB2 V") > -1) {
                    string4 = string4.substring(string4.indexOf("DB2 V") + 5);
                }
                if ((string = string4 + "." + string5) != null && string.length() > 0) {
                    d = Double.parseDouble(string);
                }
            } else {
                this.logToErrorFile("DB22ActivityTest:", "Version of Db2 is ", string2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                System.out.println("Exception occured in Db2DBFActivityTest " + exception);
                double d3 = d;
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                return d3;
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return d;
    }
}

