/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgManagerInfo;
import com.eg.apm.APMFileOperations;
import java.io.File;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class DDProfilerDumpUploader
extends Thread {
    private MainAgentHelper mah = null;
    private static boolean isDDEnabled = false;
    private static String mc_managerIP = null;
    private static String mc_managerPort = null;
    private static String mc_urlString = null;
    private static String mc_servlet = "com.eg.UploadProfilerDump";
    private static String mc_proxyHost = null;
    private static String mc_proxyPort = null;
    private static String mc_proxyUser = null;
    private static String mc_proxyPassword = null;
    private static boolean mc_useSSL = false;
    private static boolean mc_useProxy = false;
    private static boolean mc_authentication = false;
    private static boolean mc_isEncryptionRequired = false;
    private static String dumpDir = EgInstallInfo.getInstallDir() + "/agent/DumpData";
    private static int maxBurst = 25;
    private static long minSleep = 5000L;
    private static long sleepPeriod = 100000L;
    public static long maxSleep = EgConfigInfo.msecPerMin * 10L;
    private static Hashtable measureTimes = new Hashtable();
    public static long lastUpdated = 0L;
    private static long timeWhenManagerChangeOccured = 0L;
    private static boolean managerChangeOccured = false;
    private static AgentClusterHelper agentClusterHelper = null;
    private static EgManagerInfo managerToReport = null;
    private static EgMainAgent parent = null;
    public static long managerDownCheckTime = 60000L;
    private static double randomizeFactor = 0.1;
    private static double onePlus = 1.0 + randomizeFactor;
    private static double oneMinus = 1.0 - randomizeFactor;
    private com.eg.EgConfigInfo myconfigInfo;

    public DDProfilerDumpUploader(EgMainAgent egMainAgent, MainAgentHelper mainAgentHelper) {
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        lastUpdated = System.currentTimeMillis();
        this.myconfigInfo = egMainAgent.configInfo;
        this.mah = mainAgentHelper;
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        minSleep = egTesterInfo.getDataUploadPeriod();
        if (minSleep < 3000L) {
            minSleep = 3000L;
        }
        if (egMainAgent == null) {
            return;
        }
        parent = egMainAgent;
    }

    private boolean needToSleep() {
        String string = dumpDir;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(".gz")) continue;
                File file2 = new File(string + "/" + stringArray[i]);
                boolean bl = file2.exists();
                long l = file2.length();
                if (!bl || l <= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private long findSleepPeriod() {
        if (EgMgrUpload.isRun) {
            long l = EgMgrUpload.sleepPeriod / 3L;
            if (l <= 0L) {
                l = 1L;
            }
            return l;
        }
        Hashtable hashtable = DDProfilerDumpUploader.parent.measurePeriodForTest;
        if (hashtable == null || hashtable.size() == 0) {
            return EgConfigInfo.msecPerMin * 2L;
        }
        if (hashtable.equals(measureTimes) && sleepPeriod != managerDownCheckTime) {
            return sleepPeriod;
        }
        measureTimes = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable.keys();
        long l = -1L;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            long l2 = n.intValue();
            if (l < 0L) {
                l = l2;
                continue;
            }
            if (l <= l2) continue;
            l = l2;
        }
        if (l < 0L) {
            return -1L;
        }
        if (l > maxSleep) {
            l = maxSleep;
        }
        return l /= 6L;
    }

    private void sleepFor(long l) {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (l3 > 0L) {
            if (l3 > EgAgentCommon.maxSleep) {
                l3 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            l3 = l2 - l4;
        }
    }

    public void run() {
        File file = new File(dumpDir);
        long l = 0L;
        while (true) {
            long l2 = 0L;
            try {
                long l3 = this.findSleepPeriod();
                maxBurst = (int)((double)EgMainAgent.agentMaxBurst * 0.5);
                boolean bl = true;
                if (l3 >= 0L) {
                    sleepPeriod = l3 > minSleep ? l3 : minSleep;
                    bl = this.uploadToMgr();
                }
                if (!bl) {
                    sleepPeriod = managerDownCheckTime;
                } else if (sleepPeriod < 0L) {
                    sleepPeriod = minSleep;
                }
                if (bl && !this.needToSleep()) continue;
                l2 = this.getNextPeriod(sleepPeriod);
                if (l2 < minSleep) {
                    l2 = minSleep;
                } else if (l2 > this.mah.stampPeriod) {
                    l2 = this.mah.stampPeriod;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("DDProfilerDumpUploader exception " + exception.toString());
                parent.logToErrorFile("Warn", "DDProfilerDumpUploader", " failed with " + exception.toString());
            }
            this.sleepFor(l2);
        }
    }

    public long getNextPeriod(long l) {
        double d = (double)l * onePlus;
        double d2 = (double)l * oneMinus;
        return (long)(d2 + EgMainAgent.getRandom() * (d - d2));
    }

    private boolean uploadToMgr() {
        boolean bl = false;
        String string = dumpDir;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return true;
        }
        List<Object> list = new ArrayList();
        list = Arrays.asList(fileArray);
        ArrayList arrayList = new ArrayList(list);
        for (int i = 0; i < list.size(); ++i) {
            File file2;
            Object object = list.get(i);
            if (!(object instanceof File) || (file2 = (File)object) == null || file2.length() != 0L) continue;
            file2.delete();
            arrayList.remove(file2);
        }
        list = new ArrayList(arrayList);
        Collections.sort(list, new TimeComparator());
        List<Object> list2 = new ArrayList();
        if (list.size() > maxBurst) {
            int n = list.size();
            for (int i = n - 1; i >= 0; i -= maxBurst) {
                list2 = list.subList(0, maxBurst);
                bl = this.upload(list2);
                if (!bl) continue;
                list.removeAll(list2);
                if (list.size() < maxBurst) break;
            }
        }
        if (list != null && list.size() > 0) {
            bl = this.upload(list);
        }
        return bl;
    }

    private boolean upload(List list) {
        APMFileOperations aPMFileOperations = new APMFileOperations();
        boolean bl = false;
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            String string = file.getName();
            if (!string.toLowerCase().endsWith(".gz")) continue;
            try {
                byte[] byArray = aPMFileOperations.readFile(file);
                string = string.replace(".gz", "");
                hashtable.put(string, byArray);
                continue;
            }
            catch (Exception exception) {
                System.err.println("DDProfilerDumpUploader : unable read NodeJS dump file: " + exception);
            }
        }
        bl = this.uploadDump(hashtable);
        if (bl) {
            this.removeFile(list);
        }
        return bl;
    }

    private boolean uploadDump(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        if (EgInstallInfo.isClusterSupported) {
            try {
                if (managerToReport == null) {
                    if (agentClusterHelper == null) {
                        agentClusterHelper = AgentClusterHelper.getInstance();
                        parent = agentClusterHelper.getParent();
                    }
                    if ((managerToReport = agentClusterHelper.getManagerToUpload()) == null) {
                        managerToReport = agentClusterHelper.getManagerToUpload(parent);
                    }
                    if (managerToReport == null) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in DDProfilerDumpUploader...UploadDump " + exception);
                exception.printStackTrace();
            }
            if (DDProfilerDumpUploader.agentClusterHelper.managerChangeOccured && DDProfilerDumpUploader.agentClusterHelper.numberOfTimesTried >= 3 && System.currentTimeMillis() > DDProfilerDumpUploader.agentClusterHelper.timeWhenManagerChangeOccured + 3600000L) {
                agentClusterHelper.setTimesTried(0);
            }
            mc_managerIP = managerToReport.getManagerIP();
            mc_managerPort = managerToReport.getManagerPort();
            mc_urlString = managerToReport.getURL() + mc_servlet;
            mc_useSSL = managerToReport.isSSL();
            mc_useProxy = EgMainAgent.isProxySet;
            mc_isEncryptionRequired = managerToReport.isEncryptionRequired();
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        } else {
            if (parent == null) {
                return false;
            }
            mc_managerIP = EgMainAgent.mgrIp;
            mc_managerPort = EgMainAgent.port;
            mc_urlString = new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + com.eg.EgConfigInfo.egMgrUrl + mc_servlet);
            mc_useSSL = new Boolean(EgMainAgent.sslFlag);
            mc_useProxy = EgMainAgent.isProxySet;
            mc_isEncryptionRequired = EgMainAgent.isEncryptionRequired;
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getConnection();
            if (httpURLConnection == null) {
                return false;
            }
            ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
            arrayList.add(hashtable);
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, true, null, false, arrayList, true);
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
            }
            connectionThread = null;
            httpURLConnection = null;
            if (n != 200) {
                throw new ConnectException();
            }
        }
        catch (ConnectException connectException) {
            if (EgInstallInfo.isClusterSupported) {
                managerToReport = agentClusterHelper.getManagerToUpload();
            }
            return false;
        }
        catch (SocketException socketException) {
            if (EgInstallInfo.isClusterSupported) {
                managerToReport = agentClusterHelper.getManagerToUpload();
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private HttpURLConnection getConnection() {
        URL uRL;
        try {
            uRL = new URL(mc_urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            if (EgMainAgent.isProxySet) {
                int n = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(EgMainAgent.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            return httpURLConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout * 2L;
        long l3 = EgConfigInfo.msecPerMin * 5L;
        if ((l2 = l2 * (long)maxBurst / 15L) > l3) {
            l2 = l3;
        } else if (l2 < EgConfigInfo.msecPerMin) {
            l2 = EgConfigInfo.msecPerMin;
        }
        long l4 = 0L;
        long l5 = 250L;
        do {
            long l6 = System.currentTimeMillis();
            if (l5 < EgAgentCommon.minimumSleep) {
                l5 = EgAgentCommon.minimumSleep;
            } else if (l5 > EgAgentCommon.maxSleep) {
                l5 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }

    private void removeFile(List list) {
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            try {
                if (!file.exists()) continue;
                file.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

