/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ConnectionsForAggregate {
    Connection conn;
    private String url;
    private String user;
    private String passwd;
    EgDbInfo dbInfo = new EgDbInfo("agent");
    public boolean isOracle = false;
    String adapter = EgDbInfo.checkDBType("agent");
    String dbType = "sql";

    public ConnectionsForAggregate() {
        String string;
        if (this.adapter.equalsIgnoreCase("EgOracleAdapter")) {
            this.isOracle = true;
        }
        if ((string = this.dbInfo.getDbDrivers()).equals("")) {
            return;
        }
        if (!this.loadDriver(string)) {
            return;
        }
        this.user = this.dbInfo.getUserForDb(this.dbType);
        this.passwd = this.dbInfo.getPasswdForDb(this.dbType);
        this.url = this.dbInfo.getUrlForDb(this.dbType);
    }

    private boolean loadDriver(String string) {
        try {
            Driver driver = (Driver)Class.forName(string).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Connection getConnection() {
        try {
            this.conn = DriverManager.getConnection(this.url, this.user, this.passwd);
            return this.conn;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {
                sQLException.printStackTrace();
            }
            return null;
        }
    }

    public void releaseConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ConnectionsForAggregate connectionsForAggregate = new ConnectionsForAggregate();
        System.out.println(connectionsForAggregate.getConnection());
    }
}

