/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CacheDatabaseTest
extends EgSnmpGenericTest {
    private static String dbNameOid = ".1.3.6.1.4.1.16563.1.1.3.1.2";
    private static String dbReadOid = ".1.3.6.1.4.1.16563.1.1.3.1.5";
    private static String dbSizeOid = ".1.3.6.1.4.1.16563.1.1.3.1.6";
    private static String dbFreeOid = ".1.3.6.1.4.1.16563.1.1.3.1.7";

    public CacheDatabaseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        boolean bl = this.runSnmpCmdForOid(dbNameOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable2.put(this.lhs[i], this.rhs[i]);
        }
        hashtable3 = this.getFromSnmp(dbReadOid);
        hashtable4 = this.getFromSnmp(dbSizeOid);
        hashtable5 = this.getFromSnmp(dbFreeOid);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            double d = this.getDouble(hashtable3, string);
            double d2 = this.getDouble(hashtable4, string);
            double d3 = this.getDouble(hashtable5, string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            double d4 = -5.0;
            if (d3 >= 0.0 && d2 > 0.0) {
                d4 = d3 * 100.0 / d2;
            }
            arrayList.add(new Double(d4));
            this.addNewMeasure(string2, arrayList);
        }
    }

    private double getDouble(Hashtable hashtable, String string) {
        if (hashtable == null || hashtable.size() == 0) {
            return -5.0;
        }
        try {
            Double d = (Double)hashtable.get(string);
            if (d == null) {
                return -5.0;
            }
            return d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    private Hashtable getFromSnmp(String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                double d = Double.parseDouble(this.rhs[i]);
                hashtable.put(this.lhs[i], new Double(d));
                continue;
            }
            catch (Exception exception) {
                hashtable.put(this.lhs[i], new Double(-5.0));
            }
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.53", "-port", "161", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        CacheDatabaseTest cacheDatabaseTest = new CacheDatabaseTest(stringArray2);
        cacheDatabaseTest.computeMeasures(new Hashtable());
    }
}

