/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class BobiLSPerfTest
extends BobiBase {
    private static final int ADAPTIVE_PROCESSING_SERVER_PERF_MEASURE_COUNT = 11;
    private static final String SERVER_TYPE = "LS";
    public Hashtable prevHash = new Hashtable();
    private static final String FREE_MEMORY_MB = "Free Memory _MB_";
    private static final String MAX_MEMORY_MB = "Maximum Memory _MB_";
    private static final String TOTAL_MEMORY_MB = "Total Memory _MB_";
    private static final String SESSION_COUNT = "ZenMetrics.sessionCount";
    private static final String CPU_USAGE_PCT = "CPU Usage Percentage _last 5 Minutes_";
    private static final String PCT_OF_STOPPED_SYSTEM_DURING_GC = "Percentage of stopped system during GC _last 5 Minutes_";
    private static final String PAGE_FAULTS_DURING_GC = "Number of page faults during GC _last 5 Minutes_";
    private static final String FULL_GC = "Number of Full GCs";
    private static final String JVM_LOCK_CONTENTION_COUNT = "JVM Lock Contention Count";
    private static final String JVM_DEADLOCKED_THREADS = "JVM Deadlocked Threads Counter";
    private static final String CURRENT_AUDIT_EVENTS_IN_QUEUE = "Current Number of Auditing Events in the Queue";
    private static final ArrayList attrArrayList = new ArrayList();
    private static final ArrayList dummymeasureArrayList = new ArrayList();

    public BobiLSPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(11);
        this.isDynamicInfoTest = true;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.printOut("Node name :" + this.nodeName);
        String string = "Servers:name=" + this.nodeName + "*,type=" + SERVER_TYPE;
        this.printOut("Query Filter :" + string);
        hashtable2 = this.getAttrs(string, attrArrayList);
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            this.logToErrorFile("WARNING", this.reportingName + ":" + this.entity, "Attributes data hashtable value is null");
            this.addNewMeasure(dummymeasureArrayList);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        double d10 = -5.0;
        double d11 = -5.0;
        double d12 = -5.0;
        while (enumeration.hasMoreElements()) {
            arrayList = new ArrayList();
            String string2 = (String)enumeration.nextElement();
            this.printOut("Info  :" + string2);
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
            d = this.getHashtableData(hashtable3, FREE_MEMORY_MB);
            d2 = this.getHashtableData(hashtable3, MAX_MEMORY_MB);
            d4 = this.getHashtableData(hashtable3, TOTAL_MEMORY_MB);
            d6 = this.getHashtableData(hashtable3, CPU_USAGE_PCT);
            d7 = this.getHashtableData(hashtable3, PCT_OF_STOPPED_SYSTEM_DURING_GC);
            d8 = this.getHashtableData(hashtable3, PAGE_FAULTS_DURING_GC);
            d10 = this.getHashtableData(hashtable3, JVM_LOCK_CONTENTION_COUNT);
            d11 = this.getHashtableData(hashtable3, JVM_DEADLOCKED_THREADS);
            d12 = this.getHashtableData(hashtable3, CURRENT_AUDIT_EVENTS_IN_QUEUE);
            d3 = d2 > 0.0 ? d / d4 * 100.0 : -5.0;
            if (this.prevHash != null && this.prevHash.size() > 0 && !this.prevHash.isEmpty()) {
                Hashtable hashtable4 = (Hashtable)this.prevHash.get(string2);
                if (hashtable4 == null || hashtable4.size() == 0 || hashtable4.isEmpty() || hashtable3 == null || hashtable3.size() == 0 || hashtable3.isEmpty()) continue;
                double d13 = this.getHashtableData(hashtable3, FULL_GC);
                double d14 = this.getHashtableData(hashtable4, FULL_GC);
                double d15 = this.getHashtableData(hashtable3, SESSION_COUNT);
                double d16 = this.getHashtableData(hashtable4, SESSION_COUNT);
                double d17 = -5.0;
                double d18 = -5.0;
                if (bl) {
                    this.timeSinceLastTest = 1.0;
                }
                if (d13 < 0.0 || d14 < 0.0) {
                    d17 = -5.0;
                } else {
                    d17 = d13 - d14;
                    if (d17 < 0.0) {
                        d17 = -5.0;
                        d9 = -5.0;
                    } else {
                        d9 = d17 / this.timeSinceLastTest;
                    }
                }
                if (d15 < 0.0 || d16 < 0.0) {
                    d5 = -5.0;
                } else {
                    d5 = d15 - d16;
                    if (d5 < 0.0) {
                        d5 = -5.0;
                    }
                }
                if (bl || debug) {
                    this.printOut("sessionCount  :" + d5);
                    this.printOut("freeJVMMemory  :" + d);
                    this.printOut("pctFreeJVMMemory  :" + d3);
                    this.printOut("totalJVMMemory  :" + d4);
                    this.printOut("cpuUsagePCT  :" + d6);
                    this.printOut("stoppedSystemPCT  :" + d7);
                    this.printOut("pageFaultsDuringGC  :" + d8);
                    this.printOut("currFullGC  :" + d13);
                    this.printOut("prevFullGC  :" + d14);
                    this.printOut("fullGC   :" + d17);
                    this.printOut("fullGCRate   :" + d9);
                    this.printOut("jvmLockContention   :" + d10);
                    this.printOut("jvmDeadLockedThreads   :" + d11);
                    this.printOut("currAuditEventInQueue   :" + d12);
                }
            }
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d));
            arrayList.add(new Double(this.round(d3, 2)));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(this.round(d6, 2)));
            arrayList.add(new Double(this.round(d7, 2)));
            arrayList.add(new Double(this.round(d8, 2)));
            arrayList.add(new Double(this.round(d9, 2)));
            arrayList.add(new Double(d10));
            arrayList.add(new Double(d11));
            arrayList.add(new Double(d12));
            this.printOut("Info :" + string2 + "  MeasureArrayList  :" + arrayList);
            if (!bl) {
                this.addNewMeasure(string2, arrayList);
            }
            d5 = -5.0;
            d4 = -5.0;
            d = -5.0;
            d6 = -5.0;
            d7 = -5.0;
            d8 = -5.0;
            d9 = -5.0;
            d10 = -5.0;
            d11 = -5.0;
            d12 = -5.0;
        }
        this.prevHash = hashtable2;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        BobiLSPerfTest bobiLSPerfTest = new BobiLSPerfTest(stringArray);
        int n = 0;
        int n2 = 1;
        while (n < n2) {
            ++n;
            bobiLSPerfTest.debugComputeMeasures(new Hashtable(), true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static {
        attrArrayList.add(SESSION_COUNT);
        attrArrayList.add(FREE_MEMORY_MB);
        attrArrayList.add(MAX_MEMORY_MB);
        attrArrayList.add(TOTAL_MEMORY_MB);
        attrArrayList.add(CPU_USAGE_PCT);
        attrArrayList.add(PCT_OF_STOPPED_SYSTEM_DURING_GC);
        attrArrayList.add(PAGE_FAULTS_DURING_GC);
        attrArrayList.add(FULL_GC);
        attrArrayList.add(JVM_LOCK_CONTENTION_COUNT);
        attrArrayList.add(JVM_DEADLOCKED_THREADS);
        attrArrayList.add(CURRENT_AUDIT_EVENTS_IN_QUEUE);
        for (int i = 0; i < 11; ++i) {
            dummymeasureArrayList.add(new Double(-5.0));
        }
    }
}

