/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class BitBuktIssueTest
extends GenericTest {
    protected static final String DEFAULT_SERVICE_URL = "https://api.bitbucket.org/";
    protected static String bitBucketVersion = "2.0";
    protected static String resourcePath = "/repositories/";
    protected static String issues = "/issues";
    protected static String pagelength = "?pagelen=100";
    private static EgDateInfo dateInfo = new EgDateInfo();
    public Hashtable newHash = new Hashtable();
    public Hashtable openHash = new Hashtable();
    public Hashtable closedHash = new Hashtable();
    public Hashtable resolvedHash = new Hashtable();
    public Hashtable wontfixHash = new Hashtable();
    public Hashtable onholdHash = new Hashtable();
    public Hashtable invalidHash = new Hashtable();
    public Hashtable duplicateHash = new Hashtable();
    public Hashtable watchingHash = new Hashtable();
    public Hashtable myIssueHash = new Hashtable();
    private String user = "";
    private String password = "";
    private String excluded_repositories = "none";
    private String encodedAuth = "";
    private String targetHost = "";
    private String show_closed_issues_dd = "";
    private String show_resolved_issues_dd = "";
    private String show_wontfix_issues_dd = "";
    private String show_onhold_issues_dd = "";
    private String show_invalid_issues_dd = "";
    private String show_duplicate_issues_dd = "";
    private boolean isClosedIssues = false;
    private boolean isResolvedIssues = false;
    private boolean isWontfixIssues = false;
    private boolean isOnholdIssues = false;
    private boolean isInvalidIssues = false;
    private boolean isDuplicateIssues = false;
    protected ArrayList excludedRepos_al = new ArrayList();

    public BitBuktIssueTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            this.user = this.getValueForParam("Username");
            this.password = this.getValueForParam("password");
            this.excluded_repositories = this.getValueForParam("excluded_repositories");
            this.show_closed_issues_dd = this.getValueForParam("show_closed_issues_dd");
            this.show_resolved_issues_dd = this.getValueForParam("show_resolved_issues_dd");
            this.show_wontfix_issues_dd = this.getValueForParam("show_wontfix_issues_dd");
            this.show_onhold_issues_dd = this.getValueForParam("show_onhold_issues_dd");
            this.show_invalid_issues_dd = this.getValueForParam("show_invalid_issues_dd");
            this.show_duplicate_issues_dd = this.getValueForParam("show_duplicate_issues_dd");
            this.encodedAuth = new String(Base64.encode((String)(this.user + ":" + this.password)));
            this.isClosedIssues = this.show_closed_issues_dd != null && this.show_closed_issues_dd.trim().equalsIgnoreCase("true");
            this.isResolvedIssues = this.show_resolved_issues_dd != null && this.show_resolved_issues_dd.trim().equalsIgnoreCase("true");
            this.isWontfixIssues = this.show_wontfix_issues_dd != null && this.show_wontfix_issues_dd.trim().equalsIgnoreCase("true");
            this.isOnholdIssues = this.show_onhold_issues_dd != null && this.show_onhold_issues_dd.trim().equalsIgnoreCase("true");
            this.isInvalidIssues = this.show_invalid_issues_dd != null && this.show_invalid_issues_dd.trim().equalsIgnoreCase("true");
            this.isDuplicateIssues = this.show_duplicate_issues_dd != null && this.show_duplicate_issues_dd.trim().equalsIgnoreCase("true");
            if (this.excluded_repositories != null && !this.excluded_repositories.trim().equalsIgnoreCase("none")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.excluded_repositories, ",");
                this.excludedRepos_al = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    this.excludedRepos_al.add(string);
                }
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Exception :", "[ " + this.entity + " ] Exception occured in BitBuktReposTest(String args[]) for " + this.targetHost, throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public void freeTest() {
        this.newHash = new Hashtable();
        this.openHash = new Hashtable();
        this.closedHash = new Hashtable();
        this.resolvedHash = new Hashtable();
        this.wontfixHash = new Hashtable();
        this.onholdHash = new Hashtable();
        this.invalidHash = new Hashtable();
        this.duplicateHash = new Hashtable();
        this.watchingHash = new Hashtable();
        this.myIssueHash = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            ArrayList<Double> arrayList = null;
            BitBuktHelper bitBuktHelper = new BitBuktHelper();
            Hashtable hashtable2 = bitBuktHelper.getRepositoriesList(this.reportingName, this.user, this.encodedAuth);
            if (hashtable2 != null) {
                Set set = hashtable2.keySet();
                for (String string : set) {
                    if (string != null && this.excludedRepos_al.contains(string)) continue;
                    ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList5 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList6 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList7 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList8 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList9 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList10 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList11 = new ArrayList<ArrayList>();
                    String string2 = (String)hashtable2.get(string);
                    arrayList = new ArrayList<Double>();
                    String string3 = DEFAULT_SERVICE_URL + bitBucketVersion + resourcePath + string2 + issues + pagelength;
                    JSONObject jSONObject = this.getJsonObject(string3);
                    Long l = 0L;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    double d9 = 0.0;
                    double d10 = 0.0;
                    if (jSONObject != null) {
                        l = (Long)jSONObject.get((Object)"size");
                        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"values");
                        if (jSONArray == null || jSONArray.isEmpty()) continue;
                        for (JSONObject jSONObject2 : jSONArray) {
                            String string4;
                            JSONObject jSONObject3;
                            JSONObject jSONObject4;
                            Object object;
                            if (jSONObject2 == null) continue;
                            String string5 = (String)jSONObject2.get((Object)"state");
                            if (string5.equalsIgnoreCase("new")) {
                                d += 1.0;
                                arrayList2.add(this.getDDlist(jSONObject2));
                                this.newHash.put(string, arrayList2);
                            } else if (string5.equalsIgnoreCase("open")) {
                                d2 += 1.0;
                                arrayList3.add(this.getDDlist(jSONObject2));
                                this.openHash.put(string, arrayList3);
                            } else if (string5.equalsIgnoreCase("closed")) {
                                d3 += 1.0;
                                arrayList4.add(this.getDDlist(jSONObject2));
                                if (this.isClosedIssues) {
                                    this.closedHash.put(string, arrayList4);
                                }
                            } else if (string5.equalsIgnoreCase("resolved")) {
                                d4 += 1.0;
                                arrayList5.add(this.getDDlist(jSONObject2));
                                if (this.isResolvedIssues) {
                                    this.resolvedHash.put(string, arrayList5);
                                }
                            } else if (string5.equalsIgnoreCase("wontfix")) {
                                d5 += 1.0;
                                arrayList6.add(this.getDDlist(jSONObject2));
                                if (this.isWontfixIssues) {
                                    this.wontfixHash.put(string, arrayList6);
                                }
                            } else if (string5.equalsIgnoreCase("on hold")) {
                                d6 += 1.0;
                                arrayList7.add(this.getDDlist(jSONObject2));
                                if (this.isOnholdIssues) {
                                    this.onholdHash.put(string, arrayList7);
                                }
                            } else if (string5.equalsIgnoreCase("invalid")) {
                                d7 += 1.0;
                                arrayList8.add(this.getDDlist(jSONObject2));
                                if (this.isInvalidIssues) {
                                    this.invalidHash.put(string, arrayList8);
                                }
                            } else if (string5.equalsIgnoreCase("duplicate")) {
                                d8 += 1.0;
                                arrayList9.add(this.getDDlist(jSONObject2));
                                if (this.isDuplicateIssues) {
                                    this.duplicateHash.put(string, arrayList9);
                                }
                            }
                            JSONObject jSONObject5 = (JSONObject)jSONObject2.get((Object)"assignee");
                            if (jSONObject5 != null && ((String)(object = ((String)jSONObject5.get((Object)"nickname")).trim())).equalsIgnoreCase(this.user)) {
                                d10 += 1.0;
                                arrayList11.add(this.getDDlist(jSONObject2));
                                this.myIssueHash.put(string, arrayList11);
                            }
                            if ((object = (JSONObject)jSONObject2.get((Object)"links")) == null || (jSONObject4 = (JSONObject)object.get((Object)"watch")) == null || (jSONObject3 = this.getJsonObject(string4 = (String)jSONObject4.get((Object)"href"))) != null) continue;
                            d9 += 1.0;
                            arrayList10.add(this.getDDlist(jSONObject2));
                            this.watchingHash.put(string, arrayList10);
                        }
                        arrayList.add(new Double(l.longValue()));
                        arrayList.add(new Double(d));
                        arrayList.add(new Double(d2));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d4));
                        arrayList.add(new Double(d5));
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d7));
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d9));
                        arrayList.add(new Double(d10));
                    }
                    this.addNewMeasure(string, arrayList);
                }
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
    }

    public JSONObject getJsonObject(String string) {
        String string2 = "";
        JSONObject jSONObject = null;
        String string3 = "";
        try {
            string2 = string;
            Client client = Client.create();
            WebResource webResource = client.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            JSONParser jSONParser = new JSONParser();
            Object object = null;
            if (n == 204) {
                return null;
            }
            String string4 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                object = jSONParser.parse(string4);
                jSONObject = (JSONObject)object;
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Invalid Username or Password -failed to get bitbucket metrics");
                return null;
            }
            if (n == 404 && (string3 = (String)(jSONObject = (JSONObject)(object = jSONParser.parse(string4))).get((Object)"type")).equalsIgnoreCase("error")) {
                return null;
            }
        }
        catch (Exception exception) {
            String string5 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string5);
        }
        return jSONObject;
    }

    public ArrayList getDDlist(JSONObject jSONObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (jSONObject == null) {
            return arrayList;
        }
        try {
            String string = "";
            String string2 = (String)jSONObject.get((Object)"priority");
            String string3 = (String)jSONObject.get((Object)"kind");
            String string4 = (String)jSONObject.get((Object)"title");
            Long l = (Long)jSONObject.get((Object)"votes");
            Long l2 = (Long)jSONObject.get((Object)"watches");
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"assignee");
            if (jSONObject2 != null) {
                string = (String)jSONObject2.get((Object)"display_name");
            }
            String string5 = (String)jSONObject.get((Object)"created_on");
            String string6 = string5.substring(0, 19);
            String string7 = this.Dateformat(string6);
            String string8 = (String)jSONObject.get((Object)"updated_on");
            String string9 = string8.substring(0, 19);
            String string10 = this.Dateformat(string9);
            arrayList.add(string4);
            arrayList.add(string3);
            arrayList.add(string2);
            arrayList.add(l);
            arrayList.add(l2);
            arrayList.add(string);
            arrayList.add(string7);
            arrayList.add(string10);
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
        return arrayList;
    }

    private String Dateformat(String string) {
        String string2 = "";
        try {
            Locale locale = Locale.US;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", locale);
            Date date = simpleDateFormat.parse(string);
            String string3 = Calendar.getInstance().getTimeZone().getID();
            Date date2 = new Date(date.getTime() + (long)TimeZone.getTimeZone(string3).getOffset(date.getTime()));
            long l = date2.getTime();
            string2 = dateInfo.egetDate(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string4 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string4);
        }
        return string2;
    }
}

