/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Locale;

public abstract class BTMBase
extends APMBase {
    protected Socket cliSock = null;
    protected ObjectOutputStream oos = null;
    protected static final String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected static final SimpleDateFormat mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a", Locale.US);
    protected static final String utcDatePattern = "dd/MM/yy hh:mm:ss a z";
    protected static final SimpleDateFormat utcSDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a z", Locale.US);
    protected static final String btmSecurity = "BTM";

    public BTMBase(String[] args) {
        super(args);
        try {
            BTMOffloadAPMSocketConfiguration configuration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
            this.initComponentWatcher(APMLanguage.JAVA, configuration);
            String timeoutString = this.getValueForParam("timeout");
            if (!this.entity.equalsIgnoreCase("JavaExceptionsTest") && !this.entity.equalsIgnoreCase("HttpStatusCodeTest")) {
                try {
                    int timeOutInSeconds;
                    this.socketTimeout = timeOutInSeconds = Integer.parseInt(timeoutString);
                }
                catch (Exception e) {
                    AgentLogger.testLogger.error("{}  socketTimeout {}", (Object)this.loggerDispStr, (Object)e);
                    this.socketTimeout = 1000;
                }
                String portString = this.getValueForParam("BTM_Port");
                AgentLogger.testLogger.debug("{} [ {} ] trgtHost = {} applicationName = {} portString = {} ", new Object[]{this.loggerDispStr, this.entity, this.trgtHost, this.applicationName, portString});
                try {
                    this.BTM_Port = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    AgentLogger.testLogger.error("{} BTM_Port value {} is invalid. Connecting to default BTM port {} ", new Object[]{this.loggerDispStr, portString, nfe});
                }
            }
            AgentLogger.testLogger.debug("{}  socketTimeout: {}  BTM_Port : {}", new Object[]{this.loggerDispStr, timeoutString, this.BTM_Port});
        }
        catch (Exception e) {
            AgentLogger.testLogger.error("{} Exception in BTMBase Constructor {}", (Object)this.loggerDispStr, (Object)e);
        }
    }
}

