/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Container;
import com.eg.apm.ContainerInstanceFactory;
import com.eg.apm.ContainersService;
import com.eg.apm.EgApmMainAgentInfo;
import com.eg.apm.KubernetesAPI;
import com.eg.apm.ProcessBasedDiscoveryThreadsController;
import com.eg.jtm.BTMConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ApmDiscoveryContributor
extends Thread {
    String sep = System.getProperty("file.separator");
    private static final String loggerDispStr = "[ApmDiscoveryContributor]";
    private static final String winCommand_1 = "cmd /c netstat -aonp tcp | findstr ";
    private static final String winCommand_2 = "| findstr LISTENING";
    private static final long minSleep = 50L;
    private static long lastModifiedTime = -1L;
    private static long lastAgentTestsModifiedTime = -1L;
    private static boolean agentDiscoverEnabled = true;
    private static long lastCleanupiniModifiedTime = -1L;
    private boolean isCleanUpEnabled = true;
    private static final String btmJarDefaultLogPath = String.valueOf(EgInstallInfo.getInstallDir()) + "/lib/apm/Java/default/logs";
    private String btmJarLogPath = "lib/apm/Java/default/logs";
    private static String btmJarLogPathWindows = "lib/apm/Java/default/logs";
    private String windowsTempPath = String.valueOf(System.getenv("TEMP")) + "/logs";
    private static final String linuxTempPath = "/tmp/logs";
    private static final String btmFileName = "BTMLog.log";
    private static final String cleanIni = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_CLEANUP;
    private int cleanUpThreshold = 3;
    private int checkForEvery = 3;
    long threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
    private int dicoveryMaxWaitTime = 15;
    private HashMap unknownContainers = new HashMap();
    private HashMap<String, Long> manualHttpReq = new HashMap();
    private long lastBtmLogDeletionTime = -1L;
    private long lastApmIniModifiedTime = -1L;
    private long lastRunTime = 0L;
    private int customPort = 7011;
    public static final String kubeSync = new String("kube");

    public ApmDiscoveryContributor() {
        this.setDaemon(true);
        this.setName("ApmDiscoveryContributor");
        this.start();
        APMDiscoveryLogger.discoveryLogger.info("{} ApmDiscoveryContributor Thread started ", (Object)loggerDispStr);
        this.readFromini();
        this.readEgMainAgentConfigs();
    }

    public ApmDiscoveryContributor(boolean noThread) {
    }

    @Override
    public void run() {
        this.suspendThread(30000L);
        this.isAgentTestsIniUpdated();
        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
        IniFile apmPort = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_APM_FILEPATH);
        int cusPort = this.getPort(apmPort, "APM_DISCOVERY", "Custom_Port_For_AutoManage");
        this.customPort = cusPort > 0 ? cusPort : 7011;
        ContainersService containersService = ContainersService.getInstance();
        while (true) {
            try {
                while (true) {
                    this.readEgMainAgentConfigs();
                    if (!agentDiscoverEnabled) {
                        this.suspendThread(180000L);
                        this.isAgentTestsIniUpdated();
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
                        if (!agentDiscoverEnabled) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} , Skipping the process..", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
                            continue;
                        }
                    }
                    try {
                        ProcessBasedDiscoveryThreadsController.getInstance().trackApmAppDiscoveryThreads();
                    }
                    catch (Throwable e) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to track app discovery : {}", (Object)loggerDispStr, (Object)e);
                    }
                    boolean iniUpdated = this.discoveryIniUpdated();
                    long currntTime = System.currentTimeMillis();
                    long diff = currntTime - this.lastRunTime;
                    boolean doProcess = false;
                    if (diff >= 300000L) {
                        this.isAgentTestsIniUpdated();
                        doProcess = true;
                    }
                    if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
                        APMDiscoveryLogger.discoveryLogger.trace("{} lastRunTime  : {} ", (Object)loggerDispStr, (Object)this.lastRunTime);
                        APMDiscoveryLogger.discoveryLogger.trace("{} iniUpdated  : {} ", (Object)loggerDispStr, (Object)iniUpdated);
                        APMDiscoveryLogger.discoveryLogger.trace("{} doProcess  : {} ", (Object)loggerDispStr, (Object)doProcess);
                        APMDiscoveryLogger.discoveryLogger.trace("{} fullyDiscoveredContainerIds : {} ", (Object)loggerDispStr, (Object)APMDiscoveryHelper.getDiscoveredList());
                    }
                    if (iniUpdated || doProcess) {
                        this.processDiscoveryDetails();
                        this.processForManualHttpRequest();
                        this.findKubernetesServiceNames();
                        this.lastRunTime = System.currentTimeMillis();
                    } else {
                        APMDiscoveryLogger.discoveryLogger.trace("{} ApmDiscoveryContributor.run()  suspending thread for 10sec....", (Object)loggerDispStr);
                    }
                    this.processBtmJarLogFileDeletion();
                    if (this.apmIniUpdated()) {
                        this.readFromApmIni();
                    }
                    this.suspendThread(ApmConfigManager.getInstance().getDiscoveryContributorSleepTime());
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)loggerDispStr, (Object)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findKubernetesServiceNames() {
        ContainersService containersService = ContainersService.getInstance();
        if (!containersService.isKubernetes()) {
            APMDiscoveryLogger.discoveryLogger.trace("{}  No Kubernetes Env found, Skipping findKubernetesServiceNames() process", (Object)loggerDispStr);
            return;
        }
        if (!ApmConfigManager.getInstance().isK8ServiceNameDiscoveryEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{}  Kubernetes service name discovery disabled, Skipping findKubernetesServiceNames() process", (Object)loggerDispStr);
            return;
        }
        try {
            boolean isKubeMasterReachable = true;
            ArrayList<IniHelper> addThis = new ArrayList<IniHelper>();
            ArrayList<IniHelper> deleteThis = new ArrayList<IniHelper>();
            String string = kubeSync;
            synchronized (string) {
                IniFile ini = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
                String kubeSubTemp = "KUBERNETES_DETAILS_TEMP";
                String[] kubeVarList = ini.getVariables(kubeSubTemp);
                Vector kubeValueList = ini.getAllValues(kubeSubTemp);
                APMDiscoveryLogger.discoveryLogger.trace("{} Kubernetes Service Name Discovery Starting.  Kubernetes ip : {}, port : {}, ssl : {}, masked token : {} , kubeValueList : {} ", new Object[]{loggerDispStr, containersService.getIp(), containersService.getPort(), containersService.isSSL(), EgCrypt.encrypt(containersService.getServiceToken()), kubeValueList});
                if (kubeVarList != null && kubeVarList.length > 0) {
                    KubernetesAPI sevAPI = KubernetesAPI.createInstance();
                    int i = 0;
                    while (i < kubeVarList.length) {
                        String dockerId = kubeVarList[i];
                        if (i == 2 && !sevAPI.isKubeMasterReachable()) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Kubernetes Master is unreachable, Skipping Kubernetes Service Name Discovery,  isKubeMasterReachable : {}", (Object)loggerDispStr, (Object)sevAPI.isKubeMasterReachable());
                            return;
                        }
                        if (dockerId != null && dockerId.length() > 0) {
                            String newValue = (String)kubeValueList.get(i);
                            StringTokenizer sf_tok = new StringTokenizer(newValue, ":");
                            String podName = "";
                            String nameSpace = "";
                            int count_tok = sf_tok.countTokens();
                            if (count_tok == 2) {
                                podName = sf_tok.nextToken();
                                nameSpace = sf_tok.nextToken();
                                ArrayList labelList = sevAPI.getLabelNameFromPod(nameSpace, podName);
                                isKubeMasterReachable = sevAPI.isKubeMasterReachable();
                                APMDiscoveryLogger.discoveryLogger.debug("{}  Doing Kubernetes Service Name Discovery for Namespace - {}, Pod - {} labelList : {}", new Object[]{loggerDispStr, nameSpace, podName, labelList});
                                boolean serviceFound = false;
                                String serviceName = "";
                                if (labelList != null && labelList.size() > 0) {
                                    try {
                                        serviceName = sevAPI.getServiceName(nameSpace, labelList, null);
                                        if (serviceName != null && serviceName.length() > 0) {
                                            serviceFound = true;
                                        }
                                        APMDiscoveryLogger.discoveryLogger.trace("{}  serviceName : {}", (Object)loggerDispStr, (Object)serviceName);
                                        if (serviceFound) {
                                            String serviceValue = String.valueOf(newValue) + ":" + serviceName;
                                            addThis.add(this.getIniHelper("KUBERNETES_DETAILS", dockerId, serviceValue));
                                            deleteThis.add(this.getIniHelper(kubeSubTemp, dockerId, dockerId));
                                        }
                                    }
                                    catch (Exception e) {
                                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do port finding : ", (Object)loggerDispStr, (Object)e);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                boolean stored = this.storeToIni(addThis, deleteThis);
                if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName addThis    : {}", (Object)loggerDispStr, addThis);
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName deleteThis :   {}", (Object)loggerDispStr, deleteThis);
                    APMDiscoveryLogger.discoveryLogger.trace("{} ServiceName stored : {}", (Object)loggerDispStr, (Object)stored);
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to process kunernetes service name discovery details : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    int getPort(IniFile file, String sub, String var) {
        try {
            String lastPortUsed = file.getValue(sub, var);
            if (lastPortUsed != null && lastPortUsed.length() > 0) {
                int port = Integer.parseInt(lastPortUsed);
                return port;
            }
        }
        catch (NumberFormatException e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving port from ini!!...{} ", (Object)loggerDispStr, (Object)e);
        }
        return 0;
    }

    private boolean isMaxDiscoveryTimeReached(String tempGuid, long thresh, long currentTime) {
        boolean doHttpReq = false;
        try {
            if (this.manualHttpReq.containsKey(tempGuid)) {
                long prevousTime = this.manualHttpReq.get(tempGuid);
                long diff = currentTime - prevousTime;
                if (thresh >= diff) {
                    doHttpReq = true;
                }
            } else {
                doHttpReq = true;
                this.manualHttpReq.put(tempGuid, currentTime);
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process isMaxDiscoveryTimeReached() : {}", (Object)loggerDispStr, (Object)e);
        }
        return doHttpReq;
    }

    private void processForManualHttpRequest() {
        if (!ApmConfigManager.getInstance().isManualHttpInvocationEnabled()) {
            return;
        }
        try {
            ArrayList<IniHelper> deleteThis = new ArrayList<IniHelper>();
            ArrayList addThis = new ArrayList();
            ArrayList<IniHelper> addThisToTrash = new ArrayList<IniHelper>();
            IniFile ini = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
            String tempDiscSub = "JAVA_SERVER_DETAILS_DO_HTTP_REQ";
            String[] discVarList = ini.getVariables(tempDiscSub);
            Vector discValueList = ini.getAllValues(tempDiscSub);
            long thresh = this.dicoveryMaxWaitTime * 60 * 1000;
            long currentTime = System.currentTimeMillis();
            int i = 0;
            while (i < discVarList.length) {
                String ipDetailsVar = discVarList[i];
                if (ipDetailsVar != null && ipDetailsVar.length() > 0) {
                    String dataValue;
                    StringTokenizer sf_tok;
                    int count_tok;
                    int index = ipDetailsVar.indexOf("@");
                    String ipDetails = ipDetailsVar;
                    if (index > -1) {
                        ipDetails = ipDetailsVar.substring(index + 1);
                    }
                    if ((count_tok = (sf_tok = new StringTokenizer(dataValue = (String)discValueList.get(i), "#~#")).countTokens()) == 3) {
                        String pid = sf_tok.nextToken();
                        String tempGuid = sf_tok.nextToken();
                        if (!APMDiscoveryHelper.isInDiscoverdList(tempGuid) && this.isMaxDiscoveryTimeReached(tempGuid, thresh, currentTime)) {
                            String time = sf_tok.nextToken();
                            ArrayList<String> portList = this.getAllAvailablePort(pid);
                            APMDiscoveryLogger.discoveryLogger.trace("{}  Port list {} for  {} :{}", new Object[]{loggerDispStr, portList, ipDetails, tempGuid});
                            APMDiscoveryLogger.discoveryLogger.debug("{}  Going to do Http request for {} :{}  {}", new Object[]{loggerDispStr, ipDetails, pid, tempGuid});
                            this.doManualHttpRequest(ipDetails, portList);
                        } else {
                            this.manualHttpReq.remove(tempGuid);
                            deleteThis.add(APMUtils.getIniHelper(tempDiscSub, ipDetailsVar, ipDetails));
                            addThisToTrash.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_HTTP_CALL_DONE", String.valueOf(pid) + "@" + ipDetails, dataValue));
                            APMDiscoveryLogger.discoveryLogger.trace("{} {} is in discovered list so skipping manual request for  {}:{} ", new Object[]{loggerDispStr, tempGuid, ipDetails, pid});
                        }
                    }
                }
                ++i;
            }
            APMDiscoveryHelper.storeToIni(addThis, deleteThis);
            if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile()) {
                APMDiscoveryHelper.saveToIni(APMCleanUpUtils.getTrashFileName(), addThisToTrash, null);
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process processForManualHttpRequest() : {} ", (Object)loggerDispStr, (Object)e);
        }
    }

    public String makeGetRequest(String getUrl, String userAgent) {
        StringBuilder responseString = new StringBuilder();
        try {
            try {
                APMDiscoveryLogger.discoveryLogger.trace("{}  Doing Http request to {} with  {}", new Object[]{loggerDispStr, getUrl, userAgent});
                URL obj = new URL(getUrl);
                HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                con.setRequestMethod("GET");
                con.setConnectTimeout(500);
                con.setReadTimeout(100);
                con.setRequestProperty("User-Agent", userAgent);
                int responseCode = con.getResponseCode();
                responseString.append(" <h1>Response Code :</h1>").append(responseCode);
                if (responseCode != 200) {
                    responseString.append("GET request not worked : ");
                }
            }
            catch (Exception e) {
                responseString.append(e.getCause());
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do make http url hit  : {}", (Object)loggerDispStr, (Object)e);
        }
        return responseString.toString();
    }

    private void enableSsl() {
        EgSSL e = EgSSL.getInstance();
        EgSSL.enableSSL();
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object sock = null;
        try {
            MyX509TrustManager tm = new MyX509TrustManager();
            KeyManager[] km = null;
            TrustManager[] tma = new TrustManager[]{tm};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(km, tma, new SecureRandom());
            SSLSocketFactory sf1 = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sf1);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception ee) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to enable ssl to  make Http Request : {}", (Object)loggerDispStr, (Object)ee);
        }
    }

    private void doManualHttpRequest(String ipDetails, ArrayList portList) {
        block8: {
            try {
                int port;
                if (portList == null || portList.size() <= 0) break block8;
                int p = 0;
                while (p < portList.size()) {
                    try {
                        int port2 = Integer.parseInt((String)portList.get(p));
                        this.hitTheUrl(ipDetails, port2);
                    }
                    catch (NumberFormatException e) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process doManualHttpRequest() :{} ", (Object)loggerDispStr, (Object)e);
                    }
                    ++p;
                }
                if (!portList.contains("80")) {
                    port = Integer.parseInt("80");
                    this.hitTheUrl(ipDetails, port);
                }
                if (!portList.contains("8080")) {
                    port = Integer.parseInt("8080");
                    this.hitTheUrl(ipDetails, port);
                }
                if (!portList.contains("443")) {
                    port = Integer.parseInt("443");
                    this.hitTheUrl(ipDetails, port);
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process doManualHttpRequest() : {}", (Object)loggerDispStr, (Object)e);
            }
        }
    }

    private void hitTheUrl(String ipDetails, int port) {
        try {
            String getHttpUrl = "http://" + ipDetails + ":" + port + "/";
            String getHttpsUrl = "https://" + ipDetails + ":" + port + "/";
            String userAgent = "Mozilla/5.0";
            this.makeGetRequest(getHttpUrl, userAgent);
            this.enableSsl();
            this.makeGetRequest(getHttpsUrl, userAgent);
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    public ArrayList<String> getAllAvailablePort(String PID) {
        String OS2 = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        if (OS2.indexOf("win") >= 0) {
            try {
                Process proc = rt.exec(winCommand_1 + PID + winCommand_2);
                ArrayList<String> portList = this.getPortUsingPid(proc, "win");
                APMDiscoveryLogger.discoveryLogger.debug("{} Windows mode retrived all listening port for Pid [{}]", (Object)loggerDispStr, (Object)PID);
                return portList;
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while executing [Windows command] to get ports and PID - {} ", (Object)loggerDispStr, (Object)e);
            }
        } else if ((OS2.indexOf("nix") > -1 || OS2.indexOf("nux") > -1 || OS2.indexOf("aix") > -1) && ApmConfigManager.getInstance().isNetStatExistsOnLinux()) {
            String[] linuxCommand_1 = new String[]{"/bin/sh", "-c", "netstat -anlp | grep " + PID + " | grep LISTEN"};
            try {
                Process proc = rt.exec(linuxCommand_1);
                ArrayList<String> portList = this.getPortUsingPid(proc, "linux");
                APMDiscoveryLogger.discoveryLogger.debug("{} Linux mode retrived all listening port for Pid [{}]", (Object)loggerDispStr, (Object)PID);
                return portList;
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while executing [Linux command] to get ports and PID.... ", (Object)loggerDispStr, (Object)e);
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.debug("{} Unsuported OS: unable to get port details for Pid: [{}] return false ", (Object)loggerDispStr, (Object)PID);
            return null;
        }
        return null;
    }

    private ArrayList<String> getPortUsingPid(Process process, String OS2) {
        ArrayList<String> finalPortList = new ArrayList<String>();
        try {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String pidString = null;
            while ((pidString = stdInput.readLine()) != null) {
                int index;
                String IPAndPort;
                StringTokenizer tokenizer;
                String completeString;
                if (OS2.equals("win")) {
                    completeString = pidString.trim().replaceAll(" +", "#");
                    tokenizer = new StringTokenizer(completeString, "#");
                    tokenizer.nextElement();
                    IPAndPort = (String)tokenizer.nextElement();
                    if (IPAndPort == null || (index = IPAndPort.indexOf(":")) <= -1) continue;
                    finalPortList.add(IPAndPort.substring(index + 1));
                    continue;
                }
                completeString = pidString.trim().replaceAll(" +", "#");
                tokenizer = new StringTokenizer(completeString, "#");
                tokenizer.nextElement();
                tokenizer.nextElement();
                tokenizer.nextElement();
                IPAndPort = (String)tokenizer.nextElement();
                if (IPAndPort == null || (index = IPAndPort.indexOf(":")) <= -1) continue;
                String ipwithchar = IPAndPort.substring(index);
                finalPortList.add(ipwithchar.replaceAll(":", "").trim());
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while getting Port using master PID - {} ", (Object)loggerDispStr, (Object)e);
        }
        return finalPortList;
    }

    void processBtmJarLogFileDeletion() {
        try {
            long diff = System.currentTimeMillis() - this.lastBtmLogDeletionTime;
            APMDiscoveryLogger.discoveryLogger.trace("{} lastBtmLogDeletionTime  : {} , checkForEvery : {}", new Object[]{loggerDispStr, this.lastBtmLogDeletionTime, this.checkForEvery});
            if (diff >= this.threshTimeForDeletion) {
                Hashtable logFolderNamemap;
                this.lastBtmLogDeletionTime = System.currentTimeMillis();
                if (this.cleanupIniUpdated()) {
                    this.readFromini();
                }
                if (!this.isCleanUpEnabled) {
                    APMDiscoveryLogger.discoveryLogger.info("{} APM Discovery - BTM Jar log folder cleanup is not enabled", (Object)loggerDispStr);
                    return;
                }
                Container containerInstance = ContainerInstanceFactory.getInstance().getContainerInstance();
                if (containerInstance != null && (containerInstance.isDockerContainer() || containerInstance.isCrioContainer())) {
                    logFolderNamemap = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForDockerContainers(this.btmJarLogPath, logFolderNamemap, containerInstance);
                }
                if (APMUtils.isWindows()) {
                    logFolderNamemap = this.getBtmjarLogFolderNames(btmJarLogPathWindows);
                    this.processForStandAlone(btmJarLogPathWindows, logFolderNamemap);
                } else {
                    logFolderNamemap = this.getBtmjarLogFolderNames(this.btmJarLogPath);
                    this.processForStandAlone(this.btmJarLogPath, logFolderNamemap);
                }
                logFolderNamemap = this.getBtmjarLogFolderNames(btmJarDefaultLogPath);
                this.processForStandAlone(btmJarDefaultLogPath, logFolderNamemap);
                if (APMUtils.isWindows()) {
                    logFolderNamemap = this.getBtmjarLogFolderNames(this.windowsTempPath);
                    this.processForStandAlone(this.windowsTempPath, logFolderNamemap);
                } else {
                    logFolderNamemap = this.getBtmjarLogFolderNames(linuxTempPath);
                    this.processForStandAlone(linuxTempPath, logFolderNamemap);
                }
                HashMap btmPaths = this.getPathsSentByBTMJar();
                this.processIndividualPath(btmPaths);
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do apm discvoery log deletion process :{} ", (Object)loggerDispStr, (Object)e);
        }
    }

    private HashMap getPathsSentByBTMJar() {
        IniFile cleanFile = new IniFile(cleanIni);
        return APMUtils.getLinesAsMap(cleanFile, "LOG_PATHS", APMDiscoveryLogger.discoveryLogger);
    }

    private void processIndividualPath(HashMap logFolderNamemap) {
        if (logFolderNamemap.size() < 0) {
            return;
        }
        Iterator its = logFolderNamemap.entrySet().iterator();
        APMFileOperations apm = new APMFileOperations();
        long currentTime = System.currentTimeMillis();
        long thresh = this.cleanUpThreshold * 60 * 60 * 1000;
        ArrayList<IniHelper> deleteThis = new ArrayList<IniHelper>();
        while (its.hasNext()) {
            try {
                Map.Entry map = its.next();
                String guid = (String)map.getKey();
                String path = (String)map.getValue();
                path = path.substring(path.indexOf("^") + 1);
                File newFile = new File(path);
                if (newFile.exists()) {
                    String folderName;
                    long modifiedTime = newFile.lastModified();
                    if (currentTime - modifiedTime < thresh || !apm.deleteDirectory(folderName = path.replace(btmFileName, ""))) continue;
                    APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] has been deleted ", (Object)loggerDispStr, (Object)folderName);
                    deleteThis.add(APMUtils.getIniHelper("LOG_PATHS", guid, guid));
                    continue;
                }
                deleteThis.add(APMUtils.getIniHelper("LOG_PATHS", guid, guid));
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for a specific foldername : {}", (Object)loggerDispStr, (Object)e);
            }
        }
        if (deleteThis.size() > 0) {
            APMDiscoveryHelper.saveToIni(cleanIni, null, deleteThis);
            APMDiscoveryLogger.discoveryLogger.trace("{} Remove log paths from ini  : {} ", (Object)loggerDispStr, deleteThis);
        }
    }

    private void processForStandAlone(String path, Hashtable logFolderNamemap) {
        if (logFolderNamemap.size() < 0) {
            return;
        }
        APMDiscoveryLogger.discoveryLogger.info("{} Log path : {}, logFolderNamemap  : {}", new Object[]{loggerDispStr, path, logFolderNamemap});
        Iterator its = logFolderNamemap.entrySet().iterator();
        APMFileOperations apm = new APMFileOperations();
        long currentTime = System.currentTimeMillis();
        long thresh = this.cleanUpThreshold * 60 * 60 * 1000;
        while (its.hasNext()) {
            try {
                String fullPath;
                Map.Entry map = its.next();
                String folderName = (String)map.getKey();
                long value = (Long)map.getValue();
                long dateDiff = currentTime - value;
                if (dateDiff < thresh || !apm.deleteDirectory(fullPath = String.valueOf(path) + File.separator + folderName)) continue;
                APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] that belongs to {} has been deleted ", new Object[]{loggerDispStr, fullPath, folderName});
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for specific foldername {}", (Object)loggerDispStr, (Object)e);
            }
        }
    }

    private void processForDockerContainers(String path, Hashtable logFolderNamemap, Container containerInstance) {
        if (logFolderNamemap.size() < 0) {
            return;
        }
        Hashtable ipMap = containerInstance.getRunningContainerIpDetails();
        if (ipMap == null) {
            ipMap = new Hashtable();
        }
        APMDiscoveryLogger.discoveryLogger.info("{} ipMap  : {}", (Object)loggerDispStr, ipMap);
        APMDiscoveryLogger.discoveryLogger.info("{} Log path : {}, logFolderNamemap  : {}", new Object[]{loggerDispStr, path, logFolderNamemap});
        Iterator its = logFolderNamemap.entrySet().iterator();
        APMFileOperations apm = new APMFileOperations();
        long currentTime = System.currentTimeMillis();
        long thresh = this.cleanUpThreshold * 60 * 60 * 1000;
        while (its.hasNext()) {
            try {
                String fullPath;
                Map.Entry map = its.next();
                String folderName = (String)map.getKey();
                long value = (Long)map.getValue();
                long dateDiff = currentTime - value;
                if (dateDiff < thresh || ipMap.containsKey(folderName) || !apm.deleteDirectory(fullPath = String.valueOf(path) + File.separator + folderName)) continue;
                APMDiscoveryLogger.discoveryLogger.warn("{} Old eG_BTM log folder [{}] that belongs to {} has been deleted ", new Object[]{loggerDispStr, fullPath, folderName});
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do log folder deletion process for specific foldername : {}", (Object)loggerDispStr, (Object)e);
            }
        }
    }

    private Hashtable getBtmjarLogFolderNames(String logPath) {
        Hashtable<Object, Long> ht = new Hashtable<Object, Long>();
        try {
            String absPath = logPath;
            File file = new File(absPath);
            boolean exists = file.exists();
            boolean canWrite = file.canWrite();
            APMDiscoveryLogger.discoveryLogger.debug("{} Log path : {}, isExist : {} , canWrite :{} ", new Object[]{loggerDispStr, logPath, exists, canWrite});
            if (!exists || !canWrite) {
                return ht;
            }
            Object[] directories = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File current, String name) {
                    return new File(current, name).isDirectory();
                }
            });
            APMDiscoveryLogger.discoveryLogger.debug("{} Available folder names under {} : {} ", new Object[]{loggerDispStr, logPath, Arrays.toString(directories)});
            if (directories != null && directories.length > 0) {
                int i = 0;
                while (i < directories.length) {
                    Object foldername = directories[i];
                    String fullPath = String.valueOf(absPath) + File.separator + (String)foldername + File.separator + btmFileName;
                    File newFile = new File(fullPath);
                    if (newFile.exists()) {
                        long modifiedTime = newFile.lastModified();
                        ht.put(foldername, modifiedTime);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get BTM jar log folder name from {}: ", new Object[]{loggerDispStr, this.btmJarLogPath, e});
        }
        return ht;
    }

    private void readFromini() {
        block16: {
            boolean isCleanUpEnabledTemp = false;
            String btmLogPathTemp = null;
            String windowsBtmLogPathTemp = null;
            int cleanUpThresholdTemp = 3;
            int checkForEveryTemp = 3;
            try {
                try {
                    IniFile cleanUpIni = new IniFile(cleanIni);
                    String cleanUpStr = cleanUpIni.getValue("APM_DISCOVERY_CLEANUP", "Apm_Discovery_Cleanup");
                    cleanUpStr = cleanUpStr.trim();
                    if (cleanUpStr != null && cleanUpStr.length() > 0) {
                        isCleanUpEnabledTemp = Boolean.parseBoolean(cleanUpStr);
                    }
                    String btmLogPathTempStr = cleanUpIni.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location");
                    if ((btmLogPathTempStr = btmLogPathTempStr.trim()) != null && btmLogPathTempStr.length() > 0) {
                        btmLogPathTemp = btmLogPathTempStr;
                    }
                    String btmLogPathTempStr2 = cleanUpIni.getValue("APM_DISCOVERY_CLEANUP", "Btm_Jar_Log_Location_Windows");
                    if ((btmLogPathTempStr2 = btmLogPathTempStr2.trim()) != null && btmLogPathTempStr2.length() > 0) {
                        windowsBtmLogPathTemp = btmLogPathTempStr2;
                    }
                    String cleanUpThresholdTempStr = cleanUpIni.getValue("APM_DISCOVERY_CLEANUP", "Log_Cleanup_Threshold");
                    if ((cleanUpThresholdTempStr = cleanUpThresholdTempStr.trim()) != null && cleanUpThresholdTempStr.length() > 0) {
                        cleanUpThresholdTemp = Integer.parseInt(cleanUpThresholdTempStr);
                    }
                    String checkForEveryTempStr = cleanUpIni.getValue("APM_DISCOVERY_CLEANUP", "Check_Update_For_Btm_Logs");
                    if ((checkForEveryTempStr = checkForEveryTempStr.trim()) != null && checkForEveryTempStr.length() > 0) {
                        checkForEveryTemp = Integer.parseInt(checkForEveryTempStr);
                    }
                }
                catch (Exception e) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to read discovery clean up ini : ", (Object)loggerDispStr, (Object)e);
                    this.isCleanUpEnabled = isCleanUpEnabledTemp;
                    this.cleanUpThreshold = cleanUpThresholdTemp;
                    this.checkForEvery = checkForEveryTemp;
                    this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
                    if (btmLogPathTemp != null && btmLogPathTemp.length() > 0) {
                        this.btmJarLogPath = btmLogPathTemp;
                    }
                    if (windowsBtmLogPathTemp != null && windowsBtmLogPathTemp.length() > 0) {
                        btmJarLogPathWindows = windowsBtmLogPathTemp;
                    }
                    APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{loggerDispStr, this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.isCleanUpEnabled = isCleanUpEnabledTemp;
                this.cleanUpThreshold = cleanUpThresholdTemp;
                this.checkForEvery = checkForEveryTemp;
                this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
                if (btmLogPathTemp != null && btmLogPathTemp.length() > 0) {
                    this.btmJarLogPath = btmLogPathTemp;
                }
                if (windowsBtmLogPathTemp != null && windowsBtmLogPathTemp.length() > 0) {
                    btmJarLogPathWindows = windowsBtmLogPathTemp;
                }
                APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{loggerDispStr, this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
                throw throwable;
            }
            this.isCleanUpEnabled = isCleanUpEnabledTemp;
            this.cleanUpThreshold = cleanUpThresholdTemp;
            this.checkForEvery = checkForEveryTemp;
            this.threshTimeForDeletion = this.checkForEvery * 60 * 60 * 1000;
            if (btmLogPathTemp != null && btmLogPathTemp.length() > 0) {
                this.btmJarLogPath = btmLogPathTemp;
            }
            if (windowsBtmLogPathTemp != null && windowsBtmLogPathTemp.length() > 0) {
                btmJarLogPathWindows = windowsBtmLogPathTemp;
            }
            APMDiscoveryLogger.discoveryLogger.info("{} isCleanUpEnabled : {}, btmLogPath : {}, btmJarLogPathWindows : {}, cleanUpThreshold : {}, checkForEvery : {}, lastBtmLogDeletionTime : {}, windowsTempPath : {}, linuxTempPath : {}, btmJarDefaultLogPath : {} ", new Object[]{loggerDispStr, this.isCleanUpEnabled, this.btmJarLogPath, btmJarLogPathWindows, this.cleanUpThreshold, this.checkForEvery, this.lastBtmLogDeletionTime, this.windowsTempPath, linuxTempPath, btmJarDefaultLogPath});
        }
    }

    void processDiscoveryDetails() {
        try {
            ArrayList<IniHelper> addThis = new ArrayList<IniHelper>();
            ArrayList<String> guids = new ArrayList<String>();
            ArrayList<IniHelper> deleteThis = new ArrayList<IniHelper>();
            IniFile ini = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
            String tempDiscSub = "JAVA_SERVER_DETAILS_CONTAINER_BASED_TEMP";
            String tempGuidSub = "JAVA_UNIQUE_GUID_MAPPING_TEMP";
            String tempAppNameSub = "APPFLOW_SERVICE_AUTO_NAME_MAPPING_TEMP";
            String[] discVarList = ini.getVariables(tempDiscSub);
            Vector discValueList = ini.getAllValues(tempDiscSub);
            String[] guidVarList = ini.getVariables(tempGuidSub);
            Vector guidValueList = ini.getAllValues(tempGuidSub);
            Vector<String> guidList = new Vector<String>();
            guidList.addAll(Arrays.asList(guidVarList));
            String[] lines = ini.getLinesUnderSubject(tempAppNameSub);
            HashMap tempAppNameMap = APMDiscoveryHelper.getLinesAsMap(lines);
            boolean isContainerBased = false;
            if (discVarList != null && discVarList.length > 0) {
                Container containerInstance = ContainerInstanceFactory.getInstance().getContainerInstance();
                Hashtable ipMap = new Hashtable();
                Hashtable portMap = new Hashtable();
                if (containerInstance != null && containerInstance.isContainerZ()) {
                    isContainerBased = true;
                }
                if (!isContainerBased) {
                    return;
                }
                ipMap = containerInstance.getRunningContainerIpDetails();
                portMap = containerInstance.getContainerPortDetails();
                if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} is CONATAINERZ Server : {}", (Object)loggerDispStr, (Object)isContainerBased);
                    APMDiscoveryLogger.discoveryLogger.trace("{} CONATAINER port map() : {}", (Object)loggerDispStr, (Object)portMap);
                    APMDiscoveryLogger.discoveryLogger.trace("{} CONATAINER IP map() : {}", (Object)loggerDispStr, (Object)ipMap);
                    APMDiscoveryLogger.discoveryLogger.info("{}  tempAppNameMap() : {}", (Object)loggerDispStr, (Object)tempAppNameMap);
                    APMDiscoveryLogger.discoveryLogger.info("{} unknownContainers  : {}", (Object)loggerDispStr, (Object)this.unknownContainers);
                }
                int i = 0;
                while (i < discVarList.length) {
                    String discDetails = discVarList[i];
                    if (discDetails != null && discDetails.length() > 0) {
                        APMDiscoveryLogger.discoveryLogger.trace("{}  Doing CONTAINER ENV port check for  : {}", (Object)loggerDispStr, (Object)discDetails);
                        StringTokenizer sf_tok = new StringTokenizer(discDetails, ":");
                        String comp_Type = "";
                        String port = "";
                        int count_tok = sf_tok.countTokens();
                        if (count_tok == 3) {
                            String containerName = sf_tok.nextToken();
                            port = sf_tok.nextToken();
                            comp_Type = sf_tok.nextToken();
                            boolean portFound = false;
                            int serverPorts = 0;
                            if (containerName != null && containerName.length() > 0) {
                                try {
                                    if (portMap.containsKey(containerName)) {
                                        portFound = true;
                                        serverPorts = Integer.parseInt((String)portMap.get(containerName));
                                    } else {
                                        if (isContainerBased) {
                                            serverPorts = containerInstance.getDockerPort(containerName);
                                            APMDiscoveryLogger.discoveryLogger.info("{} containerName: {}, getDockerPort() : {}", new Object[]{loggerDispStr, containerName, serverPorts});
                                        }
                                        if (serverPorts == 0) {
                                            if (isContainerBased) {
                                                serverPorts = containerInstance.getPodPort(containerName);
                                                APMDiscoveryLogger.discoveryLogger.info("{} containerName: {}, getPodPort(): {}", new Object[]{loggerDispStr, containerName, serverPorts});
                                            }
                                            if (serverPorts != 0) {
                                                portFound = true;
                                            }
                                        } else {
                                            portFound = true;
                                        }
                                    }
                                    boolean ipFound = ipMap.containsKey(containerName);
                                    if (ipFound && serverPorts == 0) {
                                        if (ApmConfigManager.getInstance().isManageByCustomPortForDocker()) {
                                            serverPorts = this.customPort > 0 ? this.customPort : 7011;
                                            APMDiscoveryLogger.discoveryLogger.warn("{} {} port not found in 'docker inspect' cmd but its is available in list of running containers, so considering this as ghost container and using {} to manage the component.", new Object[]{loggerDispStr, containerName, serverPorts});
                                            portFound = true;
                                        } else {
                                            APMDiscoveryLogger.discoveryLogger.warn("{} DOCKER DISCOVERY - Unable to discover port for {}, So, Skipping the auto manage. Component type :{} , Contaiener ID :{} , ", new Object[]{loggerDispStr, containerName, comp_Type, containerName});
                                        }
                                    }
                                    if (!portFound || !ipFound) {
                                        boolean delete = this.isReachedToMaximumDeletionCounter(discDetails);
                                        if (delete) {
                                            APMDiscoveryLogger.discoveryLogger.warn("{} {} is in unknown container list and reached maximum counter for deletion and adding to deletion list.", new Object[]{loggerDispStr, containerName, discDetails});
                                            deleteThis.add(this.getIniHelper(tempDiscSub, discDetails, discDetails));
                                            deleteThis.add(this.getIniHelper(tempGuidSub, discDetails, discDetails));
                                            deleteThis.add(this.getIniHelper(tempAppNameSub, discDetails, discDetails));
                                            this.unknownContainers.remove(discDetails);
                                        } else {
                                            APMDiscoveryLogger.discoveryLogger.warn("{} container ip & port not found for {} & adding it into unknown containers list ", (Object)loggerDispStr, (Object)containerName);
                                            this.addToUnKnownContainers(discDetails);
                                        }
                                    }
                                    if (portFound) {
                                        String tempDiscoveryGuid;
                                        int index;
                                        String newVar = String.valueOf(containerName) + ":" + serverPorts + ":" + comp_Type;
                                        String newValue = (String)discValueList.get(i);
                                        if (newValue != null) {
                                            newValue = newValue.replace("#~#0#~#", "#~#" + serverPorts + "#~#");
                                        }
                                        if ((index = guidList.indexOf(discDetails)) > -1 && (tempDiscoveryGuid = (String)guidValueList.get(index)) != null && tempDiscoveryGuid.length() > 0) {
                                            String tempAppnameStr;
                                            if (!guids.contains(tempDiscoveryGuid) && !APMDiscoveryHelper.isInDiscoverdList(tempDiscoveryGuid)) {
                                                addThis.add(this.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", newVar, tempDiscoveryGuid));
                                                addThis.add(this.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", newVar, newValue));
                                                addThis.add(this.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", newVar, String.valueOf(System.currentTimeMillis())));
                                                tempAppnameStr = (String)tempAppNameMap.get(discDetails);
                                                if (tempAppnameStr != null && tempAppnameStr.length() > 0) {
                                                    addThis.add(this.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", newVar, tempAppnameStr));
                                                    deleteThis.add(this.getIniHelper(tempAppNameSub, discDetails, discDetails));
                                                }
                                                deleteThis.add(this.getIniHelper(tempGuidSub, discDetails, discDetails));
                                                deleteThis.add(this.getIniHelper(tempDiscSub, discDetails, discDetails));
                                                guids.add(tempDiscoveryGuid);
                                                APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
                                                if (componentIDRepository.isThisManaged(newVar)) {
                                                    String componentGuid = componentIDRepository.getComponentGuidFromTemp(newVar);
                                                    componentIDRepository.addToTempComponentRepository(componentGuid, tempDiscoveryGuid);
                                                    componentIDRepository.addToTempComponentRepository(tempDiscoveryGuid, componentGuid);
                                                    APMDiscoveryLogger.discoveryLogger.info("{} {} is already discovered and auto-managed with {}:{}, Skipping port docker finding and registering temporary id into repo", new Object[]{loggerDispStr, tempDiscoveryGuid, newVar, componentGuid});
                                                }
                                            } else {
                                                if (APMDiscoveryHelper.isInDiscoverdList(tempDiscoveryGuid)) {
                                                    APMDiscoveryLogger.discoveryLogger.warn("{} {} Already discovered, so skipping port finding for [{}] and adding to delete list : ", new Object[]{loggerDispStr, tempDiscoveryGuid, discDetails});
                                                }
                                                if ((tempAppnameStr = (String)tempAppNameMap.get(discDetails)) != null && tempAppnameStr.length() > 0) {
                                                    deleteThis.add(this.getIniHelper(tempAppNameSub, discDetails, discDetails));
                                                }
                                                deleteThis.add(this.getIniHelper(tempGuidSub, discDetails, discDetails));
                                                deleteThis.add(this.getIniHelper(tempDiscSub, discDetails, discDetails));
                                            }
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do port finding : {}", (Object)loggerDispStr, (Object)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            boolean stored = this.storeToIni(addThis, deleteThis);
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} addThis    : {}", (Object)loggerDispStr, addThis);
                APMDiscoveryLogger.discoveryLogger.trace("{} deleteThis :  {}", (Object)loggerDispStr, deleteThis);
                APMDiscoveryLogger.discoveryLogger.trace("{} guids :{}", (Object)loggerDispStr, guids);
                APMDiscoveryLogger.discoveryLogger.trace("{} stored : {}", (Object)loggerDispStr, (Object)stored);
            }
            if (stored && guids.size() > 0) {
                this.setStatus(guids);
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to process discovery details : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private void setStatus(ArrayList guids) {
        try {
            if (guids != null && guids.size() > 0) {
                int a = 0;
                while (a < guids.size()) {
                    String tempComponentGuid = (String)guids.get(a);
                    APMDiscoveryHelper.addToDiscoveredList(tempComponentGuid);
                    APMComponentIDRepository.getRepository().setStatusForBtmDiscovery(tempComponentGuid, true);
                    ++a;
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to set status for newly discovered Component GUIDS : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private boolean storeToIni(ArrayList addThis, ArrayList deleteThis) {
        return APMDiscoveryHelper.storeToIni(addThis, deleteThis);
    }

    private boolean discoveryIniUpdated() {
        boolean iniUpdated = false;
        long lastModified = IniFile.getLastModified(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apmdiscovery.ini file LastModified {}", (Object)loggerDispStr, (Object)lastModified);
        APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_apmdiscovery.ini lastModifiedTime {} ", (Object)loggerDispStr, (Object)lastModifiedTime);
        if (lastModifiedTime > -1L) {
            if (lastModified != lastModifiedTime) {
                iniUpdated = true;
                lastModifiedTime = lastModified;
            }
        } else {
            lastModifiedTime = lastModified;
            iniUpdated = true;
        }
        return iniUpdated;
    }

    private boolean isAgentTestsIniUpdated() {
        boolean iniUpdated;
        block8: {
            iniUpdated = false;
            try {
                long lastModified = IniFile.getLastModified(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_agentTests.ini");
                APMDiscoveryLogger.discoveryLogger.debug("{} Current eg_agentTests.ini file LastModified {}", (Object)loggerDispStr, (Object)lastModified);
                APMDiscoveryLogger.discoveryLogger.debug("{} Previous eg_agentTests.ini lastAgentTestsModifiedTime {} ", (Object)loggerDispStr, (Object)lastAgentTestsModifiedTime);
                if (lastAgentTestsModifiedTime > -1L) {
                    if (lastModified != lastAgentTestsModifiedTime) {
                        iniUpdated = true;
                        lastAgentTestsModifiedTime = lastModified;
                    }
                } else {
                    lastAgentTestsModifiedTime = lastModified;
                    iniUpdated = true;
                }
                if (!iniUpdated) break block8;
                try {
                    IniFile discover = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_agentTests.ini");
                    String flag = discover.getValue("AGENT_SETTINGS", "AgentDiscover");
                    if (flag != null && flag.length() != 0) {
                        agentDiscoverEnabled = Boolean.parseBoolean(flag);
                    }
                }
                catch (Exception e) {
                    APMDiscoveryLogger.discoveryLogger.error("{} Exception occurred while parsing AgentDiscover flag", (Object)loggerDispStr, (Object)e);
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.error("{} Exception occurred in isAgentTestsIniUpdated()", (Object)loggerDispStr, (Object)e);
            }
        }
        return iniUpdated;
    }

    private boolean cleanupIniUpdated() {
        boolean iniUpdated = false;
        long lastModified = IniFile.getLastModified(cleanIni);
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apmdiscovery_cleanup.inifile LastModified {} ", (Object)loggerDispStr, (Object)lastModified);
        APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_apmdiscovery_cleanup.ini lastModifiedTime {}", (Object)loggerDispStr, (Object)lastModifiedTime);
        if (lastCleanupiniModifiedTime > -1L) {
            if (lastModified != lastCleanupiniModifiedTime) {
                iniUpdated = true;
                lastCleanupiniModifiedTime = lastModified;
            }
        } else {
            lastCleanupiniModifiedTime = lastModified;
            iniUpdated = true;
        }
        return iniUpdated;
    }

    private void suspendThread(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.error("{} exception in Agent data Contributor thread while suspending Thread..{}", (Object)loggerDispStr, (Object)e);
        }
    }

    private IniHelper getIniHelper(final String sub, final String var, final String value) {
        IniHelper helper = new IniHelper(sub, var, value){

            public String toString() {
                StringBuilder build = new StringBuilder();
                build.append(sub);
                build.append("  ");
                build.append(var);
                build.append("=");
                build.append(value);
                return build.toString();
            }
        };
        return helper;
    }

    private void addToUnKnownContainers(String data) {
        try {
            if (this.unknownContainers.containsKey(data)) {
                int i = (Integer)this.unknownContainers.get(data);
                this.unknownContainers.put(data, i + 1);
            } else {
                this.unknownContainers.put(data, 1);
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private boolean isReachedToMaximumDeletionCounter(String data) {
        try {
            int i;
            if (this.unknownContainers.containsKey(data) && (i = ((Integer)this.unknownContainers.get(data)).intValue()) >= 5) {
                return true;
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do process discovery details : ", (Object)loggerDispStr, (Object)e);
        }
        return false;
    }

    private void readFromApmIni() {
        try {
            String apmIniPath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_APM_FILEPATH;
            IniFile apmIni = new IniFile(apmIniPath);
            String maxTime = apmIni.getValue("APM_DISCOVERY", "Discovery_Max_Wait_Time");
            maxTime = maxTime.trim();
            if (maxTime != null && maxTime.length() > 0) {
                this.dicoveryMaxWaitTime = Integer.parseInt(maxTime);
            }
            APMDiscoveryLogger.discoveryLogger.debug("{} dicoveryMaxWaitTime :  {} ", (Object)loggerDispStr, (Object)this.dicoveryMaxWaitTime);
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do read ini file : {}", (Object)loggerDispStr, (Object)e);
        }
    }

    private boolean apmIniUpdated() {
        boolean iniUpdated = false;
        long lastModified = IniFile.getLastModified(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_APM_FILEPATH);
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apm.ini file LastModified : {}, lastModifiedTime : {}", new Object[]{loggerDispStr, lastModified, lastModifiedTime});
        if (this.lastApmIniModifiedTime > -1L) {
            if (lastModified != this.lastApmIniModifiedTime) {
                iniUpdated = true;
                this.lastApmIniModifiedTime = lastModified;
            }
        } else {
            this.lastApmIniModifiedTime = lastModified;
            iniUpdated = true;
        }
        return iniUpdated;
    }

    private void readEgMainAgentConfigs() {
        EgApmMainAgentInfo egMainAgent = EgApmMainAgentInfo.getInstance();
        egMainAgent.setMaxDokcerThreads(EgMainAgent.maxDockerThreads);
        egMainAgent.setUaid(EgMainAgent.uaid);
    }
}

