/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ATRenderTest
extends GenericTest {
    private final int num_Measures = 3;
    ArrayList al_folders = new ArrayList();
    private String logFilePath = null;
    private int i_jobsSucceeded = 0;
    private int i_jobsFailed = 0;
    private int i_jobsInQ = 0;
    public ArrayList ddSucceededList = new ArrayList();
    public ArrayList ddFailedList = new ArrayList();
    public ArrayList ddInQList = new ArrayList();
    public boolean runningFirstTime = true;
    public long l_lastTestTime = -1L;

    @Override
    public void freeTest() {
        this.ddSucceededList = new ArrayList();
        this.ddFailedList = new ArrayList();
        this.ddInQList = new ArrayList();
    }

    public ATRenderTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("inFolders");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",|;");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string2 = this.findAndReplaceString(stringTokenizer.nextToken(), "\\", "/");
            System.out.println("Folders = " + string2);
            this.al_folders.add(string2);
        }
        this.setMeasureCount(3);
    }

    public String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ATRenderTest aTRenderTest = new ATRenderTest(stringArray);
        aTRenderTest.computeMeasures(new Hashtable());
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        System.out.println("compute measure from ATRenderTest called");
        if (this.al_folders == null || this.al_folders.size() == 0) {
            this.logToErrorFile("ERROR", "ATRenderTest", "IN Folders not configured. Please configure in the eG admin console.");
            return;
        }
        int n = this.al_folders.size();
        if (this.runningFirstTime) {
            for (int i = 0; i < n; ++i) {
                String string = (String)this.al_folders.get(i);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                this.addNewMeasure(string, arrayList);
            }
            this.runningFirstTime = false;
            this.l_lastTestTime = System.currentTimeMillis();
            return;
        }
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> arrayList;
            String string = (String)this.al_folders.get(i);
            System.out.println("IN Folder = " + string);
            try {
                File file = new File(string);
                if (!file.exists()) {
                    this.logToErrorFile("ERROR", "ATRenderTest", "Configured IN folder - " + string + " - doesn't exist.");
                    arrayList = new ArrayList();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                if (!file.isDirectory()) {
                    this.logToErrorFile("ERROR", "ATRenderTest", "Configured IN folder - " + string + " - is not a folder.");
                    arrayList = new ArrayList();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                this.i_jobsSucceeded = 0;
                this.i_jobsFailed = 0;
                this.i_jobsInQ = 0;
                this.getInFolderStats(string);
                arrayList = new ArrayList();
                arrayList.add(new Double(this.i_jobsSucceeded));
                arrayList.add(new Double(this.i_jobsFailed));
                arrayList.add(new Double(this.i_jobsInQ));
                System.out.println("Measures from within try = " + string + " --> " + arrayList);
                this.addNewMeasure(string, arrayList);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                System.out.println("Measures from within catch = " + string + " --> " + arrayList);
                this.addNewMeasure(string, arrayList);
            }
        }
        this.l_lastTestTime = System.currentTimeMillis();
    }

    private void getInFolderStats(String string) {
        File file = new File(string);
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isFile()) continue;
                String string2 = file2.getName();
                long l = file2.lastModified();
                if (string2.indexOf(".good") != -1 && l > this.l_lastTestTime) {
                    ++this.i_jobsSucceeded;
                    this.ddSucceededList.add(string + "@" + string2 + "|" + new Date(l).toString());
                    continue;
                }
                if (string2.indexOf(".died") != -1 && l > this.l_lastTestTime) {
                    ++this.i_jobsFailed;
                    this.ddFailedList.add(string + "@" + string2 + "|" + new Date(l).toString());
                    continue;
                }
                if (string2.indexOf(".job") == -1) continue;
                ++this.i_jobsInQ;
                this.ddInQList.add(string + "@" + string2 + "|" + new Date(l).toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

