/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.client.MongoIterable;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoJsonSchemaResult;
import com.mongodb.jdbc.MongoSQLResultSet;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoSQLStatement
extends MongoStatement<BsonDocument>
implements Statement,
LoggingAspect$ajcMightHaveAspect {
    private final BsonInt32 formatVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoSQLStatement(MongoConnection conn, String databaseName) throws SQLException {
        super(conn, databaseName);
        LoggingAspect.ajc$perObjectBind(this);
        this.formatVersion = new BsonInt32(1);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, string));
            }
            this.checkClosed();
            this.closeExistingResultSet();
            BsonDocument stage = this.constructQueryDocument(sql, "mongosql", this.formatVersion);
            BsonDocument getSchemaCmd = this.constructSQLGetResultSchemaDocument(sql);
            try {
                MongoIterable<BsonDocument> iterable = this.currentDB.withCodecRegistry(MongoDriver.registry).aggregate(Collections.singletonList(stage), BsonDocument.class).maxTime(this.maxQuerySec, TimeUnit.SECONDS);
                if (this.fetchSize != 0) {
                    iterable = iterable.batchSize(this.fetchSize);
                }
                MongoJsonSchemaResult schemaResult = this.currentDB.withCodecRegistry(MongoDriver.registry).runCommand((Bson)getSchemaCmd, MongoJsonSchemaResult.class);
                MongoJsonSchema schema = schemaResult.schema.mongoJsonSchema;
                this.resultSet = new MongoSQLResultSet(this, iterable.cursor(), schema);
                return this.resultSet;
            }
            catch (MongoExecutionTimeoutException e) {
                throw new SQLTimeoutException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private BsonDocument constructSQLGetResultSchemaDocument(String sql) {
        try {
            BsonDocument command = new BsonDocument();
            command.put("sqlGetResultSchema", new BsonInt32(1));
            command.put("query", new BsonString(sql));
            command.put("schemaVersion", new BsonInt32(1));
            return command;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    static {
        MongoSQLStatement.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLStatement.java", MongoSQLStatement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeQuery", "com.mongodb.jdbc.MongoSQLStatement", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.ResultSet"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "constructSQLGetResultSchemaDocument", "com.mongodb.jdbc.MongoSQLStatement", "java.lang.String", "sql", "", "org.bson.BsonDocument"), 70);
    }
}

